/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.purpurmc.purpur.tool.Actionable;

public class ItemAxe
extends Item {
    protected static final Map<Block, Block> a = new ImmutableMap.Builder().put((Object)Blocks.at, (Object)Blocks.aB).put((Object)Blocks.X, (Object)Blocks.aq).put((Object)Blocks.az, (Object)Blocks.aH).put((Object)Blocks.ad, (Object)Blocks.ao).put((Object)Blocks.u, (Object)Blocks.aI).put((Object)Blocks.ae, (Object)Blocks.ap).put((Object)Blocks.ax, (Object)Blocks.aF).put((Object)Blocks.ab, (Object)Blocks.am).put((Object)Blocks.ay, (Object)Blocks.aG).put((Object)Blocks.ac, (Object)Blocks.an).put((Object)Blocks.av, (Object)Blocks.aD).put((Object)Blocks.Z, (Object)Blocks.ak).put((Object)Blocks.aw, (Object)Blocks.aE).put((Object)Blocks.aa, (Object)Blocks.al).put((Object)Blocks.au, (Object)Blocks.aC).put((Object)Blocks.Y, (Object)Blocks.aj).put((Object)Blocks.ph, (Object)Blocks.pi).put((Object)Blocks.pj, (Object)Blocks.pk).put((Object)Blocks.pq, (Object)Blocks.pr).put((Object)Blocks.ps, (Object)Blocks.pt).put((Object)Blocks.aA, (Object)Blocks.aJ).put((Object)Blocks.af, (Object)Blocks.ar).put((Object)Blocks.ai, (Object)Blocks.as).build();

    public ItemAxe(ToolMaterial material, float attackDamage, float attackSpeed, Item.Info properties) {
        super(properties.b(material, attackDamage, attackSpeed));
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        World level = context.q();
        BlockPosition clickedPos = context.a();
        EntityHuman player = context.o();
        if (ItemAxe.b(context)) {
            return EnumInteractionResult.e;
        }
        Optional<Actionable> optional = this.evaluateActionable(level, clickedPos, player, level.a_(clickedPos));
        if (optional.isEmpty()) {
            return EnumInteractionResult.e;
        }
        Actionable actionable = optional.get();
        IBlockData state = actionable.into().m(level.a_(clickedPos));
        ItemStack itemInHand = context.n();
        if (!CraftEventFactory.callEntityChangeBlockEvent(player, clickedPos, state)) {
            return EnumInteractionResult.e;
        }
        if (player instanceof EntityPlayer) {
            CriterionTriggers.N.a((EntityPlayer)player, clickedPos, itemInHand);
        }
        level.a(clickedPos, state, 11);
        actionable.drops().forEach((drop, chance) -> {
            if (level.z.j() < chance) {
                Block.a(level, clickedPos, context.k(), new ItemStack((IMaterial)drop));
            }
        });
        level.a(GameEvent.c, clickedPos, GameEvent.a.a(player, state));
        if (player != null) {
            itemInHand.a(1, (EntityLiving)player, context.p().a());
        }
        return EnumInteractionResult.a;
    }

    private static boolean b(ItemActionContext context) {
        EntityHuman player = context.o();
        return context.p().equals((Object)EnumHand.a) && player.fr().c(DataComponents.I) && !player.gp();
    }

    private Optional<Actionable> evaluateActionable(World level, BlockPosition pos, @Nullable EntityHuman player, IBlockData state) {
        Optional<Actionable> stripped = Optional.ofNullable((Actionable)level.purpurConfig.axeStrippables.get(state.b()));
        if (stripped.isPresent()) {
            level.a((Entity)(a.containsKey(state.b()) ? player : null), pos, SoundEffects.aI, SoundCategory.e, 1.0f, 1.0f);
            return stripped;
        }
        Optional<Actionable> previous = Optional.ofNullable((Actionable)level.purpurConfig.axeWeatherables.get(state.b()));
        if (previous.isPresent()) {
            ItemAxe.a(level, pos, WeatheringCopper.b(state).isPresent() ? player : null, state, SoundEffects.aJ, 3005);
            return previous;
        }
        Optional<Actionable> optional = Optional.ofNullable((Actionable)level.purpurConfig.axeWaxables.get(state.b()));
        if (optional.isPresent()) {
            ItemAxe.a(level, pos, HoneycombItem.b.get().containsKey((Object)state.b()) ? player : null, state, SoundEffects.aK, 3004);
            return optional;
        }
        return Optional.empty();
    }

    private static void a(World level, BlockPosition pos, @Nullable EntityHuman player, IBlockData state, SoundEffect sound, int levelEvent) {
        level.a((Entity)player, pos, sound, SoundCategory.e, 1.0f, 1.0f);
        level.a((Entity)player, levelEvent, pos, 0);
        if (state.b() instanceof BlockChest && state.c(BlockChest.d) != BlockPropertyChestType.a) {
            BlockPosition connectedBlockPos = BlockChest.b(pos, state);
            level.a(GameEvent.c, connectedBlockPos, GameEvent.a.a(player, level.a_(connectedBlockPos)));
            level.a((Entity)player, levelEvent, connectedBlockPos, 0);
        }
    }

    private Optional<IBlockData> a(IBlockData unstrippedState) {
        return Optional.ofNullable(a.get(unstrippedState.b())).map(block -> (IBlockData)block.m().b(BlockRotatable.d, unstrippedState.c(BlockRotatable.d)));
    }
}

