/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.DummyGeneratorAccess;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.purpurmc.purpur.PurpurConfig;

public class ItemBucket
extends Item
implements DispensibleContainerItem {
    @Nullable
    private static ItemStack itemLeftInHandAfterPlayerBucketEmptyEvent = null;
    public final FluidType a;

    public ItemBucket(FluidType content, Item.Info properties) {
        super(properties);
        this.a = content;
    }

    @Override
    public EnumInteractionResult a(World level, EntityHuman player, EnumHand hand) {
        BlockPosition blockPos2;
        ItemStack itemInHand = player.b(hand);
        MovingObjectPositionBlock playerPovHitResult = ItemBucket.a(level, player, this.a == FluidTypes.a ? RayTrace.FluidCollisionOption.b : RayTrace.FluidCollisionOption.a);
        if (playerPovHitResult.d() == MovingObjectPosition.EnumMovingObjectType.a) {
            return EnumInteractionResult.e;
        }
        if (playerPovHitResult.d() != MovingObjectPosition.EnumMovingObjectType.b) {
            return EnumInteractionResult.e;
        }
        BlockPosition blockPos = playerPovHitResult.b();
        EnumDirection direction = playerPovHitResult.c();
        BlockPosition blockPos1 = blockPos.a(direction);
        if (!level.a((Entity)player, blockPos) || !player.a(blockPos1, direction, itemInHand)) {
            return EnumInteractionResult.d;
        }
        if (this.a == FluidTypes.a) {
            IBlockData blockState = level.a_(blockPos);
            Block block = blockState.b();
            if (block instanceof IFluidSource) {
                IFluidSource bucketPickup = (IFluidSource)((Object)block);
                ItemStack dummyFluid = bucketPickup.a(player, DummyGeneratorAccess.INSTANCE, blockPos, blockState);
                if (dummyFluid.f()) {
                    return EnumInteractionResult.d;
                }
                PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent(level, player, blockPos, blockPos, playerPovHitResult.c(), itemInHand, dummyFluid.h(), hand);
                if (event.isCancelled()) {
                    player.cl.b();
                    return EnumInteractionResult.d;
                }
                ItemStack itemStack = bucketPickup.a(player, level, blockPos, blockState);
                if (!itemStack.f()) {
                    player.b(StatisticList.c.b(this));
                    bucketPickup.au_().ifPresent(sound -> player.a((SoundEffect)sound, 1.0f, 1.0f));
                    level.a((Entity)player, GameEvent.y, blockPos);
                    ItemStack itemStack1 = ItemLiquidUtil.a(itemInHand, player, CraftItemStack.asNMSCopy(event.getItemStack()));
                    if (!level.D_()) {
                        CriterionTriggers.k.a((EntityPlayer)player, itemStack);
                    }
                    return EnumInteractionResult.a.a(itemStack1);
                }
            }
            return EnumInteractionResult.d;
        }
        IBlockData blockState = level.a_(blockPos);
        BlockPosition blockPosition = blockPos2 = blockState.b() instanceof IFluidContainer && this.a == FluidTypes.c ? blockPos : blockPos1;
        if (this.emptyContents(player, level, blockPos2, playerPovHitResult, playerPovHitResult.c(), blockPos, itemInHand, hand)) {
            this.a((EntityLiving)player, level, itemInHand, blockPos2);
            if (player instanceof EntityPlayer) {
                CriterionTriggers.z.a((EntityPlayer)player, blockPos2, itemInHand);
            }
            player.b(StatisticList.c.b(this));
            ItemStack itemStack = ItemLiquidUtil.a(itemInHand, player, ItemBucket.b(itemInHand, player));
            return EnumInteractionResult.a.a(itemStack);
        }
        return EnumInteractionResult.d;
    }

    public static ItemStack b(ItemStack bucketStack, EntityHuman player) {
        if (itemLeftInHandAfterPlayerBucketEmptyEvent != null) {
            ItemStack itemInHand = itemLeftInHandAfterPlayerBucketEmptyEvent;
            itemLeftInHandAfterPlayerBucketEmptyEvent = null;
            return itemInHand;
        }
        return !player.gk() ? new ItemStack(Items.sk) : bucketStack;
    }

    @Override
    public void a(@Nullable EntityLiving entity, World level, ItemStack stack, BlockPosition pos) {
    }

    @Override
    public boolean a(@Nullable EntityLiving entity, World level, BlockPosition pos, @Nullable MovingObjectPositionBlock hitResult) {
        return this.emptyContents(entity, level, pos, hitResult, null, null, null, EnumHand.a);
    }

    public boolean emptyContents(@Nullable EntityLiving entity, World level, BlockPosition pos, @Nullable MovingObjectPositionBlock hitResult, EnumDirection direction, BlockPosition clicked, ItemStack itemstack, EnumHand hand) {
        boolean flag2;
        IFluidContainer liquidBlockContainer;
        FluidType fluidType = this.a;
        if (!(fluidType instanceof FluidTypeFlowing)) {
            return false;
        }
        FluidTypeFlowing flowingFluid = (FluidTypeFlowing)fluidType;
        IBlockData blockState = level.a_(pos);
        Block block = blockState.b();
        boolean canBeReplaced = blockState.a(this.a);
        boolean flag = entity != null && entity.cp();
        boolean flag1 = canBeReplaced || block instanceof IFluidContainer && (liquidBlockContainer = (IFluidContainer)((Object)block)).a(entity, level, pos, blockState, this.a);
        boolean bl = flag2 = blockState.l() || flag1 && (!flag || hitResult == null);
        if (flag2 && entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            PlayerBucketEmptyEvent event = CraftEventFactory.callPlayerBucketEmptyEvent(level, player, pos, clicked, direction, itemstack, hand);
            if (event.isCancelled()) {
                player.cl.b();
                return false;
            }
            Object object = event.getItemStack() != null ? (event.getItemStack().equals((Object)CraftItemStack.asNewCraftStack(Items.sk)) ? null : CraftItemStack.asNMSCopy(event.getItemStack())) : (itemLeftInHandAfterPlayerBucketEmptyEvent = ItemStack.l);
        }
        if (!flag2) {
            return hitResult != null && this.emptyContents(entity, level, hitResult.b().a(hitResult.c()), null, direction, clicked, itemstack, hand);
        }
        if ((level.H_().i() || level.isTheEnd() && !PurpurConfig.allowWaterPlacementInTheEnd) && this.a == FluidTypes.c) {
            int x2 = pos.u();
            int y2 = pos.v();
            int z2 = pos.w();
            level.a((Entity)entity, pos, SoundEffects.km, SoundCategory.e, 0.5f, 2.6f + (level.z.i() - level.z.i()) * 0.8f);
            for (int i2 = 0; i2 < 8; ++i2) {
                ((WorldServer)level).sendParticlesSource(null, Particles.ab, true, false, (double)x2 + Math.random(), (double)y2 + Math.random(), (double)z2 + Math.random(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof IFluidContainer) {
            IFluidContainer liquidBlockContainer1 = (IFluidContainer)((Object)block);
            if (this.a == FluidTypes.c) {
                liquidBlockContainer1.a(level, pos, blockState, flowingFluid.a(false));
                this.a(entity, (GeneratorAccess)level, pos);
                return true;
            }
        }
        if (!level.D_() && canBeReplaced && !blockState.n()) {
            level.b(pos, true);
        }
        if (!level.a(pos, this.a.g().g(), 11) && !blockState.y().b()) {
            return false;
        }
        this.a(entity, (GeneratorAccess)level, pos);
        return true;
    }

    protected void a(@Nullable EntityLiving entity, GeneratorAccess level, BlockPosition pos) {
        SoundEffect soundEvent = this.a.a(TagsFluid.b) ? SoundEffects.dh : SoundEffects.de;
        level.a((Entity)entity, pos, soundEvent, SoundCategory.e, 1.0f, 1.0f);
        level.a((Entity)entity, GameEvent.z, pos);
    }

    public FluidType a() {
        return this.a;
    }
}

