/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockEnderPortalFrame;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class ItemEnderEye
extends Item {
    public ItemEnderEye(Item.Info properties) {
        super(properties);
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        BlockPosition clickedPos;
        World level = context.q();
        IBlockData blockState = level.a_(clickedPos = context.a());
        if (!blockState.a(Blocks.gn) || blockState.c(BlockEnderPortalFrame.c).booleanValue()) {
            return EnumInteractionResult.e;
        }
        if (level.D_()) {
            return EnumInteractionResult.a;
        }
        IBlockData blockState1 = (IBlockData)blockState.b(BlockEnderPortalFrame.c, true);
        if (!CraftEventFactory.callEntityChangeBlockEvent(context.o(), clickedPos, blockState1)) {
            return EnumInteractionResult.e;
        }
        Block.a(blockState, blockState1, level, clickedPos);
        level.a(clickedPos, blockState1, 2);
        level.b(clickedPos, Blocks.gn);
        context.n().h(1);
        level.c(1503, clickedPos, 0);
        ShapeDetector.ShapeDetectorCollection blockPatternMatch = BlockEnderPortalFrame.b().a(level, clickedPos);
        if (blockPatternMatch != null) {
            BlockPosition blockPos = blockPatternMatch.a().b(-3, 0, -3);
            for (int i2 = 0; i2 < 3; ++i2) {
                for (int i1 = 0; i1 < 3; ++i1) {
                    BlockPosition blockPos1 = blockPos.b(i2, 0, i1);
                    level.a(blockPos1, true, null);
                    level.a(blockPos1, Blocks.gm.m(), 2);
                }
            }
            int viewDistance = level.getCraftServer().getViewDistance() * 16;
            BlockPosition soundPos = blockPos.b(1, 0, 1);
            WorldServer serverLevel = (WorldServer)level;
            for (EntityPlayer player : serverLevel.getPlayersForGlobalSoundGamerule()) {
                double deltaX = (double)soundPos.u() - player.dK();
                double deltaZ = (double)soundPos.w() - player.dQ();
                double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                double soundRadiusSquared = serverLevel.getGlobalSoundRangeSquared(config -> config.endPortalSoundRadius);
                if (!serverLevel.S().c(GameRules.Y) && distanceSquared > soundRadiusSquared) continue;
                if (distanceSquared > (double)(viewDistance * viewDistance)) {
                    double deltaLength = Math.sqrt(distanceSquared);
                    double relativeX = player.dK() + deltaX / deltaLength * (double)viewDistance;
                    double relativeZ = player.dQ() + deltaZ / deltaLength * (double)viewDistance;
                    player.g.b(new PacketPlayOutWorldEvent(1038, new BlockPosition((int)relativeX, soundPos.v(), (int)relativeZ), 0, true));
                    continue;
                }
                player.g.b(new PacketPlayOutWorldEvent(1038, soundPos, 0, true));
            }
        }
        return EnumInteractionResult.a;
    }

    @Override
    public int a(ItemStack stack, EntityLiving entity) {
        return 0;
    }

    @Override
    public EnumInteractionResult a(World level, EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        MovingObjectPositionBlock playerPovHitResult = ItemEnderEye.a(level, player, RayTrace.FluidCollisionOption.a);
        if (playerPovHitResult.d() == MovingObjectPosition.EnumMovingObjectType.b && level.a_(playerPovHitResult.b()).a(Blocks.gn)) {
            return EnumInteractionResult.e;
        }
        player.c(hand);
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            BlockPosition blockPos = serverLevel.a(StructureTags.a, player.dF(), 100, false);
            if (blockPos == null) {
                return EnumInteractionResult.c;
            }
            EntityEnderSignal eyeOfEnder = new EntityEnderSignal(level, player.dK(), player.f(0.5), player.dQ());
            eyeOfEnder.a(itemInHand);
            eyeOfEnder.a(Vec3D.a(blockPos));
            level.a(GameEvent.K, eyeOfEnder.dD(), GameEvent.a.a(player));
            if (!level.b(eyeOfEnder)) {
                return EnumInteractionResult.d;
            }
            if (player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                CriterionTriggers.n.a(serverPlayer, blockPos);
            }
            float f2 = MathHelper.h(level.z.i(), 0.33f, 0.5f);
            level.a(null, player.dK(), player.dM(), player.dQ(), SoundEffects.ju, SoundCategory.g, 1.0f, f2);
            itemInHand.a(1, (EntityLiving)player);
            player.b(StatisticList.c.b(this));
        }
        return EnumInteractionResult.b;
    }
}

