/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import io.papermc.paper.potion.PaperPotionMix;
import io.papermc.paper.potion.PotionMix;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import org.bukkit.NamespacedKey;

public class PotionBrewer {
    public static final int a = 20;
    public static final PotionBrewer b = new PotionBrewer(List.of(), List.of(), List.of());
    private final List<RecipeItemStack> c;
    private final List<PredicatedCombination<PotionRegistry>> d;
    private final List<PredicatedCombination<Item>> e;
    private final Object2ObjectLinkedOpenHashMap<NamespacedKey, PaperPotionMix> customMixes = new Object2ObjectLinkedOpenHashMap();

    PotionBrewer(List<RecipeItemStack> containers, List<PredicatedCombination<PotionRegistry>> potionMixes, List<PredicatedCombination<Item>> containerMixes) {
        this.c = containers;
        this.d = potionMixes;
        this.e = containerMixes;
    }

    public boolean a(ItemStack stack) {
        return this.b(stack) || this.c(stack) || this.isCustomIngredient(stack);
    }

    private boolean d(ItemStack stack) {
        for (RecipeItemStack ingredient : this.c) {
            if (!ingredient.a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean b(ItemStack stack) {
        for (PredicatedCombination<Item> mix : this.e) {
            if (!mix.b.a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean c(ItemStack stack) {
        for (PredicatedCombination<PotionRegistry> mix : this.d) {
            if (!mix.b.a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean a(Holder<PotionRegistry> potion) {
        for (PredicatedCombination<PotionRegistry> mix : this.d) {
            if (!mix.c.a(potion)) continue;
            return true;
        }
        return false;
    }

    public boolean a(ItemStack potion, ItemStack ingredient) {
        if (this.hasCustomMix(potion, ingredient)) {
            return true;
        }
        return this.d(potion) && (this.b(potion, ingredient) || this.c(potion, ingredient));
    }

    public boolean b(ItemStack potion, ItemStack ingredient) {
        for (PredicatedCombination<Item> mix : this.e) {
            if (!potion.a(mix.a) || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public boolean c(ItemStack potion, ItemStack ingredient) {
        Optional<Holder<PotionRegistry>> optional = potion.a(DataComponents.R, PotionContents.a).e();
        if (optional.isEmpty()) {
            return false;
        }
        for (PredicatedCombination<PotionRegistry> mix : this.d) {
            if (!mix.a.a(optional.get()) || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public ItemStack d(ItemStack ingredient, ItemStack potion) {
        if (potion.f()) {
            return potion;
        }
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.input().test(potion) || !mix.ingredient().test(ingredient)) continue;
            return mix.result().v();
        }
        Optional<Holder<PotionRegistry>> optional = potion.a(DataComponents.R, PotionContents.a).e();
        if (optional.isEmpty()) {
            return potion;
        }
        for (PredicatedCombination<Item> predicatedCombination : this.e) {
            if (!potion.a(predicatedCombination.a) || !predicatedCombination.b.a(ingredient)) continue;
            return PotionContents.a((Item)predicatedCombination.c.a(), optional.get());
        }
        for (PredicatedCombination<FeatureElement> predicatedCombination : this.d) {
            if (!predicatedCombination.a.a(optional.get()) || !predicatedCombination.b.a(ingredient)) continue;
            return PotionContents.a(potion.h(), predicatedCombination.c);
        }
        return potion;
    }

    public static PotionBrewer a(FeatureFlagSet enabledFeatures) {
        a builder = new a(enabledFeatures);
        PotionBrewer.a(builder);
        return builder.a();
    }

    public static void a(a builder) {
        builder.a(Items.up);
        builder.a(Items.xy);
        builder.a(Items.xB);
        builder.a(Items.up, Items.ra, Items.xy);
        builder.a(Items.xy, Items.xx, Items.xB);
        builder.a(Potions.a, Items.tc, Potions.c);
        builder.a(Potions.a, Items.mB, Potions.b);
        builder.a(Potions.a, Items.un, Potions.d);
        builder.a(Items.wi, Potions.Q);
        builder.a(Items.mI, Potions.S);
        builder.a(Items.b, Potions.T);
        builder.a(Items.cT, Potions.R);
        builder.a(Potions.d, Items.ws, Potions.e);
        builder.a(Potions.e, Items.mB, Potions.f);
        builder.a(Potions.e, Items.ur, Potions.g);
        builder.a(Potions.f, Items.ur, Potions.h);
        builder.a(Potions.g, Items.mB, Potions.h);
        builder.a(Items.ut, Potions.l);
        builder.a(Potions.l, Items.mB, Potions.m);
        builder.a(Items.wM, Potions.i);
        builder.a(Potions.i, Items.mB, Potions.j);
        builder.a(Potions.i, Items.tc, Potions.k);
        builder.a(Potions.i, Items.ur, Potions.q);
        builder.a(Potions.j, Items.ur, Potions.r);
        builder.a(Potions.q, Items.mB, Potions.r);
        builder.a(Potions.q, Items.tc, Potions.s);
        builder.a(Potions.d, Items.pP, Potions.t);
        builder.a(Potions.t, Items.mB, Potions.u);
        builder.a(Potions.t, Items.tc, Potions.v);
        builder.a(Potions.n, Items.ur, Potions.q);
        builder.a(Potions.o, Items.ur, Potions.r);
        builder.a(Items.tE, Potions.n);
        builder.a(Potions.n, Items.mB, Potions.o);
        builder.a(Potions.n, Items.tc, Potions.p);
        builder.a(Potions.d, Items.tg, Potions.w);
        builder.a(Potions.w, Items.mB, Potions.x);
        builder.a(Items.ux, Potions.y);
        builder.a(Potions.y, Items.tc, Potions.z);
        builder.a(Potions.y, Items.ur, Potions.A);
        builder.a(Potions.z, Items.ur, Potions.B);
        builder.a(Potions.A, Items.tc, Potions.B);
        builder.a(Potions.C, Items.ur, Potions.A);
        builder.a(Potions.D, Items.ur, Potions.A);
        builder.a(Potions.E, Items.ur, Potions.B);
        builder.a(Items.uq, Potions.C);
        builder.a(Potions.C, Items.mB, Potions.D);
        builder.a(Potions.C, Items.tc, Potions.E);
        builder.a(Items.ul, Potions.F);
        builder.a(Potions.F, Items.mB, Potions.G);
        builder.a(Potions.F, Items.tc, Potions.H);
        builder.a(Items.us, Potions.I);
        builder.a(Potions.I, Items.mB, Potions.J);
        builder.a(Potions.I, Items.tc, Potions.K);
        builder.a(Potions.a, Items.ur, Potions.L);
        builder.a(Potions.L, Items.mB, Potions.M);
        builder.a(Potions.d, Items.pp, Potions.O);
        builder.a(Potions.O, Items.mB, Potions.P);
    }

    public boolean isCustomIngredient(ItemStack stack) {
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.ingredient().test(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isCustomInput(ItemStack stack) {
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.input().test(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCustomMix(ItemStack input, ItemStack ingredient) {
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.input().test(input) || !mix.ingredient().test(ingredient)) continue;
            return true;
        }
        return false;
    }

    public void addPotionMix(PotionMix mix) {
        if (this.customMixes.containsKey((Object)mix.getKey())) {
            throw new IllegalArgumentException("Duplicate recipe ignored with ID " + String.valueOf(mix.getKey()));
        }
        this.customMixes.putAndMoveToFirst((Object)mix.getKey(), (Object)new PaperPotionMix(mix));
    }

    public boolean removePotionMix(NamespacedKey key) {
        return this.customMixes.remove((Object)key) != null;
    }

    public PotionBrewer reload(FeatureFlagSet flags) {
        return PotionBrewer.a(flags);
    }

    record PredicatedCombination<T>(Holder<T> a, RecipeItemStack b, Holder<T> c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PredicatedCombination.class, "from;ingredient;to", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PredicatedCombination.class, "from;ingredient;to", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PredicatedCombination.class, "from;ingredient;to", "a", "b", "c"}, this, o2);
        }
    }

    public static class a {
        private final List<RecipeItemStack> a = new ArrayList<RecipeItemStack>();
        private final List<PredicatedCombination<PotionRegistry>> b = new ArrayList<PredicatedCombination<PotionRegistry>>();
        private final List<PredicatedCombination<Item>> c = new ArrayList<PredicatedCombination<Item>>();
        private final FeatureFlagSet d;

        public a(FeatureFlagSet enabledFeatures) {
            this.d = enabledFeatures;
        }

        private static void b(Item item) {
            if (!(item instanceof ItemPotion)) {
                throw new IllegalArgumentException("Expected a potion, got: " + String.valueOf(BuiltInRegistries.h.b(item)));
            }
        }

        public void a(Item input, Item ingredient, Item result) {
            if (input.a(this.d) && ingredient.a(this.d) && result.a(this.d)) {
                net.minecraft.world.item.alchemy.PotionBrewer$a.b(input);
                net.minecraft.world.item.alchemy.PotionBrewer$a.b(result);
                this.c.add(new PredicatedCombination<Item>(input.e(), RecipeItemStack.a((IMaterial)ingredient), result.e()));
            }
        }

        public void a(Item container) {
            if (container.a(this.d)) {
                net.minecraft.world.item.alchemy.PotionBrewer$a.b(container);
                this.a.add(RecipeItemStack.a((IMaterial)container));
            }
        }

        public void a(Holder<PotionRegistry> input, Item ingredient, Holder<PotionRegistry> result) {
            if (input.a().a(this.d) && ingredient.a(this.d) && result.a().a(this.d)) {
                this.b.add(new PredicatedCombination<PotionRegistry>(input, RecipeItemStack.a((IMaterial)ingredient), result));
            }
        }

        public void a(Item ingredient, Holder<PotionRegistry> result) {
            if (result.a().a(this.d)) {
                this.a(Potions.a, ingredient, Potions.b);
                this.a(Potions.d, ingredient, result);
            }
        }

        public PotionBrewer a() {
            return new PotionBrewer(List.copyOf(this.a), List.copyOf(this.b), List.copyOf(this.c));
        }
    }
}

