/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public final class PotionContents
extends Record
implements ConsumableListener,
TooltipProvider {
    private final Optional<Holder<PotionRegistry>> e;
    private final Optional<Integer> f;
    private final List<MobEffect> g;
    private final Optional<String> h;
    public static final PotionContents a = new PotionContents(Optional.empty(), Optional.empty(), List.of(), Optional.empty());
    private static final IChatBaseComponent i = IChatBaseComponent.c("effect.none").a(EnumChatFormat.h);
    public static final int b = -13083194;
    private static final Codec<PotionContents> j = RecordCodecBuilder.create(instance -> instance.group((App)PotionRegistry.a.optionalFieldOf("potion").forGetter(PotionContents::e), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(PotionContents::f), (App)MobEffect.d.listOf().optionalFieldOf("custom_effects", List.of()).forGetter(PotionContents::d), (App)Codec.STRING.optionalFieldOf("custom_name").forGetter(PotionContents::g)).apply((Applicative)instance, PotionContents::new));
    public static final Codec<PotionContents> c = Codec.withAlternative(j, PotionRegistry.a, PotionContents::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionContents> d = StreamCodec.a(PotionRegistry.b.a(ByteBufCodecs::a), PotionContents::e, ByteBufCodecs.g.a(ByteBufCodecs::a), PotionContents::f, MobEffect.e.a(ByteBufCodecs.a()), PotionContents::d, ByteBufCodecs.p.a(ByteBufCodecs::a), PotionContents::g, PotionContents::new);

    public PotionContents(Holder<PotionRegistry> potion) {
        this(Optional.of(potion), Optional.empty(), List.of(), Optional.empty());
    }

    public PotionContents(Optional<Holder<PotionRegistry>> potion, Optional<Integer> customColor, List<MobEffect> customEffects, Optional<String> customName) {
        this.e = potion;
        this.f = customColor;
        this.g = customEffects;
        this.h = customName;
    }

    public static ItemStack a(Item item, Holder<PotionRegistry> potion) {
        ItemStack itemStack = new ItemStack(item);
        itemStack.b(DataComponents.R, new PotionContents(potion));
        return itemStack;
    }

    public boolean a(Holder<PotionRegistry> potion) {
        return this.e.isPresent() && this.e.get().a(potion) && this.g.isEmpty();
    }

    public Iterable<MobEffect> a() {
        if (this.e.isEmpty()) {
            return this.g;
        }
        return this.g.isEmpty() ? this.e.get().a().a() : Iterables.concat(this.e.get().a().a(), this.g);
    }

    public void a(Consumer<MobEffect> action, float durationScale) {
        if (this.e.isPresent()) {
            for (MobEffect mobEffectInstance : this.e.get().a().a()) {
                action.accept(mobEffectInstance.a(durationScale));
            }
        }
        for (MobEffect mobEffectInstance : this.g) {
            action.accept(mobEffectInstance.a(durationScale));
        }
    }

    public PotionContents b(Holder<PotionRegistry> potion) {
        return new PotionContents(Optional.of(potion), this.f, this.g, this.h);
    }

    public PotionContents a(MobEffect effect) {
        return new PotionContents(this.e, this.f, SystemUtils.a(this.g, effect), this.h);
    }

    public int b() {
        return this.a(-13083194);
    }

    public int a(int defaultValue) {
        return this.f.isPresent() ? this.f.get().intValue() : PotionContents.a(this.a()).orElse(defaultValue);
    }

    public IChatBaseComponent a(String name) {
        String string = this.h.or(() -> this.e.map(potion -> ((PotionRegistry)potion.a()).b())).orElse("empty");
        return IChatBaseComponent.c(name + string);
    }

    public static OptionalInt a(Iterable<MobEffect> effects) {
        int i2 = 0;
        int i1 = 0;
        int i22 = 0;
        int i3 = 0;
        for (MobEffect mobEffectInstance : effects) {
            if (!mobEffectInstance.g()) continue;
            int color = mobEffectInstance.c().a().i();
            int i4 = mobEffectInstance.e() + 1;
            i2 += i4 * ARGB.b(color);
            i1 += i4 * ARGB.c(color);
            i22 += i4 * ARGB.d(color);
            i3 += i4;
        }
        return i3 == 0 ? OptionalInt.empty() : OptionalInt.of(ARGB.a(i2 / i3, i1 / i3, i22 / i3));
    }

    public boolean c() {
        return !this.g.isEmpty() || this.e.isPresent() && !this.e.get().a().a().isEmpty();
    }

    public List<MobEffect> d() {
        return Lists.transform(this.g, MobEffect::new);
    }

    public void a(EntityLiving entity, float durationScale) {
        World world = entity.an();
        if (world instanceof WorldServer) {
            EntityHuman player;
            WorldServer serverLevel = (WorldServer)world;
            EntityHuman player1 = entity instanceof EntityHuman ? (player = (EntityHuman)entity) : null;
            this.a((MobEffect effect) -> {
                if (effect.c().a().a()) {
                    effect.c().a().a(serverLevel, player1, player1, entity, effect.e(), 1.0);
                } else {
                    entity.addEffect((MobEffect)effect, EntityPotionEffectEvent.Cause.POTION_DRINK);
                }
            }, durationScale);
        }
    }

    public static void a(Iterable<MobEffect> effects, Consumer<IChatBaseComponent> tooltipAdder, float durationFactor, float ticksPerSecond) {
        ArrayList list = Lists.newArrayList();
        boolean flag = true;
        for (MobEffect mobEffectInstance : effects) {
            flag = false;
            Holder<MobEffectList> effect = mobEffectInstance.c();
            int amplifier = mobEffectInstance.e();
            effect.a().a(amplifier, (attribute, modifier) -> list.add(new Pair(attribute, modifier)));
            IChatMutableComponent potionDescription = PotionContents.a(effect, amplifier);
            if (!mobEffectInstance.a(20)) {
                potionDescription = IChatBaseComponent.a("potion.withDuration", potionDescription, MobEffectUtil.a(mobEffectInstance, durationFactor, ticksPerSecond));
            }
            tooltipAdder.accept(potionDescription.a(effect.a().h().a()));
        }
        if (flag) {
            tooltipAdder.accept(i);
        }
        if (!list.isEmpty()) {
            tooltipAdder.accept(CommonComponents.a);
            tooltipAdder.accept(IChatBaseComponent.c("potion.whenDrank").a(EnumChatFormat.f));
            for (Pair pair : list) {
                AttributeModifier attributeModifier = (AttributeModifier)pair.getSecond();
                double amount = attributeModifier.b();
                double d2 = attributeModifier.c() != AttributeModifier.Operation.b && attributeModifier.c() != AttributeModifier.Operation.c ? attributeModifier.b() : attributeModifier.b() * 100.0;
                if (amount > 0.0) {
                    tooltipAdder.accept(IChatBaseComponent.a("attribute.modifier.plus." + attributeModifier.c().a(), new Object[]{ItemAttributeModifiers.d.format(d2), IChatBaseComponent.c(((AttributeBase)((Holder)pair.getFirst()).a()).c())}).a(EnumChatFormat.j));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                tooltipAdder.accept(IChatBaseComponent.a("attribute.modifier.take." + attributeModifier.c().a(), new Object[]{ItemAttributeModifiers.d.format(d2 *= -1.0), IChatBaseComponent.c(((AttributeBase)((Holder)pair.getFirst()).a()).c())}).a(EnumChatFormat.m));
            }
        }
    }

    public static IChatMutableComponent a(Holder<MobEffectList> effect, int level) {
        IChatMutableComponent mutableComponent = IChatBaseComponent.c(effect.a().f());
        return level > 0 ? IChatBaseComponent.a("potion.withAmplifier", mutableComponent, IChatBaseComponent.c("potion.potency." + level)) : mutableComponent;
    }

    @Override
    public void a(World level, EntityLiving entity, ItemStack stack, Consumable consumable) {
        this.a(entity, stack.a(DataComponents.S, Float.valueOf(1.0f)).floatValue());
    }

    @Override
    public void a(Item.b context, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        PotionContents.a(this.a(), tooltipAdder, componentGetter.a(DataComponents.S, Float.valueOf(1.0f)).floatValue(), context.b());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PotionContents.class, "potion;customColor;customEffects;customName", "e", "f", "g", "h"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PotionContents.class, "potion;customColor;customEffects;customName", "e", "f", "g", "h"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PotionContents.class, "potion;customColor;customEffects;customName", "e", "f", "g", "h"}, this, o2);
    }

    public Optional<Holder<PotionRegistry>> e() {
        return this.e;
    }

    public Optional<Integer> f() {
        return this.f;
    }

    public Optional<String> g() {
        return this.h;
    }
}

