/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import io.papermc.paper.event.player.PlayerShieldDisableEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class BlocksAttacks
extends Record {
    private final float c;
    private final float d;
    private final List<a> e;
    private final b f;
    private final Optional<TagKey<DamageType>> g;
    private final Optional<Holder<SoundEffect>> h;
    private final Optional<Holder<SoundEffect>> i;
    public static final Codec<BlocksAttacks> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.q.optionalFieldOf("block_delay_seconds", (Object)Float.valueOf(0.0f)).forGetter(BlocksAttacks::b), (App)ExtraCodecs.q.optionalFieldOf("disable_cooldown_scale", (Object)Float.valueOf(1.0f)).forGetter(BlocksAttacks::c), (App)net.minecraft.world.item.component.BlocksAttacks$a.a.listOf().optionalFieldOf("damage_reductions", List.of(new a(90.0f, Optional.empty(), 0.0f, 1.0f))).forGetter(BlocksAttacks::d), (App)net.minecraft.world.item.component.BlocksAttacks$b.a.optionalFieldOf("item_damage", (Object)net.minecraft.world.item.component.BlocksAttacks$b.c).forGetter(BlocksAttacks::e), (App)TagKey.b(Registries.aU).optionalFieldOf("bypassed_by").forGetter(BlocksAttacks::f), (App)SoundEffect.b.optionalFieldOf("block_sound").forGetter(BlocksAttacks::g), (App)SoundEffect.b.optionalFieldOf("disabled_sound").forGetter(BlocksAttacks::h)).apply((Applicative)instance, BlocksAttacks::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlocksAttacks> b = StreamCodec.a(ByteBufCodecs.l, BlocksAttacks::b, ByteBufCodecs.l, BlocksAttacks::c, net.minecraft.world.item.component.BlocksAttacks$a.b.a(ByteBufCodecs.a()), BlocksAttacks::d, net.minecraft.world.item.component.BlocksAttacks$b.b, BlocksAttacks::e, TagKey.c(Registries.aU).a(ByteBufCodecs::a), BlocksAttacks::f, SoundEffect.d.a(ByteBufCodecs::a), BlocksAttacks::g, SoundEffect.d.a(ByteBufCodecs::a), BlocksAttacks::h, BlocksAttacks::new);

    public BlocksAttacks(float blockDelaySeconds, float disableCooldownScale, List<a> damageReductions, b itemDamage, Optional<TagKey<DamageType>> bypassedBy, Optional<Holder<SoundEffect>> blockSound, Optional<Holder<SoundEffect>> disableSound) {
        this.c = blockDelaySeconds;
        this.d = disableCooldownScale;
        this.e = damageReductions;
        this.f = itemDamage;
        this.g = bypassedBy;
        this.h = blockSound;
        this.i = disableSound;
    }

    public void a(WorldServer level, EntityLiving entity) {
        this.h.ifPresent(sound -> level.a(null, entity.dK(), entity.dM(), entity.dQ(), (Holder<SoundEffect>)sound, entity.dw(), 1.0f, 0.8f + level.z.i() * 0.4f));
    }

    public void disable(WorldServer level, EntityLiving entity, float duration, ItemStack stack, EntityLiving attacker) {
        int i2 = this.a(duration);
        if (i2 > 0) {
            if (entity instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                PlayerShieldDisableEvent shieldDisableEvent = new PlayerShieldDisableEvent((Player)player.getBukkitEntity(), (Entity)attacker.getBukkitEntity(), i2);
                if (!shieldDisableEvent.callEvent()) {
                    return;
                }
                player.gW().a(stack, shieldDisableEvent.getCooldown());
            }
            entity.fU();
            this.i.ifPresent(sound -> level.a(null, entity.dK(), entity.dM(), entity.dQ(), (Holder<SoundEffect>)sound, entity.dw(), 0.8f, 0.8f + level.z.i() * 0.4f));
        }
    }

    public void a(World level, ItemStack stack, EntityLiving entity, EnumHand hand, float damage) {
        if (entity instanceof EntityHuman) {
            int i2;
            EntityHuman player = (EntityHuman)entity;
            if (!level.D_()) {
                player.b(StatisticList.c.b(stack.h()));
            }
            if ((i2 = this.f.a(damage)) > 0) {
                stack.a(i2, entity, hand.a());
            }
        }
    }

    private int a(float duration) {
        float f2 = duration * this.d;
        return f2 > 0.0f ? Math.round(f2 * 20.0f) : 0;
    }

    public int a() {
        return Math.round(this.c * 20.0f);
    }

    public float a(DamageSource damageSource, float damageAmount, double horizontalAngle) {
        float f2 = 0.0f;
        for (a damageReduction : this.e) {
            f2 += damageReduction.a(damageSource, damageAmount, horizontalAngle);
        }
        return MathHelper.a(f2, 0.0f, damageAmount);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{BlocksAttacks.class, "blockDelaySeconds;disableCooldownScale;damageReductions;itemDamage;bypassedBy;blockSound;disableSound", "c", "d", "e", "f", "g", "h", "i"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlocksAttacks.class, "blockDelaySeconds;disableCooldownScale;damageReductions;itemDamage;bypassedBy;blockSound;disableSound", "c", "d", "e", "f", "g", "h", "i"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlocksAttacks.class, "blockDelaySeconds;disableCooldownScale;damageReductions;itemDamage;bypassedBy;blockSound;disableSound", "c", "d", "e", "f", "g", "h", "i"}, this, o2);
    }

    public float b() {
        return this.c;
    }

    public float c() {
        return this.d;
    }

    public List<a> d() {
        return this.e;
    }

    public b e() {
        return this.f;
    }

    public Optional<TagKey<DamageType>> f() {
        return this.g;
    }

    public Optional<Holder<SoundEffect>> g() {
        return this.h;
    }

    public Optional<Holder<SoundEffect>> h() {
        return this.i;
    }

    public static final class b
    extends Record {
        private final float d;
        private final float e;
        private final float f;
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.q.fieldOf("threshold").forGetter(b::a), (App)Codec.FLOAT.fieldOf("base").forGetter(b::b), (App)Codec.FLOAT.fieldOf("factor").forGetter(b::c)).apply((Applicative)instance, b::new));
        public static final StreamCodec<ByteBuf, b> b = StreamCodec.a(ByteBufCodecs.l, b::a, ByteBufCodecs.l, b::b, ByteBufCodecs.l, b::c, b::new);
        public static final b c = new b(1.0f, 0.0f, 1.0f);

        public b(float threshold, float base, float factor) {
            this.d = threshold;
            this.e = base;
            this.f = factor;
        }

        public int a(float damageAmount) {
            return damageAmount < this.d ? 0 : MathHelper.d(this.e + this.f * damageAmount);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "threshold;base;factor", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "threshold;base;factor", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "threshold;base;factor", "d", "e", "f"}, this, o2);
        }

        public float a() {
            return this.d;
        }

        public float b() {
            return this.e;
        }

        public float c() {
            return this.f;
        }
    }

    public static final class a
    extends Record {
        private final float c;
        private final Optional<HolderSet<DamageType>> d;
        private final float e;
        private final float f;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.r.optionalFieldOf("horizontal_blocking_angle", (Object)Float.valueOf(90.0f)).forGetter(a::a), (App)RegistryCodecs.a(Registries.aU).optionalFieldOf("type").forGetter(a::b), (App)Codec.FLOAT.fieldOf("base").forGetter(a::c), (App)Codec.FLOAT.fieldOf("factor").forGetter(a::d)).apply((Applicative)instance, a::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, a> b = StreamCodec.a(ByteBufCodecs.l, a::a, ByteBufCodecs.c(Registries.aU).a(ByteBufCodecs::a), a::b, ByteBufCodecs.l, a::c, ByteBufCodecs.l, a::d, a::new);

        public a(float horizontalBlockingAngle, Optional<HolderSet<DamageType>> type, float base, float factor) {
            this.c = horizontalBlockingAngle;
            this.d = type;
            this.e = base;
            this.f = factor;
        }

        public float a(DamageSource damageSource, float damageAmount, double horizontalAngle) {
            if (horizontalAngle > (double)((float)Math.PI / 180 * this.c)) {
                return 0.0f;
            }
            return this.d.isPresent() && !this.d.get().a(damageSource.l()) ? 0.0f : MathHelper.a(this.e + this.f * damageAmount, 0.0f, damageAmount);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "horizontalBlockingAngle;type;base;factor", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "horizontalBlockingAngle;type;base;factor", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "horizontalBlockingAngle;type;base;factor", "c", "d", "e", "f"}, this, o2);
        }

        public float a() {
            return this.c;
        }

        public Optional<HolderSet<DamageType>> b() {
            return this.d;
        }

        public float c() {
            return this.e;
        }

        public float d() {
            return this.f;
        }
    }
}

