/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public abstract sealed class ResolvableProfile
implements TooltipProvider {
    private static final Codec<ResolvableProfile> e = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapEither(ExtraCodecs.D, Partial.f).forGetter(ResolvableProfile::a), (App)PlayerSkin.Patch.b.forGetter(ResolvableProfile::c)).apply((Applicative)instance, ResolvableProfile::a));
    public static final Codec<ResolvableProfile> a = Codec.withAlternative(e, ExtraCodecs.B, ResolvableProfile::a);
    public static final StreamCodec<ByteBuf, ResolvableProfile> b = StreamCodec.a(ByteBufCodecs.a(ByteBufCodecs.A, Partial.b), ResolvableProfile::a, PlayerSkin.Patch.c, ResolvableProfile::c, ResolvableProfile::a);
    protected final GameProfile c;
    protected final PlayerSkin.Patch d;

    private static ResolvableProfile a(Either<GameProfile, Partial> contents, PlayerSkin.Patch skinPatch) {
        return contents.map(gameProfile -> new Static(Either.left(gameProfile), skinPatch), partial -> partial.e.isEmpty() && partial.d.isPresent() != partial.c.isPresent() ? partial.c.map(string -> new Dynamic(Either.left(string), skinPatch)).orElseGet(() -> new Dynamic(Either.right(partial.d.get()), skinPatch)) : new Static(Either.right(partial), skinPatch));
    }

    public static ResolvableProfile a(GameProfile profile) {
        return new Static(Either.left(profile), PlayerSkin.Patch.a);
    }

    public static ResolvableProfile a(String name) {
        return new Dynamic(Either.left(name), PlayerSkin.Patch.a);
    }

    public static ResolvableProfile a(UUID id) {
        return new Dynamic(Either.right(id), PlayerSkin.Patch.a);
    }

    public abstract Either<GameProfile, Partial> a();

    protected ResolvableProfile(GameProfile partialProfile, PlayerSkin.Patch skinPatch) {
        this.c = partialProfile;
        this.d = skinPatch;
    }

    public abstract CompletableFuture<GameProfile> a(ProfileResolver var1);

    public GameProfile b() {
        return this.c;
    }

    public PlayerSkin.Patch c() {
        return this.d;
    }

    static GameProfile a(Optional<String> name, Optional<UUID> id, PropertyMap properties) {
        String string = name.orElse("");
        UUID uuid = id.orElseGet(() -> name.map(UUIDUtil::a).orElse(SystemUtils.e));
        return new GameProfile(uuid, string, properties);
    }

    public abstract Optional<String> d();

    public static final class Static
    extends ResolvableProfile {
        public static final Static e = new Static(Either.right(Partial.a), PlayerSkin.Patch.a);
        private final Either<GameProfile, Partial> f;

        public Static(Either<GameProfile, Partial> contents, PlayerSkin.Patch skinPatch) {
            super(contents.map(gameProfile -> gameProfile, Partial::d), skinPatch);
            this.f = contents;
        }

        @Override
        public CompletableFuture<GameProfile> a(ProfileResolver resolver) {
            return CompletableFuture.completedFuture(this.c);
        }

        @Override
        public Either<GameProfile, Partial> a() {
            return this.f;
        }

        @Override
        public Optional<String> d() {
            return this.f.map(gameProfile -> Optional.of(gameProfile.name()), partial -> partial.c);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof Static)) return false;
            Static _static = (Static)other;
            if (!this.f.equals(_static.f)) return false;
            if (!this.d.equals(_static.d)) return false;
            return true;
        }

        public int hashCode() {
            int i2 = 31 + this.f.hashCode();
            return 31 * i2 + this.d.hashCode();
        }

        @Override
        public void a(Item.b context, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        }
    }

    public static final class Dynamic
    extends ResolvableProfile {
        private static final IChatBaseComponent e = IChatBaseComponent.c("component.profile.dynamic").a(EnumChatFormat.h);
        private final Either<String, UUID> f;

        public Dynamic(Either<String, UUID> nameOrId, PlayerSkin.Patch skinPatch) {
            super(ResolvableProfile.a(nameOrId.left(), nameOrId.right(), PropertyMap.EMPTY), skinPatch);
            this.f = nameOrId;
        }

        @Override
        public Optional<String> d() {
            return this.f.left();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof Dynamic)) return false;
            Dynamic dynamic = (Dynamic)other;
            if (!this.f.equals(dynamic.f)) return false;
            if (!this.d.equals(dynamic.d)) return false;
            return true;
        }

        public int hashCode() {
            int i2 = 31 + this.f.hashCode();
            return 31 * i2 + this.d.hashCode();
        }

        @Override
        public Either<GameProfile, Partial> a() {
            return Either.right(new Partial(this.f.left(), this.f.right(), PropertyMap.EMPTY));
        }

        @Override
        public CompletableFuture<GameProfile> a(ProfileResolver resolver) {
            return CompletableFuture.supplyAsync(() -> resolver.a(this.f).orElse(this.c), SystemUtils.j());
        }

        @Override
        public void a(Item.b context, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
            tooltipAdder.accept(e);
        }
    }

    public static final class Partial
    extends Record {
        private final Optional<String> c;
        private final Optional<UUID> d;
        private final PropertyMap e;
        public static final Partial a = new Partial(Optional.empty(), Optional.empty(), PropertyMap.EMPTY);
        public static final MapCodec<Partial> f = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.B.optionalFieldOf("name").forGetter(Partial::a), (App)UUIDUtil.a.optionalFieldOf("id").forGetter(Partial::b), (App)UUIDUtil.d.lenientOptionalFieldOf("Id").forGetter($ -> Optional.empty()), (App)ExtraCodecs.A.optionalFieldOf("properties", (Object)PropertyMap.EMPTY).forGetter(Partial::c)).apply((Applicative)instance, (name, uuid, uuid2, propertyMap) -> new Partial((Optional<String>)name, uuid2.or(() -> uuid), (PropertyMap)propertyMap)));
        public static final StreamCodec<ByteBuf, Partial> b = StreamCodec.a(ByteBufCodecs.z.a(ByteBufCodecs::a), Partial::a, UUIDUtil.g.a(ByteBufCodecs::a), Partial::b, ByteBufCodecs.y, Partial::c, Partial::new);

        public Partial(Optional<String> name, Optional<UUID> id, PropertyMap properties) {
            this.c = name;
            this.d = id;
            this.e = properties;
        }

        private GameProfile d() {
            return ResolvableProfile.a(this.c, this.d, this.e);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Partial.class, "name;id;properties", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Partial.class, "name;id;properties", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Partial.class, "name;id;properties", "c", "d", "e"}, this, o2);
        }

        public Optional<String> a() {
            return this.c;
        }

        public Optional<UUID> b() {
            return this.d;
        }

        public PropertyMap c() {
            return this.e;
        }
    }
}

