/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.block.entity.FuelValues;

public interface SlotDisplay {
    public static final Codec<SlotDisplay> a = BuiltInRegistries.az.q().dispatch(SlotDisplay::a, i::a);
    public static final StreamCodec<RegistryFriendlyByteBuf, SlotDisplay> b = ByteBufCodecs.a(Registries.as).b(SlotDisplay::a, i::b);

    public <T> Stream<T> a(ContextMap var1, DisplayContentsFactory<T> var2);

    public i<? extends SlotDisplay> a();

    default public boolean a(FeatureFlagSet enabledFeatures) {
        return true;
    }

    default public List<ItemStack> a(ContextMap context) {
        return this.a(context, e.a).toList();
    }

    default public ItemStack b(ContextMap context) {
        return this.a(context, e.a).findFirst().orElse(ItemStack.l);
    }

    public static class e
    implements DisplayContentsFactory.b<ItemStack> {
        public static final e a = new e();

        public ItemStack b(ItemStack stack) {
            return stack;
        }
    }

    public static final class j
    extends Record
    implements SlotDisplay {
        private final SlotDisplay f;
        private final SlotDisplay g;
        public static final MapCodec<j> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)a.fieldOf("input").forGetter(j::b), (App)a.fieldOf("remainder").forGetter(j::c)).apply((Applicative)instance, j::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, j> d = StreamCodec.a(b, j::b, b, j::c, j::new);
        public static final i<j> e = new i<j>(c, d);

        public j(SlotDisplay input, SlotDisplay remainder) {
            this.f = input;
            this.g = remainder;
        }

        public i<j> a() {
            return e;
        }

        @Override
        public <T> Stream<T> a(ContextMap context, DisplayContentsFactory<T> output) {
            if (output instanceof DisplayContentsFactory.a) {
                DisplayContentsFactory.a forRemainders = (DisplayContentsFactory.a)output;
                List list = this.g.a(context, output).toList();
                return this.f.a(context, output).map(object -> forRemainders.a(object, list));
            }
            return this.f.a(context, output);
        }

        @Override
        public boolean a(FeatureFlagSet enabledFeatures) {
            return this.f.a(enabledFeatures) && this.g.a(enabledFeatures);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{j.class, "input;remainder", "f", "g"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{j.class, "input;remainder", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{j.class, "input;remainder", "f", "g"}, this, o2);
        }

        public SlotDisplay b() {
            return this.f;
        }

        public SlotDisplay c() {
            return this.g;
        }
    }

    public record i<T extends SlotDisplay>(MapCodec<T> a, StreamCodec<RegistryFriendlyByteBuf, T> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{i.class, "codec;streamCodec", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{i.class, "codec;streamCodec", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{i.class, "codec;streamCodec", "a", "b"}, this, o2);
        }
    }

    public static final class h
    extends Record
    implements SlotDisplay {
        private final TagKey<Item> f;
        public static final MapCodec<h> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.a(Registries.O).fieldOf("tag").forGetter(h::b)).apply((Applicative)instance, h::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, h> d = StreamCodec.a(TagKey.c(Registries.O), h::b, h::new);
        public static final i<h> e = new i<h>(c, d);

        public h(TagKey<Item> tag) {
            this.f = tag;
        }

        public i<h> a() {
            return e;
        }

        @Override
        public <T> Stream<T> a(ContextMap context, DisplayContentsFactory<T> output) {
            if (output instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b forStacks = (DisplayContentsFactory.b)output;
                HolderLookup.a provider = context.c(SlotDisplayContext.b);
                if (provider != null) {
                    return provider.e(Registries.O).a(this.f).map(named -> named.a().map(forStacks::a)).stream().flatMap(stream -> stream);
                }
            }
            return Stream.empty();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "tag", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "tag", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "tag", "f"}, this, o2);
        }

        public TagKey<Item> b() {
            return this.f;
        }
    }

    public static final class g
    extends Record
    implements SlotDisplay {
        private final SlotDisplay f;
        private final SlotDisplay g;
        private final Holder<TrimPattern> h;
        public static final MapCodec<g> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)a.fieldOf("base").forGetter(g::b), (App)a.fieldOf("material").forGetter(g::c), (App)TrimPattern.c.fieldOf("pattern").forGetter(g::d)).apply((Applicative)instance, g::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, g> d = StreamCodec.a(b, g::b, b, g::c, TrimPattern.d, g::d, g::new);
        public static final i<g> e = new i<g>(c, d);

        public g(SlotDisplay base, SlotDisplay material, Holder<TrimPattern> pattern) {
            this.f = base;
            this.g = material;
            this.h = pattern;
        }

        public i<g> a() {
            return e;
        }

        @Override
        public <T> Stream<T> a(ContextMap context, DisplayContentsFactory<T> output) {
            if (output instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b forStacks = (DisplayContentsFactory.b)output;
                HolderLookup.a provider = context.c(SlotDisplayContext.b);
                if (provider != null) {
                    RandomSource randomSource = RandomSource.a(System.identityHashCode(this));
                    List<ItemStack> list = this.f.a(context);
                    if (list.isEmpty()) {
                        return Stream.empty();
                    }
                    List<ItemStack> list1 = this.g.a(context);
                    if (list1.isEmpty()) {
                        return Stream.empty();
                    }
                    return Stream.generate(() -> {
                        ItemStack itemStack = (ItemStack)SystemUtils.a(list, randomSource);
                        ItemStack itemStack1 = (ItemStack)SystemUtils.a(list1, randomSource);
                        return SmithingTrimRecipe.a(provider, itemStack, itemStack1, this.h);
                    }).limit(256L).filter(stack -> !stack.f()).limit(16L).map(forStacks::a);
                }
            }
            return Stream.empty();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{g.class, "base;material;pattern", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{g.class, "base;material;pattern", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{g.class, "base;material;pattern", "f", "g", "h"}, this, o2);
        }

        public SlotDisplay b() {
            return this.f;
        }

        public SlotDisplay c() {
            return this.g;
        }

        public Holder<TrimPattern> d() {
            return this.h;
        }
    }

    public static final class f
    extends Record
    implements SlotDisplay {
        private final ItemStack f;
        public static final MapCodec<f> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.d.fieldOf("item").forGetter(f::b)).apply((Applicative)instance, f::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, f> d = StreamCodec.a(ItemStack.j, f::b, f::new);
        public static final i<f> e = new i<f>(c, d);

        public f(ItemStack stack) {
            this.f = stack;
        }

        public i<f> a() {
            return e;
        }

        @Override
        public <T> Stream<T> a(ContextMap context, DisplayContentsFactory<T> output) {
            Stream stream;
            if (output instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b forStacks = (DisplayContentsFactory.b)output;
                stream = Stream.of(forStacks.a(this.f));
            } else {
                stream = Stream.empty();
            }
            return stream;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof f)) return false;
            f itemStackSlotDisplay = (f)other;
            if (!ItemStack.a(this.f, itemStackSlotDisplay.f)) return false;
            return true;
        }

        @Override
        public boolean a(FeatureFlagSet enabledFeatures) {
            return this.f.h().a(enabledFeatures);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{f.class, "stack", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{f.class, "stack", "f"}, this);
        }

        public ItemStack b() {
            return this.f;
        }
    }

    public static final class d
    extends Record
    implements SlotDisplay {
        private final Holder<Item> f;
        public static final MapCodec<d> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Item.e.fieldOf("item").forGetter(d::b)).apply((Applicative)instance, d::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, d> d = StreamCodec.a(Item.f, d::b, d::new);
        public static final i<d> e = new i<d>(c, d);

        public d(Item item) {
            this(item.e());
        }

        public d(Holder<Item> item) {
            this.f = item;
        }

        public i<d> a() {
            return e;
        }

        @Override
        public <T> Stream<T> a(ContextMap context, DisplayContentsFactory<T> output) {
            Stream stream;
            if (output instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b forStacks = (DisplayContentsFactory.b)output;
                stream = Stream.of(forStacks.a(this.f));
            } else {
                stream = Stream.empty();
            }
            return stream;
        }

        @Override
        public boolean a(FeatureFlagSet enabledFeatures) {
            return this.f.a().a(enabledFeatures);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "item", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "item", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "item", "f"}, this, o2);
        }

        public Holder<Item> b() {
            return this.f;
        }
    }

    public static class c
    implements SlotDisplay {
        public static final c c = new c();
        public static final MapCodec<c> d = MapCodec.unit((Object)c);
        public static final StreamCodec<RegistryFriendlyByteBuf, c> e = StreamCodec.a(c);
        public static final i<c> f = new i<c>(d, e);

        private c() {
        }

        public i<c> a() {
            return f;
        }

        public String toString() {
            return "<empty>";
        }

        @Override
        public <T> Stream<T> a(ContextMap context, DisplayContentsFactory<T> output) {
            return Stream.empty();
        }
    }

    public static final class b
    extends Record
    implements SlotDisplay {
        private final List<SlotDisplay> f;
        public static final MapCodec<b> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)a.listOf().fieldOf("contents").forGetter(b::b)).apply((Applicative)instance, b::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, b> d = StreamCodec.a(b.a(ByteBufCodecs.a()), b::b, b::new);
        public static final i<b> e = new i<b>(c, d);

        public b(List<SlotDisplay> contents) {
            this.f = contents;
        }

        public i<b> a() {
            return e;
        }

        @Override
        public <T> Stream<T> a(ContextMap context, DisplayContentsFactory<T> output) {
            return this.f.stream().flatMap(slotDisplay -> slotDisplay.a(context, output));
        }

        @Override
        public boolean a(FeatureFlagSet enabledFeatures) {
            return this.f.stream().allMatch(display -> display.a(enabledFeatures));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "contents", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "contents", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "contents", "f"}, this, o2);
        }

        public List<SlotDisplay> b() {
            return this.f;
        }
    }

    public static class a
    implements SlotDisplay {
        public static final a c = new a();
        public static final MapCodec<a> d = MapCodec.unit((Object)c);
        public static final StreamCodec<RegistryFriendlyByteBuf, a> e = StreamCodec.a(c);
        public static final i<a> f = new i<a>(d, e);

        private a() {
        }

        public i<a> a() {
            return f;
        }

        public String toString() {
            return "<any fuel>";
        }

        @Override
        public <T> Stream<T> a(ContextMap context, DisplayContentsFactory<T> output) {
            if (output instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b forStacks = (DisplayContentsFactory.b)output;
                FuelValues fuelValues = context.c(SlotDisplayContext.a);
                if (fuelValues != null) {
                    return fuelValues.a().stream().map(forStacks::a);
                }
            }
            return Stream.empty();
        }
    }
}

