/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom2;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

public class EnchantmentManager {
    public static int a(Holder<Enchantment> enchantment, ItemStack stack) {
        ItemEnchantments itemEnchantments = stack.a(DataComponents.l, ItemEnchantments.a);
        return itemEnchantments.a(enchantment);
    }

    public static ItemEnchantments a(ItemStack stack, Consumer<ItemEnchantments.a> updater) {
        return EnchantmentManager.updateEnchantments(stack, updater, false);
    }

    public static ItemEnchantments updateEnchantments(ItemStack stack, Consumer<ItemEnchantments.a> updater, boolean createComponentIfMissing) {
        ItemEnchantments itemEnchantments;
        DataComponentType<ItemEnchantments> componentType = EnchantmentManager.d(stack);
        ItemEnchantments itemEnchantments2 = itemEnchantments = createComponentIfMissing ? stack.a(componentType, ItemEnchantments.a) : stack.a(componentType);
        if (itemEnchantments == null) {
            return ItemEnchantments.a;
        }
        ItemEnchantments.a mutable = new ItemEnchantments.a(itemEnchantments);
        updater.accept(mutable);
        ItemEnchantments itemEnchantments1 = mutable.b();
        stack.b(componentType, itemEnchantments1);
        return itemEnchantments1;
    }

    public static boolean a(ItemStack stack) {
        return stack.c(EnchantmentManager.d(stack));
    }

    public static void a(ItemStack stack, ItemEnchantments enchantments) {
        stack.b(EnchantmentManager.d(stack), enchantments);
    }

    public static ItemEnchantments b(ItemStack stack) {
        return stack.a(EnchantmentManager.d(stack), ItemEnchantments.a);
    }

    private static DataComponentType<ItemEnchantments> d(ItemStack stack) {
        return stack.a(Items.wE) ? DataComponents.J : DataComponents.l;
    }

    public static boolean c(ItemStack stack) {
        return !stack.a(DataComponents.l, ItemEnchantments.a).d() || !stack.a(DataComponents.J, ItemEnchantments.a).d();
    }

    public static int a(WorldServer level, ItemStack stack, int damage) {
        MutableFloat mutableFloat = new MutableFloat((float)damage);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int enchantmentLevel) -> ((Enchantment)enchantment.a()).a(level, enchantmentLevel, stack, mutableFloat));
        return mutableFloat.intValue();
    }

    public static int a(WorldServer level, ItemStack weapon, ItemStack ammo, int count) {
        MutableFloat mutableFloat = new MutableFloat((float)count);
        EnchantmentManager.a(weapon, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).b(level, level1, ammo, mutableFloat));
        return mutableFloat.intValue();
    }

    public static int b(WorldServer level, ItemStack stack, int experience) {
        MutableFloat mutableFloat = new MutableFloat((float)experience);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).d(level, level1, stack, mutableFloat));
        return mutableFloat.intValue();
    }

    public static int a(WorldServer level, @Nullable Entity killer, Entity mob, int experience) {
        if (killer instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)killer;
            MutableFloat mutableFloat = new MutableFloat((float)experience);
            EnchantmentManager.a(livingEntity, (Holder<Enchantment> enchantment, int level1, EnchantedItemInUse item) -> ((Enchantment)enchantment.a()).a(level, level1, item.a(), mob, mutableFloat));
            return mutableFloat.intValue();
        }
        return experience;
    }

    public static ItemStack a(WeightedRandomEnchant enchantment) {
        ItemStack itemStack = new ItemStack(Items.wE);
        itemStack.a(enchantment.b(), enchantment.c());
        return itemStack;
    }

    private static void a(ItemStack stack, b visitor) {
        ItemEnchantments itemEnchantments = stack.a(DataComponents.l, ItemEnchantments.a);
        for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.b()) {
            visitor.accept((Holder)entry.getKey(), entry.getIntValue());
        }
    }

    private static void a(ItemStack stack, EnumItemSlot slot, EntityLiving entity, a visitor) {
        ItemEnchantments itemEnchantments;
        if (!stack.f() && (itemEnchantments = stack.a(DataComponents.l)) != null && !itemEnchantments.d()) {
            EnchantedItemInUse enchantedItemInUse = new EnchantedItemInUse(stack, slot, entity);
            for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.b()) {
                Holder holder = (Holder)entry.getKey();
                if (!((Enchantment)holder.a()).a(slot)) continue;
                visitor.accept(holder, entry.getIntValue(), enchantedItemInUse);
            }
        }
    }

    private static void a(EntityLiving entity, a visitor) {
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            EnchantmentManager.a(entity.a(equipmentSlot), equipmentSlot, entity, visitor);
        }
    }

    public static boolean a(WorldServer level, EntityLiving entity, DamageSource damageSource) {
        MutableBoolean mutableBoolean = new MutableBoolean();
        EnchantmentManager.a(entity, (Holder<Enchantment> enchantment, int level1, EnchantedItemInUse item) -> mutableBoolean.setValue(mutableBoolean.isTrue() || ((Enchantment)enchantment.a()).a(level, level1, entity, damageSource)));
        return mutableBoolean.isTrue();
    }

    public static float b(WorldServer level, EntityLiving entity, DamageSource damageSource) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentManager.a(entity, (Holder<Enchantment> enchantment, int level1, EnchantedItemInUse item) -> ((Enchantment)enchantment.a()).a(level, level1, item.a(), (Entity)entity, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float a(WorldServer level, ItemStack tool, Entity entity, DamageSource damageSource, float damage) {
        MutableFloat mutableFloat = new MutableFloat(damage);
        EnchantmentManager.a(tool, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).b(level, level1, tool, entity, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float b(WorldServer level, ItemStack tool, Entity entity, DamageSource damageSource, float fallBasedDamage) {
        MutableFloat mutableFloat = new MutableFloat(fallBasedDamage);
        EnchantmentManager.a(tool, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).c(level, level1, tool, entity, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float c(WorldServer level, ItemStack tool, Entity entity, DamageSource damageSource, float armorEffectiveness) {
        MutableFloat mutableFloat = new MutableFloat(armorEffectiveness);
        EnchantmentManager.a(tool, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).e(level, level1, tool, entity, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float d(WorldServer level, ItemStack tool, Entity entity, DamageSource damageSource, float knockback) {
        MutableFloat mutableFloat = new MutableFloat(knockback);
        EnchantmentManager.a(tool, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).d(level, level1, tool, entity, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static void a(WorldServer level, Entity entity, DamageSource damageSource) {
        Entity entity2 = damageSource.d();
        if (entity2 instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity2;
            EnchantmentManager.a(level, entity, damageSource, livingEntity.el());
        } else {
            EnchantmentManager.a(level, entity, damageSource, null);
        }
    }

    public static void a(WorldServer level, Entity entity, DamageSource damageSource, @Nullable ItemStack itemSource) {
        EnchantmentManager.a(level, entity, damageSource, itemSource, null);
    }

    public static void a(WorldServer level, Entity entity, DamageSource damageSource, @Nullable ItemStack itemSource, @Nullable Consumer<Item> onBreak) {
        EntityLiving livingEntity;
        if (entity instanceof EntityLiving) {
            livingEntity = (EntityLiving)entity;
            EnchantmentManager.a(livingEntity, (Holder<Enchantment> enchantment, int level1, EnchantedItemInUse item) -> ((Enchantment)enchantment.a()).a(level, level1, item, EnchantmentTarget.c, entity, damageSource));
        }
        if (itemSource != null) {
            Entity entity2 = damageSource.d();
            if (entity2 instanceof EntityLiving) {
                livingEntity = (EntityLiving)entity2;
                EnchantmentManager.a(itemSource, EnumItemSlot.a, livingEntity, (Holder<Enchantment> enchantment, int level1, EnchantedItemInUse item) -> ((Enchantment)enchantment.a()).a(level, level1, item, EnchantmentTarget.a, entity, damageSource));
            } else if (onBreak != null) {
                EnchantedItemInUse enchantedItemInUse = new EnchantedItemInUse(itemSource, null, null, onBreak);
                EnchantmentManager.a(itemSource, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).a(level, level1, enchantedItemInUse, EnchantmentTarget.a, entity, damageSource));
            }
        }
    }

    public static void a(WorldServer level, EntityLiving entity) {
        EnchantmentManager.a(entity, (Holder<Enchantment> enchantment, int level1, EnchantedItemInUse item) -> ((Enchantment)enchantment.a()).a(level, level1, item, entity));
    }

    public static void a(WorldServer level, ItemStack stack, EntityLiving entity, EnumItemSlot slot) {
        EnchantmentManager.a(stack, slot, entity, (Holder<Enchantment> enchantment, int level1, EnchantedItemInUse item) -> ((Enchantment)enchantment.a()).a(level, level1, item, entity));
    }

    public static void a(EntityLiving entity) {
        EnchantmentManager.a(entity, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse item) -> ((Enchantment)enchantment.a()).a(level, item, entity));
    }

    public static void a(ItemStack stack, EntityLiving entity, EnumItemSlot slot) {
        EnchantmentManager.a(stack, slot, entity, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse item) -> ((Enchantment)enchantment.a()).a(level, item, entity));
    }

    public static void b(WorldServer level, EntityLiving entity) {
        EnchantmentManager.a(entity, (Holder<Enchantment> enchantment, int level1, EnchantedItemInUse item) -> ((Enchantment)enchantment.a()).a(level, level1, item, (Entity)entity));
    }

    public static int a(Holder<Enchantment> enchantment, EntityLiving entity) {
        Collection<ItemStack> iterable = enchantment.a().a(entity).values();
        int i2 = 0;
        for (ItemStack itemStack : iterable) {
            int itemEnchantmentLevel = EnchantmentManager.a(enchantment, itemStack);
            if (itemEnchantmentLevel <= i2) continue;
            i2 = itemEnchantmentLevel;
        }
        return i2;
    }

    public static int a(WorldServer level, ItemStack tool, Entity entity, int projectileCount) {
        MutableFloat mutableFloat = new MutableFloat((float)projectileCount);
        EnchantmentManager.a(tool, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).e(level, level1, tool, entity, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static float a(WorldServer level, ItemStack tool, Entity entity, float projectileSpread) {
        MutableFloat mutableFloat = new MutableFloat(projectileSpread);
        EnchantmentManager.a(tool, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).f(level, level1, tool, entity, mutableFloat));
        return Math.max(0.0f, mutableFloat.floatValue());
    }

    public static int a(WorldServer level, ItemStack firedFromWeapon, ItemStack pickupItemStack) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentManager.a(firedFromWeapon, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).c(level, level1, pickupItemStack, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static void a(WorldServer level, ItemStack firedFromWeapon, IProjectile projectile, Consumer<Item> onBreak) {
        EntityLiving livingEntity;
        Entity entity = projectile.ai_();
        EntityLiving livingEntity1 = entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : null;
        EnchantedItemInUse enchantedItemInUse = new EnchantedItemInUse(firedFromWeapon, null, livingEntity1, onBreak);
        EnchantmentManager.a(firedFromWeapon, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).b(level, level1, enchantedItemInUse, projectile));
    }

    public static void a(WorldServer level, ItemStack stack, @Nullable EntityLiving owner, Entity entity, @Nullable EnumItemSlot slot, Vec3D pos, IBlockData state, Consumer<Item> onBreak) {
        EnchantedItemInUse enchantedItemInUse = new EnchantedItemInUse(stack, slot, owner, onBreak);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).a(level, level1, enchantedItemInUse, entity, pos, state));
    }

    public static int c(WorldServer level, ItemStack stack, int durabilityToRepairFromXp) {
        MutableFloat mutableFloat = new MutableFloat((float)durabilityToRepairFromXp);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).e(level, level1, stack, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static float a(WorldServer level, EntityLiving entity, DamageSource damageSource, float equipmentDropChance) {
        MutableFloat mutableFloat = new MutableFloat(equipmentDropChance);
        RandomSource random = entity.ek();
        EnchantmentManager.a(entity, (Holder<Enchantment> enchantment, int level1, EnchantedItemInUse item) -> {
            LootTableInfo lootContext = Enchantment.b(level, level1, (Entity)entity, damageSource);
            ((Enchantment)enchantment.a()).a(EnchantmentEffectComponents.m).forEach(targetedConditionalEffect -> {
                if (targetedConditionalEffect.a() == EnchantmentTarget.c && targetedConditionalEffect.b() == EnchantmentTarget.c && targetedConditionalEffect.a(lootContext)) {
                    mutableFloat.setValue(((EnchantmentValueEffect)targetedConditionalEffect.c()).a(level1, random, mutableFloat.floatValue()));
                }
            });
        });
        Entity entity2 = damageSource.d();
        if (entity2 instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity2;
            EnchantmentManager.a(livingEntity, (Holder<Enchantment> enchantment, int level1, EnchantedItemInUse item) -> {
                LootTableInfo lootContext = Enchantment.b(level, level1, (Entity)entity, damageSource);
                ((Enchantment)enchantment.a()).a(EnchantmentEffectComponents.m).forEach(targetedConditionalEffect -> {
                    if (targetedConditionalEffect.a() == EnchantmentTarget.a && targetedConditionalEffect.b() == EnchantmentTarget.c && targetedConditionalEffect.a(lootContext)) {
                        mutableFloat.setValue(((EnchantmentValueEffect)targetedConditionalEffect.c()).a(level1, random, mutableFloat.floatValue()));
                    }
                });
            });
        }
        return mutableFloat.floatValue();
    }

    public static void a(ItemStack stack, EquipmentSlotGroup slotGroup, BiConsumer<Holder<AttributeBase>, AttributeModifier> action) {
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).a(EnchantmentEffectComponents.l).forEach(enchantmentAttributeEffect -> {
            if (((Enchantment)enchantment.a()).g().h().contains(slotGroup)) {
                action.accept(enchantmentAttributeEffect.c(), enchantmentAttributeEffect.a(level, slotGroup));
            }
        }));
    }

    public static void a(ItemStack stack, EnumItemSlot slot, BiConsumer<Holder<AttributeBase>, AttributeModifier> action) {
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).a(EnchantmentEffectComponents.l).forEach(enchantmentAttributeEffect -> {
            if (((Enchantment)enchantment.a()).a(slot)) {
                action.accept(enchantmentAttributeEffect.c(), enchantmentAttributeEffect.a(level, (INamable)slot));
            }
        }));
    }

    public static int a(WorldServer level, ItemStack stack, Entity entity) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).d(level, level1, stack, entity, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static float b(WorldServer level, ItemStack stack, Entity entity) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).c(level, level1, stack, entity, mutableFloat));
        return Math.max(0.0f, mutableFloat.floatValue());
    }

    public static int c(WorldServer level, ItemStack stack, Entity entity) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level1) -> ((Enchantment)enchantment.a()).b(level, level1, stack, entity, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static float a(ItemStack stack, EntityLiving entity, float crossbowChargingTime) {
        MutableFloat mutableFloat = new MutableFloat(crossbowChargingTime);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).b(entity.ek(), level, mutableFloat));
        return Math.max(0.0f, mutableFloat.floatValue());
    }

    public static float a(ItemStack stack, EntityLiving entity) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).a(entity.ek(), level, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static boolean a(ItemStack stack, TagKey<Enchantment> tag) {
        ItemEnchantments itemEnchantments = stack.a(DataComponents.l, ItemEnchantments.a);
        for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.b()) {
            Holder holder = (Holder)entry.getKey();
            if (!holder.a(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean a(ItemStack stack, DataComponentType<?> component) {
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> {
            if (((Enchantment)enchantment.a()).i().c(component)) {
                mutableBoolean.setTrue();
            }
        });
        return mutableBoolean.booleanValue();
    }

    public static <T> Optional<T> b(ItemStack stack, DataComponentType<List<T>> component) {
        Pair<List<T>, Integer> highestLevel = EnchantmentManager.c(stack, component);
        if (highestLevel != null) {
            List list = (List)highestLevel.getFirst();
            int second = (Integer)highestLevel.getSecond();
            return Optional.of(list.get(Math.min(second, list.size()) - 1));
        }
        return Optional.empty();
    }

    @Nullable
    public static <T> Pair<T, Integer> c(ItemStack stack, DataComponentType<T> component) {
        MutableObject mutableObject = new MutableObject();
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> {
            Object object;
            if ((mutableObject.getValue() == null || (Integer)((Pair)mutableObject.getValue()).getSecond() < level) && (object = ((Enchantment)enchantment.a()).i().a(component)) != null) {
                mutableObject.setValue((Object)Pair.of(object, (Object)level));
            }
        });
        return (Pair)mutableObject.getValue();
    }

    public static Optional<EnchantedItemInUse> a(DataComponentType<?> component, EntityLiving entity, Predicate<ItemStack> filter) {
        ArrayList<EnchantedItemInUse> list = new ArrayList<EnchantedItemInUse>();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            ItemStack itemBySlot = entity.a(equipmentSlot);
            if (!filter.test(itemBySlot)) continue;
            ItemEnchantments itemEnchantments = itemBySlot.a(DataComponents.l, ItemEnchantments.a);
            for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.b()) {
                Holder holder = (Holder)entry.getKey();
                if (!((Enchantment)holder.a()).i().c(component) || !((Enchantment)holder.a()).a(equipmentSlot)) continue;
                list.add(new EnchantedItemInUse(itemBySlot, equipmentSlot, entity));
            }
        }
        return SystemUtils.b(list, entity.ek());
    }

    public static int a(RandomSource random, int enchantNum, int power, ItemStack stack) {
        Enchantable enchantable = stack.a(DataComponents.C);
        if (enchantable == null) {
            return 0;
        }
        if (power > 15) {
            power = 15;
        }
        int i2 = random.a(8) + 1 + (power >> 1) + random.a(power + 1);
        if (enchantNum == 0) {
            return Math.max(i2 / 3, 1);
        }
        return enchantNum == 1 ? i2 * 2 / 3 + 1 : Math.max(i2, power * 2);
    }

    public static ItemStack a(RandomSource random, ItemStack stack, int level, IRegistryCustom registryAccess, Optional<? extends HolderSet<Enchantment>> possibleEnchantments) {
        return EnchantmentManager.a(random, stack, level, possibleEnchantments.map(HolderSet::a).orElseGet(() -> registryAccess.f(Registries.aZ).c().map(reference -> reference)));
    }

    public static ItemStack a(RandomSource random, ItemStack stack, int level, Stream<Holder<Enchantment>> possibleEnchantments) {
        List<WeightedRandomEnchant> list = EnchantmentManager.b(random, stack, level, possibleEnchantments);
        if (stack.a(Items.sB)) {
            stack = new ItemStack(Items.wE);
        }
        for (WeightedRandomEnchant enchantmentInstance : list) {
            stack.a(enchantmentInstance.b(), enchantmentInstance.c());
        }
        return stack;
    }

    public static List<WeightedRandomEnchant> b(RandomSource random, ItemStack stack, int level, Stream<Holder<Enchantment>> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        Enchantable enchantable = stack.a(DataComponents.C);
        if (enchantable == null) {
            return list;
        }
        level += 1 + random.a(enchantable.a() / 4 + 1) + random.a(enchantable.a() / 4 + 1);
        float f2 = (random.i() + random.i() - 1.0f) * 0.15f;
        List<WeightedRandomEnchant> availableEnchantmentResults = EnchantmentManager.a(level = MathHelper.a(Math.round((float)level + (float)level * f2), 1, Integer.MAX_VALUE), stack, possibleEnchantments);
        if (!availableEnchantmentResults.isEmpty()) {
            WeightedRandom2.a(random, availableEnchantmentResults, WeightedRandomEnchant::a).ifPresent(list::add);
            while (random.a(50) <= level) {
                if (!list.isEmpty()) {
                    EnchantmentManager.a(availableEnchantmentResults, (WeightedRandomEnchant)SystemUtils.c(list));
                }
                if (availableEnchantmentResults.isEmpty()) break;
                WeightedRandom2.a(random, availableEnchantmentResults, WeightedRandomEnchant::a).ifPresent(list::add);
                level /= 2;
            }
        }
        return list;
    }

    public static void a(List<WeightedRandomEnchant> dataList, WeightedRandomEnchant data) {
        dataList.removeIf(enchantmentInstance -> !Enchantment.a(data.b(), enchantmentInstance.b()));
    }

    public static boolean a(Collection<Holder<Enchantment>> currentEnchantments, Holder<Enchantment> newEnchantment) {
        for (Holder<Enchantment> holder : currentEnchantments) {
            if (Enchantment.a(holder, newEnchantment)) continue;
            return false;
        }
        return true;
    }

    public static List<WeightedRandomEnchant> a(int level, ItemStack stack, Stream<Holder<Enchantment>> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        boolean isBook = stack.a(Items.sB);
        possibleEnchantments.filter(holder -> ((Enchantment)holder.a()).a(stack) || isBook).forEach(holder -> {
            Enchantment enchantment = (Enchantment)holder.a();
            for (int level1 = enchantment.e(); level1 >= enchantment.d(); --level1) {
                if (level < enchantment.b(level1) || level > enchantment.c(level1)) continue;
                list.add(new WeightedRandomEnchant((Holder<Enchantment>)holder, level1));
                break;
            }
        });
        return list;
    }

    public static void a(ItemStack stack, IRegistryCustom registries, ResourceKey<EnchantmentProvider> key, DifficultyDamageScaler difficulty, RandomSource random) {
        EnchantmentProvider enchantmentProvider = registries.f(Registries.aY).c(key);
        if (enchantmentProvider != null) {
            EnchantmentManager.a(stack, (ItemEnchantments.a mutable) -> enchantmentProvider.a(stack, (ItemEnchantments.a)mutable, random, difficulty));
        }
    }

    public static Holder.c<Enchantment> getEnchantmentHolder(ResourceKey<Enchantment> enchantment) {
        return MinecraftServer.getServer().bg().f(Registries.aZ).b(enchantment);
    }

    public static int getItemEnchantmentLevel(ResourceKey<Enchantment> enchantment, ItemStack stack) {
        return EnchantmentManager.a(EnchantmentManager.getEnchantmentHolder(enchantment), stack);
    }

    public static Optional<EnchantedItemInUse> getMostDamagedItemWith(DataComponentType<?> componentType, EntityLiving entity) {
        ItemStack maxStack = null;
        EnumItemSlot maxSlot = null;
        float maxPercent = 0.0f;
        block0: for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
            ItemStack stack = entity.a(equipmentSlot);
            float percent = stack.getDamagePercent();
            if (percent <= maxPercent) continue;
            ItemEnchantments itemEnchantments = stack.a(DataComponents.l, ItemEnchantments.a);
            for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.b()) {
                Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).a();
                DataComponentMap effects = enchantment.i();
                if (!effects.c(componentType) || !enchantment.a(equipmentSlot)) continue;
                maxStack = stack;
                maxSlot = equipmentSlot;
                maxPercent = percent;
                continue block0;
            }
        }
        return maxStack != null ? Optional.of(new EnchantedItemInUse(maxStack, maxSlot, entity)) : Optional.empty();
    }

    @FunctionalInterface
    static interface b {
        public void accept(Holder<Enchantment> var1, int var2);
    }

    @FunctionalInterface
    static interface a {
        public void accept(Holder<Enchantment> var1, int var2, EnchantedItemInUse var3);
    }
}

