/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;

public final class Equippable
extends Record {
    private final EnumItemSlot c;
    private final Holder<SoundEffect> d;
    private final Optional<ResourceKey<EquipmentAsset>> e;
    private final Optional<MinecraftKey> f;
    private final Optional<HolderSet<EntityTypes<?>>> g;
    private final boolean h;
    private final boolean i;
    private final boolean j;
    private final boolean k;
    private final boolean l;
    private final Holder<SoundEffect> m;
    public static final Codec<Equippable> a = RecordCodecBuilder.create(instance -> instance.group((App)EnumItemSlot.l.fieldOf("slot").forGetter(Equippable::b), (App)SoundEffect.b.optionalFieldOf("equip_sound", SoundEffects.as).forGetter(Equippable::c), (App)ResourceKey.a(EquipmentAssets.a).optionalFieldOf("asset_id").forGetter(Equippable::d), (App)MinecraftKey.a.optionalFieldOf("camera_overlay").forGetter(Equippable::e), (App)RegistryCodecs.a(Registries.E).optionalFieldOf("allowed_entities").forGetter(Equippable::f), (App)Codec.BOOL.optionalFieldOf("dispensable", (Object)true).forGetter(Equippable::g), (App)Codec.BOOL.optionalFieldOf("swappable", (Object)true).forGetter(Equippable::h), (App)Codec.BOOL.optionalFieldOf("damage_on_hurt", (Object)true).forGetter(Equippable::i), (App)Codec.BOOL.optionalFieldOf("equip_on_interact", (Object)false).forGetter(Equippable::j), (App)Codec.BOOL.optionalFieldOf("can_be_sheared", (Object)false).forGetter(Equippable::k), (App)SoundEffect.b.optionalFieldOf("shearing_sound", BuiltInRegistries.b.e(SoundEffects.yw)).forGetter(Equippable::l)).apply((Applicative)instance, Equippable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Equippable> b = StreamCodec.a(EnumItemSlot.m, Equippable::b, SoundEffect.d, Equippable::c, ResourceKey.b(EquipmentAssets.a).a(ByteBufCodecs::a), Equippable::d, MinecraftKey.b.a(ByteBufCodecs::a), Equippable::e, ByteBufCodecs.c(Registries.E).a(ByteBufCodecs::a), Equippable::f, ByteBufCodecs.b, Equippable::g, ByteBufCodecs.b, Equippable::h, ByteBufCodecs.b, Equippable::i, ByteBufCodecs.b, Equippable::j, ByteBufCodecs.b, Equippable::k, SoundEffect.d, Equippable::l, Equippable::new);

    public Equippable(EnumItemSlot slot, Holder<SoundEffect> equipSound, Optional<ResourceKey<EquipmentAsset>> assetId, Optional<MinecraftKey> cameraOverlay, Optional<HolderSet<EntityTypes<?>>> allowedEntities, boolean dispensable, boolean swappable, boolean damageOnHurt, boolean equipOnInteract, boolean canBeSheared, Holder<SoundEffect> shearingSound) {
        this.c = slot;
        this.d = equipSound;
        this.e = assetId;
        this.f = cameraOverlay;
        this.g = allowedEntities;
        this.h = dispensable;
        this.i = swappable;
        this.j = damageOnHurt;
        this.k = equipOnInteract;
        this.l = canBeSheared;
        this.m = shearingSound;
    }

    public static Equippable a(EnumColor color) {
        return Equippable.a(EnumItemSlot.g).a(SoundEffects.pU).a(EquipmentAssets.m.get(color)).a(EntityTypes.aB, EntityTypes.bD).e(true).b(SoundEffects.pV).a();
    }

    public static Equippable a() {
        HolderGetter<EntityTypes<?>> holderGetter = BuiltInRegistries.a(BuiltInRegistries.g);
        return Equippable.a(EnumItemSlot.h).a(SoundEffects.ot).a(EquipmentAssets.l).a(holderGetter.b(TagsEntity.J)).d(true).e(true).b(SoundEffects.Gh).a();
    }

    public static Equippable b(EnumColor color) {
        HolderGetter<EntityTypes<?>> holderGetter = BuiltInRegistries.a(BuiltInRegistries.g);
        return Equippable.a(EnumItemSlot.g).a(SoundEffects.nL).a(EquipmentAssets.o.get(color)).a(holderGetter.b(TagsEntity.K)).d(true).e(true).b(BuiltInRegistries.b.e(SoundEffects.nM)).a();
    }

    public static a a(EnumItemSlot slot) {
        return new a(slot);
    }

    public EnumInteractionResult a(ItemStack stack, EntityHuman player) {
        if (player.e(this.c) && this.a(player.ax())) {
            ItemStack itemBySlot = player.a(this.c);
            if (!(EnchantmentManager.a(itemBySlot, EnchantmentEffectComponents.E) && !player.gQ() || ItemStack.c(stack, itemBySlot))) {
                if (!player.an().D_()) {
                    player.b(StatisticList.c.b(stack.h()));
                }
                if (stack.M() <= 1) {
                    ItemStack itemStack = itemBySlot.f() ? stack : itemBySlot.g();
                    ItemStack itemStack1 = player.gQ() ? stack.v() : stack.g();
                    player.a(this.c, itemStack1);
                    return EnumInteractionResult.a.a(itemStack);
                }
                ItemStack itemStack = itemBySlot.g();
                ItemStack itemStack1 = stack.b(1, (EntityLiving)player);
                player.a(this.c, itemStack1);
                if (!player.gB().g(itemStack)) {
                    player.a(itemStack, false);
                }
                return EnumInteractionResult.a.a(stack);
            }
            return EnumInteractionResult.d;
        }
        return EnumInteractionResult.e;
    }

    public EnumInteractionResult a(EntityHuman player, EntityLiving entity, ItemStack stack) {
        if (entity.a(stack, this.c) && !entity.d(this.c) && entity.bX()) {
            if (!player.an().D_()) {
                entity.a(this.c, stack.a(1));
                if (entity instanceof EntityInsentient) {
                    EntityInsentient mob = (EntityInsentient)entity;
                    mob.g(this.c);
                }
            }
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    public boolean a(EntityTypes<?> entityType) {
        return this.g.isEmpty() || this.g.get().a(entityType.r());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Equippable.class, "slot;equipSound;assetId;cameraOverlay;allowedEntities;dispensable;swappable;damageOnHurt;equipOnInteract;canBeSheared;shearingSound", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Equippable.class, "slot;equipSound;assetId;cameraOverlay;allowedEntities;dispensable;swappable;damageOnHurt;equipOnInteract;canBeSheared;shearingSound", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Equippable.class, "slot;equipSound;assetId;cameraOverlay;allowedEntities;dispensable;swappable;damageOnHurt;equipOnInteract;canBeSheared;shearingSound", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m"}, this, o2);
    }

    public EnumItemSlot b() {
        return this.c;
    }

    public Holder<SoundEffect> c() {
        return this.d;
    }

    public Optional<ResourceKey<EquipmentAsset>> d() {
        return this.e;
    }

    public Optional<MinecraftKey> e() {
        return this.f;
    }

    public Optional<HolderSet<EntityTypes<?>>> f() {
        return this.g;
    }

    public boolean g() {
        return this.h;
    }

    public boolean h() {
        return this.i;
    }

    public boolean i() {
        return this.j;
    }

    public boolean j() {
        return this.k;
    }

    public boolean k() {
        return this.l;
    }

    public Holder<SoundEffect> l() {
        return this.m;
    }

    public static class a {
        private final EnumItemSlot a;
        private Holder<SoundEffect> b = SoundEffects.as;
        private Optional<ResourceKey<EquipmentAsset>> c = Optional.empty();
        private Optional<MinecraftKey> d = Optional.empty();
        private Optional<HolderSet<EntityTypes<?>>> e = Optional.empty();
        private boolean f = true;
        private boolean g = true;
        private boolean h = true;
        private boolean i;
        private boolean j;
        private Holder<SoundEffect> k = BuiltInRegistries.b.e(SoundEffects.yw);

        a(EnumItemSlot slot) {
            this.a = slot;
        }

        public a a(Holder<SoundEffect> equipSound) {
            this.b = equipSound;
            return this;
        }

        public a a(ResourceKey<EquipmentAsset> asset) {
            this.c = Optional.of(asset);
            return this;
        }

        public a a(MinecraftKey cameraOverlay) {
            this.d = Optional.of(cameraOverlay);
            return this;
        }

        public a a(EntityTypes<?> ... allowedEntities) {
            return this.a(HolderSet.a(EntityTypes::r, allowedEntities));
        }

        public a a(HolderSet<EntityTypes<?>> allowedEntities) {
            this.e = Optional.of(allowedEntities);
            return this;
        }

        public a a(boolean dispensable) {
            this.f = dispensable;
            return this;
        }

        public a b(boolean swappable) {
            this.g = swappable;
            return this;
        }

        public a c(boolean damageOnHurt) {
            this.h = damageOnHurt;
            return this;
        }

        public a d(boolean equipOnInteract) {
            this.i = equipOnInteract;
            return this;
        }

        public a e(boolean canBeSheared) {
            this.j = canBeSheared;
            return this;
        }

        public a b(Holder<SoundEffect> shearingSound) {
            this.k = shearingSound;
            return this;
        }

        public Equippable a() {
            return new Equippable(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k);
        }
    }
}

