/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChunkCache
implements ICollisionAccess {
    protected final int a;
    protected final int b;
    protected final IChunkAccess[][] c;
    protected boolean d;
    protected final World e;
    private final Supplier<Holder<BiomeBase>> f;

    public ChunkCache(World level, BlockPosition centerPos, BlockPosition offsetPos) {
        int i1;
        int i2;
        this.e = level;
        this.f = Suppliers.memoize(() -> level.L_().f(Registries.aN).b(Biomes.b));
        this.a = SectionPosition.a(centerPos.u());
        this.b = SectionPosition.a(centerPos.w());
        int sectionPosX = SectionPosition.a(offsetPos.u());
        int sectionPosZ = SectionPosition.a(offsetPos.w());
        this.c = new IChunkAccess[sectionPosX - this.a + 1][sectionPosZ - this.b + 1];
        IChunkProvider chunkSource = level.X();
        this.d = true;
        for (i2 = this.a; i2 <= sectionPosX; ++i2) {
            for (i1 = this.b; i1 <= sectionPosZ; ++i1) {
                this.c[i2 - this.a][i1 - this.b] = chunkSource.a(i2, i1);
            }
        }
        for (i2 = SectionPosition.a(centerPos.u()); i2 <= SectionPosition.a(offsetPos.u()); ++i2) {
            for (i1 = SectionPosition.a(centerPos.w()); i1 <= SectionPosition.a(offsetPos.w()); ++i1) {
                IChunkAccess chunkAccess = this.c[i2 - this.a][i1 - this.b];
                if (chunkAccess == null || chunkAccess.a(centerPos.v(), offsetPos.v())) continue;
                this.d = false;
                return;
            }
        }
    }

    private IChunkAccess d(BlockPosition pos) {
        return this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    private IChunkAccess a(int x2, int z2) {
        int i2 = x2 - this.a;
        int i1 = z2 - this.b;
        if (i2 >= 0 && i2 < this.c.length && i1 >= 0 && i1 < this.c[i2].length) {
            IChunkAccess chunkAccess = this.c[i2][i1];
            return chunkAccess != null ? chunkAccess : new ChunkEmpty(this.e, new ChunkCoordIntPair(x2, z2), this.f.get());
        }
        return new ChunkEmpty(this.e, new ChunkCoordIntPair(x2, z2), this.f.get());
    }

    @Nullable
    private IChunkAccess getChunkIfLoaded(int x2, int z2) {
        int xx = x2 - this.a;
        int zz = z2 - this.b;
        if (xx >= 0 && xx < this.c.length && zz >= 0 && zz < this.c[xx].length) {
            return this.c[xx][zz];
        }
        return null;
    }

    @Override
    @Nullable
    public final Fluid getFluidIfLoaded(BlockPosition pos) {
        IChunkAccess chunk = this.getChunkIfLoaded(pos.u() >> 4, pos.w() >> 4);
        return chunk == null ? null : chunk.b_(pos);
    }

    @Override
    @Nullable
    public final IBlockData getBlockStateIfLoaded(BlockPosition pos) {
        IChunkAccess chunk = this.getChunkIfLoaded(pos.u() >> 4, pos.w() >> 4);
        return chunk == null ? null : chunk.a_(pos);
    }

    @Override
    public WorldBorder u() {
        return this.e.u();
    }

    @Override
    public IBlockAccess c(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ);
    }

    @Override
    public List<VoxelShape> c(@Nullable Entity entity, AxisAlignedBB collisionBox) {
        return List.of();
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        IChunkAccess chunk = this.d(pos);
        return chunk.c_(pos);
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        if (this.u(pos)) {
            return Blocks.a.m();
        }
        IChunkAccess chunk = this.d(pos);
        return chunk.a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        if (this.u(pos)) {
            return FluidTypes.a.g();
        }
        IChunkAccess chunk = this.d(pos);
        return chunk.b_(pos);
    }

    @Override
    public int M_() {
        return this.e.M_();
    }

    @Override
    public int N_() {
        return this.e.N_();
    }
}

