/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import io.papermc.paper.annotation.DoNotUse;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.command.CommandSender;
import org.bukkit.event.server.ServerCommandEvent;
import org.spigotmc.AsyncCatcher;

public abstract class CommandBlockListenerAbstract {
    private static final IChatBaseComponent a = IChatBaseComponent.b("@");
    private static final int b = -1;
    private long c = -1L;
    private boolean d = true;
    private int e;
    private boolean f = true;
    @Nullable
    IChatBaseComponent g;
    private String h = "";
    @Nullable
    private IChatBaseComponent i;

    protected abstract CommandSender getBukkitSender(CommandListenerWrapper var1);

    public int f() {
        return this.e;
    }

    public void a(int successCount) {
        this.e = successCount;
    }

    public IChatBaseComponent g() {
        return this.g == null ? CommonComponents.a : this.g;
    }

    public void a(ValueOutput output) {
        output.a("Command", this.h);
        output.a("SuccessCount", this.e);
        output.b("CustomName", ComponentSerialization.a, this.i);
        output.a("TrackOutput", this.f);
        if (this.f) {
            output.b("LastOutput", ComponentSerialization.a, this.g);
        }
        output.a("UpdateLastExecution", this.d);
        if (this.d && this.c != -1L) {
            output.a("LastExecution", this.c);
        }
    }

    public void a(ValueInput input) {
        this.h = input.a("Command", "");
        this.e = input.a("SuccessCount", 0);
        this.a(TileEntity.a(input, "CustomName"));
        this.f = input.a("TrackOutput", true);
        this.g = this.f ? TileEntity.a(input, "LastOutput") : null;
        this.d = input.a("UpdateLastExecution", true);
        this.c = this.d ? input.a("LastExecution", -1L) : -1L;
    }

    public void a(String command) {
        this.h = command;
        this.e = 0;
    }

    public String h() {
        return this.h;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean a(World level) {
        if (level.D_()) return false;
        if (level.ag() == this.c) {
            return false;
        }
        if ("Searge".equalsIgnoreCase(this.h)) {
            this.g = IChatBaseComponent.b("#itzlipofutzli");
            this.e = 1;
            return true;
        }
        this.e = 0;
        MinecraftServer server = this.a().q();
        if (server.y_() && !UtilColor.b(this.h)) {
            try {
                this.g = null;
                try (CloseableCommandBlockSource closeableCommandBlockSource = this.d();){
                    ICommandListener commandSource = Objects.requireNonNullElse(closeableCommandBlockSource, ICommandListener.a);
                    CommandListenerWrapper commandSourceStack = this.a(commandSource).a((boolean success, int result) -> {
                        if (success) {
                            ++this.e;
                        }
                    });
                    ServerCommandEvent event = new ServerCommandEvent(commandSourceStack.getBukkitSender(), CommandDispatcher.a(this.h));
                    if (!event.callEvent()) {
                        boolean bl = true;
                        return bl;
                    }
                    server.aJ().a(commandSourceStack, event.getCommand());
                }
            }
            catch (Throwable var8) {
                CrashReport crashReport = CrashReport.a(var8, "Executing command block");
                CrashReportSystemDetails crashReportCategory = crashReport.a("Command to be executed");
                crashReportCategory.a("Command", this::h);
                crashReportCategory.a("Name", () -> this.i().getString());
                throw new ReportedException(crashReport);
            }
        }
        if (this.d) {
            this.c = level.ag();
            return true;
        }
        this.c = -1L;
        return true;
    }

    public CloseableCommandBlockSource d() {
        return new CloseableCommandBlockSource(this.f);
    }

    public IChatBaseComponent i() {
        return this.i != null ? this.i : a;
    }

    @Nullable
    public IChatBaseComponent j() {
        return this.i;
    }

    public void a(@Nullable IChatBaseComponent customName) {
        this.i = customName;
    }

    public abstract WorldServer a();

    public abstract void b();

    public void b(@Nullable IChatBaseComponent lastOutputMessage) {
        this.g = lastOutputMessage;
    }

    public void a(boolean shouldTrackOutput) {
        this.f = shouldTrackOutput;
    }

    public boolean k() {
        return this.f;
    }

    public EnumInteractionResult a(EntityHuman player) {
        if (!(player.gX() || player.gQ() && player.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            return EnumInteractionResult.e;
        }
        if (player.an().D_()) {
            player.a(this);
        }
        return EnumInteractionResult.a;
    }

    public abstract Vec3D c();

    public abstract CommandListenerWrapper a(ICommandListener var1);

    public abstract boolean e();

    public class CloseableCommandBlockSource
    implements ICommandListener,
    AutoCloseable {
        private static final DateTimeFormatter c = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT);
        private boolean d;
        private final boolean trackOutput;

        public CloseableCommandBlockSource(boolean trackOutput) {
            this.trackOutput = trackOutput;
        }

        @DoNotUse
        @Deprecated
        public CloseableCommandBlockSource() {
            this(true);
        }

        @Override
        public boolean z_() {
            return !this.d && CommandBlockListenerAbstract.this.a().S().c(GameRules.q);
        }

        @Override
        public boolean A_() {
            return this.trackOutput && !this.d;
        }

        @Override
        public boolean c() {
            return !this.d && CommandBlockListenerAbstract.this.a().S().c(GameRules.k);
        }

        @Override
        public void a(IChatBaseComponent message) {
            if (this.trackOutput && !this.d) {
                AsyncCatcher.catchOp("sendSystemMessage to a command block");
                CommandBlockListenerAbstract.this.g = IChatBaseComponent.b("[" + c.format(ZonedDateTime.now()) + "] ").b(message);
                CommandBlockListenerAbstract.this.b();
            }
        }

        @Override
        public void close() throws Exception {
            this.d = true;
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return CommandBlockListenerAbstract.this.getBukkitSender(wrapper);
        }
    }
}

