/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;

public interface IBlockAccess
extends LevelHeightAccessor {
    @Nullable
    public TileEntity c_(BlockPosition var1);

    default public <T extends TileEntity> Optional<T> a(BlockPosition pos, TileEntityTypes<T> type) {
        TileEntity blockEntity = this.c_(pos);
        return blockEntity != null && blockEntity.s() == type ? Optional.of(blockEntity) : Optional.empty();
    }

    public IBlockData a_(BlockPosition var1);

    @Nullable
    public IBlockData getBlockStateIfLoaded(BlockPosition var1);

    @Nullable
    default public Block getBlockIfLoaded(BlockPosition pos) {
        IBlockData type = this.getBlockStateIfLoaded(pos);
        return type == null ? null : type.b();
    }

    @Nullable
    public Fluid getFluidIfLoaded(BlockPosition var1);

    public Fluid b_(BlockPosition var1);

    default public int i(BlockPosition pos) {
        return this.a_(pos).k();
    }

    default public Stream<IBlockData> a(AxisAlignedBB area) {
        return BlockPosition.b(area).map(this::a_);
    }

    default public MovingObjectPositionBlock a(ClipBlockStateContext context) {
        return IBlockAccess.a(context.b(), context.a(), context, (traverseContext, traversePos) -> {
            IBlockData blockState = this.a_((BlockPosition)traversePos);
            Vec3D vec3 = traverseContext.b().d(traverseContext.a());
            return traverseContext.c().test(blockState) ? new MovingObjectPositionBlock(traverseContext.a(), EnumDirection.a(vec3.g, vec3.h, vec3.i), BlockPosition.a(traverseContext.a()), false) : null;
        }, failContext -> {
            Vec3D vec3 = failContext.b().d(failContext.a());
            return MovingObjectPositionBlock.a(failContext.a(), EnumDirection.a(vec3.g, vec3.h, vec3.i), BlockPosition.a(failContext.a()));
        });
    }

    default public MovingObjectPositionBlock clip(RayTrace traverseContext, BlockPosition traversePos) {
        return this.clip(traverseContext, traversePos, null);
    }

    default public MovingObjectPositionBlock clip(RayTrace traverseContext, BlockPosition traversePos, @Nullable Predicate<? super org.bukkit.block.Block> canCollide) {
        GeneratorAccess levelAccessor;
        IBlockAccess iBlockAccess;
        IBlockData blockState = this.getBlockStateIfLoaded(traversePos);
        if (blockState == null) {
            Vec3D vec3d = traverseContext.b().d(traverseContext.a());
            return MovingObjectPositionBlock.a(traverseContext.a(), EnumDirection.a(vec3d.g, vec3d.h, vec3d.i), BlockPosition.a(traverseContext.a()));
        }
        if (blockState.l() || canCollide != null && (iBlockAccess = this) instanceof GeneratorAccess && !canCollide.test(CraftBlock.at(levelAccessor = (GeneratorAccess)iBlockAccess, traversePos))) {
            return null;
        }
        Fluid fluidState = blockState.y();
        Vec3D from = traverseContext.b();
        Vec3D to = traverseContext.a();
        VoxelShape blockShape = traverseContext.a(blockState, this, traversePos);
        MovingObjectPositionBlock blockHitResult = this.a(from, to, traversePos, blockShape, blockState);
        VoxelShape fluidShape = traverseContext.a(fluidState, this, traversePos);
        MovingObjectPositionBlock blockHitResult1 = fluidShape.a(from, to, traversePos);
        double d2 = blockHitResult == null ? Double.MAX_VALUE : traverseContext.b().g(blockHitResult.g());
        double d1 = blockHitResult1 == null ? Double.MAX_VALUE : traverseContext.b().g(blockHitResult1.g());
        return d2 <= d1 ? blockHitResult : blockHitResult1;
    }

    default public MovingObjectPositionBlock a(RayTrace context) {
        return this.clip(context, (Predicate<? super org.bukkit.block.Block>)null);
    }

    default public MovingObjectPositionBlock clip(RayTrace context, @Nullable Predicate<? super org.bukkit.block.Block> canCollide) {
        return IBlockAccess.a(context.b(), context.a(), context, (raytrace1, blockposition) -> this.clip((RayTrace)raytrace1, (BlockPosition)blockposition, canCollide), failContext -> {
            Vec3D vec3 = failContext.b().d(failContext.a());
            return MovingObjectPositionBlock.a(failContext.a(), EnumDirection.a(vec3.g, vec3.h, vec3.i), BlockPosition.a(failContext.a()));
        });
    }

    @Nullable
    default public MovingObjectPositionBlock a(Vec3D startVec, Vec3D endVec, BlockPosition pos, VoxelShape shape, IBlockData state) {
        MovingObjectPositionBlock blockHitResult1;
        MovingObjectPositionBlock blockHitResult = shape.a(startVec, endVec, pos);
        if (blockHitResult != null && (blockHitResult1 = state.i(this, pos).a(startVec, endVec, pos)) != null && blockHitResult1.g().d(startVec).h() < blockHitResult.g().d(startVec).h()) {
            return blockHitResult.a(blockHitResult1.c());
        }
        return blockHitResult;
    }

    default public double a(VoxelShape shape, Supplier<VoxelShape> belowShapeSupplier) {
        if (!shape.c()) {
            return shape.c(EnumDirection.EnumAxis.b);
        }
        double d2 = belowShapeSupplier.get().c(EnumDirection.EnumAxis.b);
        return d2 >= 1.0 ? d2 - 1.0 : Double.NEGATIVE_INFINITY;
    }

    default public double j(BlockPosition pos) {
        return this.a(this.a_(pos).g(this, pos), () -> {
            BlockPosition blockPos = pos.e();
            return this.a_(blockPos).g(this, blockPos);
        });
    }

    public static <T, C> T a(Vec3D from, Vec3D to, C context, BiFunction<C, BlockPosition, T> tester, Function<C, T> onFail) {
        int floor2;
        int floor1;
        if (from.equals(to)) {
            return onFail.apply(context);
        }
        double d2 = MathHelper.d(-1.0E-7, to.g, from.g);
        double d1 = MathHelper.d(-1.0E-7, to.h, from.h);
        double d22 = MathHelper.d(-1.0E-7, to.i, from.i);
        double d3 = MathHelper.d(-1.0E-7, from.g, to.g);
        double d4 = MathHelper.d(-1.0E-7, from.h, to.h);
        double d5 = MathHelper.d(-1.0E-7, from.i, to.i);
        int floor = MathHelper.a(d3);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(floor, floor1 = MathHelper.a(d4), floor2 = MathHelper.a(d5));
        T object = tester.apply(context, mutableBlockPos);
        if (object != null) {
            return object;
        }
        double d6 = d2 - d3;
        double d7 = d1 - d4;
        double d8 = d22 - d5;
        int i2 = MathHelper.k(d6);
        int i1 = MathHelper.k(d7);
        int i22 = MathHelper.k(d8);
        double d9 = i2 == 0 ? Double.MAX_VALUE : (double)i2 / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = i22 == 0 ? Double.MAX_VALUE : (double)i22 / d8;
        double d12 = d9 * (i2 > 0 ? 1.0 - MathHelper.f(d3) : MathHelper.f(d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - MathHelper.f(d4) : MathHelper.f(d4));
        double d14 = d11 * (i22 > 0 ? 1.0 - MathHelper.f(d5) : MathHelper.f(d5));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T object1;
            if (d12 < d13) {
                if (d12 < d14) {
                    floor += i2;
                    d12 += d9;
                } else {
                    floor2 += i22;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                floor1 += i1;
                d13 += d10;
            } else {
                floor2 += i22;
                d14 += d11;
            }
            if ((object1 = tester.apply(context, mutableBlockPos.d(floor, floor1, floor2))) == null) continue;
            return object1;
        }
        return onFail.apply(context);
    }

    public static boolean a(Vec3D from, Vec3D to, AxisAlignedBB boundingBox, a visitor) {
        Vec3D vec3 = to.d(from);
        if (vec3.h() < (double)MathHelper.l(1.0E-5f)) {
            for (BlockPosition blockPos : BlockPosition.a(boundingBox)) {
                if (visitor.visit(blockPos, 0)) continue;
                return false;
            }
            return true;
        }
        LongOpenHashSet set = new LongOpenHashSet();
        for (BlockPosition blockPos1 : BlockPosition.a(boundingBox.c(vec3.c(-1.0)), vec3)) {
            if (!visitor.visit(blockPos1, 0)) {
                return false;
            }
            set.add(blockPos1.a());
        }
        int i2 = IBlockAccess.a((LongSet)set, vec3, boundingBox, visitor);
        if (i2 < 0) {
            return false;
        }
        for (BlockPosition blockPos2 : BlockPosition.a(boundingBox, vec3)) {
            if (!set.add(blockPos2.a()) || visitor.visit(blockPos2, i2 + 1)) continue;
            return false;
        }
        return true;
    }

    private static int a(LongSet output, Vec3D travelVector, AxisAlignedBB boundingBox, a stepVisitor) {
        double xsize = boundingBox.b();
        double ysize = boundingBox.c();
        double zsize = boundingBox.d();
        BaseBlockPosition furthestCorner = IBlockAccess.a(travelVector);
        Vec3D center = boundingBox.f();
        Vec3D vec3 = new Vec3D(center.a() + xsize * 0.5 * (double)furthestCorner.u(), center.b() + ysize * 0.5 * (double)furthestCorner.v(), center.c() + zsize * 0.5 * (double)furthestCorner.w());
        Vec3D vec31 = vec3.d(travelVector);
        int floor = MathHelper.a(vec31.g);
        int floor1 = MathHelper.a(vec31.h);
        int floor2 = MathHelper.a(vec31.i);
        int i2 = MathHelper.k(travelVector.g);
        int i1 = MathHelper.k(travelVector.h);
        int i22 = MathHelper.k(travelVector.i);
        double d2 = i2 == 0 ? Double.MAX_VALUE : (double)i2 / travelVector.g;
        double d1 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / travelVector.h;
        double d22 = i22 == 0 ? Double.MAX_VALUE : (double)i22 / travelVector.i;
        double d3 = d2 * (i2 > 0 ? 1.0 - MathHelper.f(vec31.g) : MathHelper.f(vec31.g));
        double d4 = d1 * (i1 > 0 ? 1.0 - MathHelper.f(vec31.h) : MathHelper.f(vec31.h));
        double d5 = d22 * (i22 > 0 ? 1.0 - MathHelper.f(vec31.i) : MathHelper.f(vec31.i));
        int i3 = 0;
        while (d3 <= 1.0 || d4 <= 1.0 || d5 <= 1.0) {
            Optional<Vec3D> optional;
            if (d3 < d4) {
                if (d3 < d5) {
                    floor += i2;
                    d3 += d2;
                } else {
                    floor2 += i22;
                    d5 += d22;
                }
            } else if (d4 < d5) {
                floor1 += i1;
                d4 += d1;
            } else {
                floor2 += i22;
                d5 += d22;
            }
            if ((optional = AxisAlignedBB.a(floor, floor1, floor2, floor + 1, floor1 + 1, floor2 + 1, vec31, vec3)).isEmpty()) continue;
            Vec3D vec32 = optional.get();
            double d6 = MathHelper.a(vec32.g, (double)((float)floor + 1.0E-5f), (double)floor + 1.0 - (double)1.0E-5f);
            double d7 = MathHelper.a(vec32.h, (double)((float)floor1 + 1.0E-5f), (double)floor1 + 1.0 - (double)1.0E-5f);
            double d8 = MathHelper.a(vec32.i, (double)((float)floor2 + 1.0E-5f), (double)floor2 + 1.0 - (double)1.0E-5f);
            int floor3 = MathHelper.a(d6 - xsize * (double)furthestCorner.u());
            int floor4 = MathHelper.a(d7 - ysize * (double)furthestCorner.v());
            int floor5 = MathHelper.a(d8 - zsize * (double)furthestCorner.w());
            int i4 = ++i3;
            for (BlockPosition blockPos : BlockPosition.a(floor, floor1, floor2, floor3, floor4, floor5, travelVector)) {
                if (!output.add(blockPos.a()) || stepVisitor.visit(blockPos, i4)) continue;
                return -1;
            }
        }
        return i3;
    }

    private static BaseBlockPosition a(Vec3D vector) {
        int i2;
        double abs = Math.abs(Vec3D.d.b(vector));
        double abs1 = Math.abs(Vec3D.e.b(vector));
        double abs2 = Math.abs(Vec3D.f.b(vector));
        int i3 = vector.g >= 0.0 ? 1 : -1;
        int i1 = vector.h >= 0.0 ? 1 : -1;
        int n2 = i2 = vector.i >= 0.0 ? 1 : -1;
        if (abs <= abs1 && abs <= abs2) {
            return new BaseBlockPosition(-i3, -i2, i1);
        }
        return abs1 <= abs2 ? new BaseBlockPosition(i2, -i1, -i3) : new BaseBlockPosition(-i1, i3, -i2);
    }

    @FunctionalInterface
    public static interface a {
        public boolean visit(BlockPosition var1, int var2);
    }
}

