/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.VoxelShapeSpliterator;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public interface ICollisionAccess
extends IBlockAccess {
    public WorldBorder u();

    @Nullable
    public IBlockAccess c(int var1, int var2);

    default public boolean a(@Nullable Entity entity, VoxelShape shape) {
        return true;
    }

    default public boolean a(IBlockData state, BlockPosition pos, VoxelShapeCollision context) {
        VoxelShape collisionShape = state.b((IBlockAccess)this, pos, context);
        return collisionShape.c() || this.a(null, collisionShape.a(pos));
    }

    default public boolean f(Entity entity) {
        return this.a(entity, VoxelShapes.a(entity.de()));
    }

    default public boolean b(AxisAlignedBB collisionBox) {
        return this.a((Entity)null, collisionBox);
    }

    default public boolean g(Entity entity) {
        return this.a(entity, entity.de());
    }

    default public boolean a(@Nullable Entity entity, AxisAlignedBB collisionBox) {
        return this.a(entity, collisionBox, false);
    }

    default public boolean a(@Nullable Entity entity, AxisAlignedBB collisionBox, boolean checkLiquid) {
        for (VoxelShape voxelShape : checkLiquid ? this.f(entity, collisionBox) : this.e(entity, collisionBox)) {
            if (voxelShape.c()) continue;
            return false;
        }
        if (!this.c(entity, collisionBox).isEmpty()) {
            return false;
        }
        if (entity == null) {
            return true;
        }
        VoxelShape voxelShape1 = this.i(entity, collisionBox);
        return voxelShape1 == null || !VoxelShapes.c(voxelShape1, VoxelShapes.a(collisionBox), OperatorBoolean.i);
    }

    default public boolean b(@Nullable Entity entity, AxisAlignedBB boundingBox) {
        for (VoxelShape voxelShape : this.e(entity, boundingBox)) {
            if (voxelShape.c()) continue;
            return false;
        }
        return true;
    }

    public List<VoxelShape> c(@Nullable Entity var1, AxisAlignedBB var2);

    default public Iterable<VoxelShape> d(@Nullable Entity entity, AxisAlignedBB collisionBox) {
        List<VoxelShape> entityCollisions = this.c(entity, collisionBox);
        Iterable blockCollisions = this.e(entity, collisionBox);
        return entityCollisions.isEmpty() ? blockCollisions : Iterables.concat(entityCollisions, blockCollisions);
    }

    default public Iterable<VoxelShape> a(@Nullable Entity entity, AxisAlignedBB collisionBox, Vec3D pos) {
        List<VoxelShape> entityCollisions = this.c(entity, collisionBox);
        Iterable blockCollisionsFromContext = this.a(VoxelShapeCollision.a(entity, pos.h), collisionBox);
        return entityCollisions.isEmpty() ? blockCollisionsFromContext : Iterables.concat(entityCollisions, blockCollisionsFromContext);
    }

    default public Iterable<VoxelShape> e(@Nullable Entity entity, AxisAlignedBB collisionBox) {
        return this.a(entity == null ? VoxelShapeCollision.a() : VoxelShapeCollision.a(entity), collisionBox);
    }

    default public Iterable<VoxelShape> f(@Nullable Entity entity, AxisAlignedBB collisionBox) {
        return this.a(entity == null ? VoxelShapeCollision.b() : VoxelShapeCollision.a(entity, true), collisionBox);
    }

    private Iterable<VoxelShape> a(VoxelShapeCollision context, AxisAlignedBB collisionBox) {
        return () -> new VoxelShapeSpliterator<VoxelShape>(this, context, collisionBox, false, (mutableBlockPos, voxelShape) -> voxelShape);
    }

    @Nullable
    private VoxelShape i(Entity entity, AxisAlignedBB box) {
        WorldBorder worldBorder = this.u();
        return worldBorder.a(entity, box) ? worldBorder.a() : null;
    }

    default public MovingObjectPositionBlock b(RayTrace clipContext) {
        MovingObjectPositionBlock blockHitResult = this.a(clipContext);
        WorldBorder worldBorder = this.u();
        if (worldBorder.a(clipContext.b()) && !worldBorder.a(blockHitResult.g())) {
            Vec3D vec3 = blockHitResult.g().d(clipContext.b());
            EnumDirection approximateNearest = EnumDirection.a(vec3.g, vec3.h, vec3.i);
            Vec3D vec31 = worldBorder.c(blockHitResult.g());
            return new MovingObjectPositionBlock(vec31, approximateNearest, BlockPosition.a(vec31), false, true);
        }
        return blockHitResult;
    }

    default public boolean g(@Nullable Entity entity, AxisAlignedBB box) {
        VoxelShapeSpliterator<VoxelShape> blockCollisions = new VoxelShapeSpliterator<VoxelShape>(this, entity, box, true, (mutableBlockPos, voxelShape) -> voxelShape);
        while (blockCollisions.hasNext()) {
            if (((VoxelShape)blockCollisions.next()).c()) continue;
            return true;
        }
        return false;
    }

    default public Optional<BlockPosition> h(Entity entity, AxisAlignedBB box) {
        BlockPosition blockPos = null;
        double d2 = Double.MAX_VALUE;
        VoxelShapeSpliterator<BlockPosition> blockCollisions = new VoxelShapeSpliterator<BlockPosition>(this, entity, box, false, (mutableBlockPos, voxelShape) -> mutableBlockPos);
        while (blockCollisions.hasNext()) {
            BlockPosition blockPos1 = (BlockPosition)blockCollisions.next();
            double d1 = blockPos1.b(entity.dD());
            if (!(d1 < d2) && (d1 != d2 || blockPos != null && blockPos.i(blockPos1) >= 0)) continue;
            blockPos = blockPos1.j();
            d2 = d1;
        }
        return Optional.ofNullable(blockPos);
    }

    default public Optional<Vec3D> a(@Nullable Entity entity, VoxelShape shape, Vec3D pos, double x2, double y2, double z2) {
        if (shape.c()) {
            return Optional.empty();
        }
        AxisAlignedBB aabb = shape.a().c(x2, y2, z2);
        VoxelShape voxelShape = StreamSupport.stream(this.e(entity, aabb).spliterator(), false).filter(voxelShape2 -> this.u() == null || this.u().a(voxelShape2.a())).flatMap(voxelShape2 -> voxelShape2.e().stream()).map(aabb1 -> aabb1.c(x2 / 2.0, y2 / 2.0, z2 / 2.0)).map(VoxelShapes::a).reduce(VoxelShapes.a(), VoxelShapes::a);
        VoxelShape voxelShape1 = VoxelShapes.a(shape, voxelShape, OperatorBoolean.e);
        return voxelShape1.b(pos);
    }
}

