/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevelReader;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.AxisAlignedBB;

public interface IWorldReader
extends ChunkSystemLevelReader,
IBlockLightAccess,
ICollisionAccess,
SignalGetter,
BiomeManager.Provider {
    @Override
    default public IChunkAccess moonrise$syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        if (status == null || status.a(ChunkStatus.n)) {
            throw new IllegalArgumentException("Status: " + status.toString());
        }
        return this.a(chunkX, chunkZ, status, true);
    }

    @Nullable
    public IChunkAccess a(int var1, int var2, ChunkStatus var3, boolean var4);

    @Nullable
    public IChunkAccess getChunkIfLoadedImmediately(int var1, int var2);

    @Nullable
    default public IChunkAccess getChunkIfLoadedImmediately(BlockPosition pos) {
        return this.getChunkIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4);
    }

    @Deprecated
    public boolean b(int var1, int var2);

    public int a(HeightMap.Type var1, int var2, int var3);

    default public int b(HeightMap.Type heightmapType, BlockPosition pos) {
        return this.a(heightmapType, pos.u(), pos.w());
    }

    public int G_();

    public BiomeManager J_();

    default public Holder<BiomeBase> v(BlockPosition pos) {
        return this.J_().a(pos);
    }

    default public Stream<IBlockData> c(AxisAlignedBB aabb) {
        int floor5;
        int floor = MathHelper.a(aabb.a);
        int floor1 = MathHelper.a(aabb.d);
        int floor2 = MathHelper.a(aabb.b);
        int floor3 = MathHelper.a(aabb.e);
        int floor4 = MathHelper.a(aabb.c);
        return this.a(floor, floor2, floor4, floor1, floor3, floor5 = MathHelper.a(aabb.f)) ? this.a(aabb) : Stream.empty();
    }

    @Override
    default public int a(BlockPosition pos, ColorResolver colorResolver) {
        return colorResolver.getColor(this.v(pos).a(), pos.u(), pos.w());
    }

    @Override
    default public Holder<BiomeBase> getNoiseBiome(int x2, int y2, int z2) {
        IChunkAccess chunk = this.a(QuartPos.e(x2), QuartPos.e(z2), ChunkStatus.f, false);
        return chunk != null ? chunk.getNoiseBiome(x2, y2, z2) : this.a(x2, y2, z2);
    }

    public Holder<BiomeBase> a(int var1, int var2, int var3);

    public boolean D_();

    public int T();

    public DimensionManager H_();

    @Override
    default public int M_() {
        return this.H_().n();
    }

    @Override
    default public int N_() {
        return this.H_().o();
    }

    default public BlockPosition a(HeightMap.Type heightmapType, BlockPosition pos) {
        return new BlockPosition(pos.u(), this.a(heightmapType, pos.u(), pos.w()), pos.w());
    }

    default public boolean w(BlockPosition pos) {
        return this.a_(pos).l();
    }

    default public boolean x(BlockPosition pos) {
        if (pos.v() >= this.T()) {
            return this.h(pos);
        }
        BlockPosition blockPos = new BlockPosition(pos.u(), this.T(), pos.w());
        if (!this.h(blockPos)) {
            return false;
        }
        BlockPosition var4 = blockPos.e();
        while (var4.v() > pos.v()) {
            IBlockData blockState = this.a_(var4);
            if (blockState.g() > 0 && !blockState.n()) {
                return false;
            }
            var4 = var4.e();
        }
        return true;
    }

    default public float y(BlockPosition pos) {
        return this.z(pos) - 0.5f;
    }

    @Deprecated
    default public float z(BlockPosition pos) {
        float f2 = (float)this.C(pos) / 15.0f;
        float f1 = f2 / (4.0f - 3.0f * f2);
        return MathHelper.h(this.H_().s(), f1, 1.0f);
    }

    default public IChunkAccess A(BlockPosition pos) {
        return this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    default public IChunkAccess a(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.n, true);
    }

    default public IChunkAccess a(int chunkX, int chunkZ, ChunkStatus chunkStatus) {
        return this.a(chunkX, chunkZ, chunkStatus, true);
    }

    @Override
    @Nullable
    default public IBlockAccess c(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.c, false);
    }

    default public boolean B(BlockPosition pos) {
        return this.b_(pos).a(TagsFluid.a);
    }

    default public boolean d(AxisAlignedBB aabb) {
        int floor = MathHelper.a(aabb.a);
        int ceil = MathHelper.c(aabb.d);
        int floor1 = MathHelper.a(aabb.b);
        int ceil1 = MathHelper.c(aabb.e);
        int floor2 = MathHelper.a(aabb.c);
        int ceil2 = MathHelper.c(aabb.f);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = floor; i2 < ceil; ++i2) {
            for (int i1 = floor1; i1 < ceil1; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    IBlockData blockState = this.a_(mutableBlockPos.d(i2, i1, i22));
                    if (blockState.y().c()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    default public int C(BlockPosition pos) {
        return this.c(pos, this.G_());
    }

    default public int c(BlockPosition pos, int amount) {
        return pos.u() >= -30000000 && pos.w() >= -30000000 && pos.u() < 30000000 && pos.w() < 30000000 ? this.b(pos, amount) : 15;
    }

    @Deprecated
    default public boolean f(int x2, int z2) {
        return this.b(SectionPosition.a(x2), SectionPosition.a(z2));
    }

    @Deprecated
    default public boolean D(BlockPosition pos) {
        return this.f(pos.u(), pos.w());
    }

    @Deprecated
    default public boolean a(BlockPosition from, BlockPosition to) {
        return this.a(from.u(), from.v(), from.w(), to.u(), to.v(), to.w());
    }

    @Deprecated
    default public boolean a(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return toY >= this.M_() && fromY <= this.ar() && this.b(fromX, fromZ, toX, toZ);
    }

    @Deprecated
    default public boolean b(int fromX, int fromZ, int toX, int toZ) {
        int sectionPosCoord = SectionPosition.a(fromX);
        int sectionPosCoord1 = SectionPosition.a(toX);
        int sectionPosCoord2 = SectionPosition.a(fromZ);
        int sectionPosCoord3 = SectionPosition.a(toZ);
        for (int i2 = sectionPosCoord; i2 <= sectionPosCoord1; ++i2) {
            for (int i1 = sectionPosCoord2; i1 <= sectionPosCoord3; ++i1) {
                if (this.b(i2, i1)) continue;
                return false;
            }
        }
        return true;
    }

    public IRegistryCustom L_();

    public FeatureFlagSet O();

    default public <T> HolderLookup<T> a(ResourceKey<? extends IRegistry<? extends T>> registryKey) {
        IRegistry registry = this.L_().f(registryKey);
        return registry.a(this.O());
    }
}

