/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapeCollisionEntity;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class RayTrace {
    private final Vec3D a;
    private final Vec3D b;
    private final BlockCollisionOption c;
    public final FluidCollisionOption d;
    private final VoxelShapeCollision e;

    public RayTrace(Vec3D from, Vec3D to, BlockCollisionOption block, FluidCollisionOption fluid, Entity entity) {
        this(from, to, block, fluid, entity == null ? VoxelShapeCollision.a() : VoxelShapeCollision.a(entity));
    }

    public RayTrace(Vec3D from, Vec3D to, BlockCollisionOption block, FluidCollisionOption fluid, VoxelShapeCollision collisionContext) {
        this.a = from;
        this.b = to;
        this.c = block;
        this.d = fluid;
        this.e = collisionContext;
    }

    public Vec3D a() {
        return this.b;
    }

    public Vec3D b() {
        return this.a;
    }

    public VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return this.c.get(state, level, pos, this.e);
    }

    public VoxelShape a(Fluid state, IBlockAccess level, BlockPosition pos) {
        return this.d.a(state) ? state.d(level, pos) : VoxelShapes.a();
    }

    public static final class BlockCollisionOption
    extends Enum<BlockCollisionOption>
    implements c {
        public static final /* enum */ BlockCollisionOption a = new BlockCollisionOption(BlockBase.BlockData::b);
        public static final /* enum */ BlockCollisionOption b = new BlockCollisionOption(BlockBase.BlockData::a);
        public static final /* enum */ BlockCollisionOption c = new BlockCollisionOption(BlockBase.BlockData::c);
        public static final /* enum */ BlockCollisionOption d = new BlockCollisionOption((state, level, pos, collisionContext) -> {
            VoxelShapeCollisionEntity entityCollisionContext;
            if (state.a(TagsBlock.be)) {
                return VoxelShapes.b();
            }
            if (collisionContext instanceof VoxelShapeCollisionEntity && (entityCollisionContext = (VoxelShapeCollisionEntity)collisionContext).f() != null && entityCollisionContext.f().ax() == EntityTypes.bX) {
                if (state.a(Blocks.lB) || state.a(Blocks.gm)) {
                    return VoxelShapes.b();
                }
                if (level instanceof WorldServer) {
                    WorldServer serverLevel = (WorldServer)level;
                    if (state.a(Blocks.eI) && serverLevel.S().d(GameRules.G) == 0) {
                        return VoxelShapes.b();
                    }
                }
            }
            return VoxelShapes.a();
        });
        private final c e;
        private static final /* synthetic */ BlockCollisionOption[] f;

        public static BlockCollisionOption[] values() {
            return (BlockCollisionOption[])f.clone();
        }

        public static BlockCollisionOption valueOf(String name) {
            return Enum.valueOf(BlockCollisionOption.class, name);
        }

        private BlockCollisionOption(c shapeGetter) {
            this.e = shapeGetter;
        }

        @Override
        public VoxelShape get(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision collisionContext) {
            return this.e.get(state, level, pos, collisionContext);
        }

        private static /* synthetic */ BlockCollisionOption[] a() {
            return new BlockCollisionOption[]{a, b, c, d};
        }

        static {
            f = BlockCollisionOption.a();
        }
    }

    public static final class FluidCollisionOption
    extends Enum<FluidCollisionOption> {
        public static final /* enum */ FluidCollisionOption a = new FluidCollisionOption(fluid -> false);
        public static final /* enum */ FluidCollisionOption b = new FluidCollisionOption(Fluid::b);
        public static final /* enum */ FluidCollisionOption c = new FluidCollisionOption(fluid -> !fluid.c());
        public static final /* enum */ FluidCollisionOption d = new FluidCollisionOption(fluid -> fluid.a(TagsFluid.a));
        private final Predicate<Fluid> e;
        private static final /* synthetic */ FluidCollisionOption[] f;

        public static FluidCollisionOption[] values() {
            return (FluidCollisionOption[])f.clone();
        }

        public static FluidCollisionOption valueOf(String name) {
            return Enum.valueOf(FluidCollisionOption.class, name);
        }

        private FluidCollisionOption(Predicate<Fluid> canPick) {
            this.e = canPick;
        }

        public boolean a(Fluid state) {
            return this.e.test(state);
        }

        private static /* synthetic */ FluidCollisionOption[] a() {
            return new FluidCollisionOption[]{a, b, c, d};
        }

        static {
            f = FluidCollisionOption.a();
        }
    }

    public static interface c {
        public VoxelShape get(IBlockData var1, IBlockAccess var2, BlockPosition var3, VoxelShapeCollision var4);
    }
}

