/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class StructureManager {
    public final GeneratorAccess a;
    private final WorldOptions b;
    private final StructureCheck c;

    public StructureManager(GeneratorAccess level, WorldOptions worldOptions, StructureCheck structureCheck) {
        this.a = level;
        this.b = worldOptions;
        this.c = structureCheck;
    }

    public StructureManager a(RegionLimitedWorldAccess region) {
        if (region.a() != this.a) {
            throw new IllegalStateException("Using invalid structure manager (source level: " + String.valueOf(region.a()) + ", region: " + String.valueOf(region));
        }
        return new StructureManager(region, this.b, this.c);
    }

    public List<StructureStart> a(ChunkCoordIntPair chunkPos, Predicate<Structure> structurePredicate) {
        return this.startsForStructure(chunkPos, structurePredicate, null);
    }

    public List<StructureStart> startsForStructure(ChunkCoordIntPair chunkPos, Predicate<Structure> structurePredicate, @Nullable WorldAccess levelAccessor) {
        Map<Structure, LongSet> allReferences = (levelAccessor == null ? this.a : levelAccessor).a(chunkPos.h, chunkPos.i, ChunkStatus.e).h();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<Structure, LongSet> entry : allReferences.entrySet()) {
            Structure structure = entry.getKey();
            if (!structurePredicate.test(structure)) continue;
            this.a(structure, entry.getValue(), arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    public List<StructureStart> a(SectionPosition sectionPos, Structure structure) {
        LongSet referencesForStructure = this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.e).b(structure);
        ImmutableList.Builder builder = ImmutableList.builder();
        this.a(structure, referencesForStructure, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public void a(Structure structure, LongSet structureRefs, Consumer<StructureStart> startConsumer) {
        LongIterator longIterator = structureRefs.iterator();
        while (longIterator.hasNext()) {
            long l2 = (Long)longIterator.next();
            SectionPosition sectionPos = SectionPosition.a(new ChunkCoordIntPair(l2), this.a.at());
            StructureStart startForStructure = this.a(sectionPos, structure, this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.d));
            if (startForStructure == null || !startForStructure.b()) continue;
            startConsumer.accept(startForStructure);
        }
    }

    @Nullable
    public StructureStart a(SectionPosition sectionPos, Structure structure, StructureAccess structureAccess) {
        return structureAccess.a(structure);
    }

    public void a(SectionPosition sectionPos, Structure structure, StructureStart structureStart, StructureAccess structureAccess) {
        structureAccess.a(structure, structureStart);
    }

    public void a(SectionPosition sectionPos, Structure structure, long reference, StructureAccess structureAccess) {
        structureAccess.a(structure, reference);
    }

    public boolean a() {
        return this.b.d();
    }

    public StructureStart a(BlockPosition pos, Structure structure) {
        for (StructureStart structureStart : this.a(SectionPosition.a(pos), structure)) {
            if (!structureStart.a().b(pos)) continue;
            return structureStart;
        }
        return StructureStart.b;
    }

    public StructureStart a(BlockPosition pos, TagKey<Structure> structureTag) {
        return this.a(pos, (Holder<Structure> holder) -> holder.a(structureTag));
    }

    public StructureStart a(BlockPosition pos, HolderSet<Structure> structures) {
        return this.getStructureWithPieceAt(pos, structures, null);
    }

    public StructureStart getStructureWithPieceAt(BlockPosition pos, HolderSet<Structure> structures, @Nullable WorldAccess levelAccessor) {
        return this.getStructureWithPieceAt(pos, structures::a, levelAccessor);
    }

    public StructureStart a(BlockPosition pos, Predicate<Holder<Structure>> predicate) {
        return this.getStructureWithPieceAt(pos, predicate, null);
    }

    public StructureStart getStructureWithPieceAt(BlockPosition pos, TagKey<Structure> tag, @Nullable WorldAccess levelAccessor) {
        return this.getStructureWithPieceAt(pos, (Holder<Structure> structure) -> structure.a(tag), levelAccessor);
    }

    public StructureStart getStructureWithPieceAt(BlockPosition pos, Predicate<Holder<Structure>> predicate, @Nullable WorldAccess levelAccessor) {
        IRegistry<Structure> registry = this.b().f(Registries.bm);
        for (StructureStart structureStart : this.startsForStructure(new ChunkCoordIntPair(pos), structure -> registry.c(registry.a((Structure)structure)).map(predicate::test).orElse(false), levelAccessor)) {
            if (!this.a(pos, structureStart)) continue;
            return structureStart;
        }
        return StructureStart.b;
    }

    public StructureStart b(BlockPosition pos, Structure structure) {
        for (StructureStart structureStart : this.a(SectionPosition.a(pos), structure)) {
            if (!this.a(pos, structureStart)) continue;
            return structureStart;
        }
        return StructureStart.b;
    }

    public boolean a(BlockPosition pos, StructureStart structureStart) {
        for (StructurePiece structurePiece : structureStart.i()) {
            if (!structurePiece.f().b(pos)) continue;
            return true;
        }
        return false;
    }

    public boolean a(BlockPosition pos) {
        SectionPosition sectionPos = SectionPosition.a(pos);
        return this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.e).y();
    }

    public Map<Structure, LongSet> b(BlockPosition pos) {
        SectionPosition sectionPos = SectionPosition.a(pos);
        return this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.e).h();
    }

    public StructureCheckResult a(ChunkCoordIntPair chunkPos, Structure structure, StructurePlacement placement, boolean skipKnownStructures) {
        return this.c.a(chunkPos, structure, placement, skipKnownStructures);
    }

    public void a(StructureStart structureStart) {
        structureStart.e();
        this.c.a(structureStart.c(), structureStart.h());
    }

    public IRegistryCustom b() {
        return this.a.L_();
    }
}

