/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.INamable;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeParticles;
import net.minecraft.world.level.biome.CaveSound;
import net.minecraft.world.level.biome.CaveSoundSettings;

public class BiomeFog {
    public static final Codec<BiomeFog> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("fog_color").forGetter(effects -> effects.b), (App)Codec.INT.fieldOf("water_color").forGetter(effects -> effects.c), (App)Codec.INT.fieldOf("water_fog_color").forGetter(effects -> effects.d), (App)Codec.INT.fieldOf("sky_color").forGetter(effects -> effects.e), (App)Codec.INT.optionalFieldOf("foliage_color").forGetter(effects -> effects.f), (App)Codec.INT.optionalFieldOf("dry_foliage_color").forGetter(effects -> effects.g), (App)Codec.INT.optionalFieldOf("grass_color").forGetter(biomeSpecialEffects -> biomeSpecialEffects.h), (App)GrassColor.d.optionalFieldOf("grass_color_modifier", (Object)GrassColor.a).forGetter(biomeSpecialEffects -> biomeSpecialEffects.i), (App)BiomeParticles.a.optionalFieldOf("particle").forGetter(effects -> effects.j), (App)SoundEffect.b.optionalFieldOf("ambient_sound").forGetter(effects -> effects.k), (App)CaveSoundSettings.a.optionalFieldOf("mood_sound").forGetter(effects -> effects.l), (App)CaveSound.a.optionalFieldOf("additions_sound").forGetter(effects -> effects.m), (App)WeightedList.a(Music.a).optionalFieldOf("music").forGetter(biomeSpecialEffects -> biomeSpecialEffects.n), (App)Codec.FLOAT.fieldOf("music_volume").orElse((Object)Float.valueOf(1.0f)).forGetter(biomeSpecialEffects -> Float.valueOf(biomeSpecialEffects.o))).apply((Applicative)instance, BiomeFog::new));
    private final int b;
    private final int c;
    private final int d;
    private final int e;
    private final Optional<Integer> f;
    private final Optional<Integer> g;
    private final Optional<Integer> h;
    private final GrassColor i;
    private final Optional<BiomeParticles> j;
    private final Optional<Holder<SoundEffect>> k;
    private final Optional<CaveSoundSettings> l;
    private final Optional<CaveSound> m;
    private final Optional<WeightedList<Music>> n;
    private final float o;

    BiomeFog(int fogColor, int waterColor, int waterFogColor, int skyColor, Optional<Integer> foliageColorOverride, Optional<Integer> dryFoliageColorOverride, Optional<Integer> grassColorOverride, GrassColor grassColorModifier, Optional<BiomeParticles> ambientParticleSettings, Optional<Holder<SoundEffect>> ambientLoopSoundEvent, Optional<CaveSoundSettings> ambientMoodSettings, Optional<CaveSound> ambientAdditionsSettings, Optional<WeightedList<Music>> backgroundMusic, float backgroundMusicVolume) {
        this.b = fogColor;
        this.c = waterColor;
        this.d = waterFogColor;
        this.e = skyColor;
        this.f = foliageColorOverride;
        this.g = dryFoliageColorOverride;
        this.h = grassColorOverride;
        this.i = grassColorModifier;
        this.j = ambientParticleSettings;
        this.k = ambientLoopSoundEvent;
        this.l = ambientMoodSettings;
        this.m = ambientAdditionsSettings;
        this.n = backgroundMusic;
        this.o = backgroundMusicVolume;
    }

    public int a() {
        return this.b;
    }

    public int b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    public int d() {
        return this.e;
    }

    public Optional<Integer> e() {
        return this.f;
    }

    public Optional<Integer> f() {
        return this.g;
    }

    public Optional<Integer> g() {
        return this.h;
    }

    public GrassColor h() {
        return this.i;
    }

    public Optional<BiomeParticles> i() {
        return this.j;
    }

    public Optional<Holder<SoundEffect>> j() {
        return this.k;
    }

    public Optional<CaveSoundSettings> k() {
        return this.l;
    }

    public Optional<CaveSound> l() {
        return this.m;
    }

    public Optional<WeightedList<Music>> m() {
        return this.n;
    }

    public float n() {
        return this.o;
    }

    public static abstract sealed class GrassColor
    extends Enum<GrassColor>
    implements INamable {
        public static final /* enum */ GrassColor a = new GrassColor("none"){

            @Override
            public int a(double x2, double z2, int grassColor) {
                return grassColor;
            }
        };
        public static final /* enum */ GrassColor b = new GrassColor("dark_forest"){

            @Override
            public int a(double x2, double z2, int grassColor) {
                return (grassColor & 0xFEFEFE) + 2634762 >> 1;
            }
        };
        public static final /* enum */ GrassColor c = new GrassColor("swamp"){

            @Override
            public int a(double x2, double z2, int grassColor) {
                double value = BiomeBase.e.a(x2 * 0.0225, z2 * 0.0225, false);
                return value < -0.1 ? 5011004 : 6975545;
            }
        };
        private final String e;
        public static final Codec<GrassColor> d;
        private static final /* synthetic */ GrassColor[] f;

        public static GrassColor[] values() {
            return (GrassColor[])f.clone();
        }

        public static GrassColor valueOf(String name) {
            return Enum.valueOf(GrassColor.class, name);
        }

        public abstract int a(double var1, double var3, int var5);

        private GrassColor(String name) {
            this.e = name;
        }

        public String a() {
            return this.e;
        }

        @Override
        public String c() {
            return this.e;
        }

        private static /* synthetic */ GrassColor[] b() {
            return new GrassColor[]{a, b, c};
        }

        static {
            f = GrassColor.b();
            d = INamable.a(GrassColor::values);
        }
    }

    public static class a {
        private OptionalInt a = OptionalInt.empty();
        private OptionalInt b = OptionalInt.empty();
        private OptionalInt c = OptionalInt.empty();
        private OptionalInt d = OptionalInt.empty();
        private Optional<Integer> e = Optional.empty();
        private Optional<Integer> f = Optional.empty();
        private Optional<Integer> g = Optional.empty();
        private GrassColor h = GrassColor.a;
        private Optional<BiomeParticles> i = Optional.empty();
        private Optional<Holder<SoundEffect>> j = Optional.empty();
        private Optional<CaveSoundSettings> k = Optional.empty();
        private Optional<CaveSound> l = Optional.empty();
        private Optional<WeightedList<Music>> m = Optional.empty();
        private float n = 1.0f;

        public a a(int fogColor) {
            this.a = OptionalInt.of(fogColor);
            return this;
        }

        public a b(int waterColor) {
            this.b = OptionalInt.of(waterColor);
            return this;
        }

        public a c(int waterFogColor) {
            this.c = OptionalInt.of(waterFogColor);
            return this;
        }

        public a d(int skyColor) {
            this.d = OptionalInt.of(skyColor);
            return this;
        }

        public a e(int foliageColorOverride) {
            this.e = Optional.of(foliageColorOverride);
            return this;
        }

        public a f(int dryFoliageColorOverride) {
            this.f = Optional.of(dryFoliageColorOverride);
            return this;
        }

        public a g(int grassColorOverride) {
            this.g = Optional.of(grassColorOverride);
            return this;
        }

        public a a(GrassColor grassColorModifier) {
            this.h = grassColorModifier;
            return this;
        }

        public a a(BiomeParticles ambientParticle) {
            this.i = Optional.of(ambientParticle);
            return this;
        }

        public a a(Holder<SoundEffect> ambientLoopSoundEvent) {
            this.j = Optional.of(ambientLoopSoundEvent);
            return this;
        }

        public a a(CaveSoundSettings ambientMoodSettings) {
            this.k = Optional.of(ambientMoodSettings);
            return this;
        }

        public a a(CaveSound ambientAdditionsSettings) {
            this.l = Optional.of(ambientAdditionsSettings);
            return this;
        }

        public a a(@Nullable Music backgroundMusic) {
            if (backgroundMusic == null) {
                this.m = Optional.empty();
                return this;
            }
            this.m = Optional.of(WeightedList.a(backgroundMusic));
            return this;
        }

        public a a() {
            return this.a(WeightedList.a()).a(0.0f);
        }

        public a a(WeightedList<Music> backgroundMusic) {
            this.m = Optional.of(backgroundMusic);
            return this;
        }

        public a a(float backgroundMusicVolume) {
            this.n = backgroundMusicVolume;
            return this;
        }

        public BiomeFog b() {
            return new BiomeFog(this.a.orElseThrow(() -> new IllegalStateException("Missing 'fog' color.")), this.b.orElseThrow(() -> new IllegalStateException("Missing 'water' color.")), this.c.orElseThrow(() -> new IllegalStateException("Missing 'water fog' color.")), this.d.orElseThrow(() -> new IllegalStateException("Missing 'sky' color.")), this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l, this.m, this.n);
        }
    }
}

