/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import org.slf4j.Logger;

public class BiomeSettingsMobs {
    private static final Logger d = LogUtils.getLogger();
    private static final float e = 0.1f;
    public static final WeightedList<c> a = WeightedList.a();
    public static final BiomeSettingsMobs b = new a().a();
    public static final MapCodec<BiomeSettingsMobs> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)0.9999999f).optionalFieldOf("creature_spawn_probability", (Object)Float.valueOf(0.1f)).forGetter(settings -> Float.valueOf(settings.f)), (App)Codec.simpleMap(EnumCreatureType.i, (Codec)WeightedList.a(net.minecraft.world.level.biome.BiomeSettingsMobs$c.a).promotePartial(SystemUtils.a("Spawn data: ", arg_0 -> ((Logger)d).error(arg_0))), (Keyable)INamable.b(EnumCreatureType.values())).fieldOf("spawners").forGetter(settings -> settings.g), (App)Codec.simpleMap(BuiltInRegistries.g.q(), net.minecraft.world.level.biome.BiomeSettingsMobs$b.a, BuiltInRegistries.g).fieldOf("spawn_costs").forGetter(settings -> settings.h)).apply((Applicative)instance, BiomeSettingsMobs::new));
    private final float f;
    private final Map<EnumCreatureType, WeightedList<c>> g;
    private final Map<EntityTypes<?>, b> h;

    BiomeSettingsMobs(float creatureGenerationProbability, Map<EnumCreatureType, WeightedList<c>> spawners, Map<EntityTypes<?>, b> mobSpawnCosts) {
        this.f = creatureGenerationProbability;
        this.g = ImmutableMap.copyOf(spawners);
        this.h = ImmutableMap.copyOf(mobSpawnCosts);
    }

    public WeightedList<c> a(EnumCreatureType category) {
        return this.g.getOrDefault(category, a);
    }

    @Nullable
    public b a(EntityTypes<?> entityType) {
        return this.h.get(entityType);
    }

    public float a() {
        return this.f;
    }

    public static final class b
    extends Record {
        private final double b;
        private final double c;
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(cost -> cost.b), (App)Codec.DOUBLE.fieldOf("charge").forGetter(cost -> cost.c)).apply((Applicative)instance, b::new));

        public b(double energyBudget, double charge) {
            this.b = energyBudget;
            this.c = charge;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "energyBudget;charge", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "energyBudget;charge", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "energyBudget;charge", "b", "c"}, this, o2);
        }

        public double a() {
            return this.b;
        }

        public double b() {
            return this.c;
        }
    }

    public static final class c
    extends Record {
        private final EntityTypes<?> b;
        private final int c;
        private final int d;
        public static final MapCodec<c> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.g.q().fieldOf("type").forGetter(data -> data.b), (App)ExtraCodecs.p.fieldOf("minCount").forGetter(data -> data.c), (App)ExtraCodecs.p.fieldOf("maxCount").forGetter(data -> data.d)).apply((Applicative)instance, c::new)).validate(spawnerData -> spawnerData.c > spawnerData.d ? DataResult.error(() -> "minCount needs to be smaller or equal to maxCount") : DataResult.success((Object)spawnerData));

        public c(EntityTypes<?> type, int minCount, int maxCount) {
            type = type.f() == EnumCreatureType.h ? EntityTypes.aV : type;
            this.b = type;
            this.c = minCount;
            this.d = maxCount;
        }

        @Override
        public String toString() {
            return String.valueOf(EntityTypes.a(this.b)) + "*(" + this.c + "-" + this.d + ")";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "type;minCount;maxCount", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "type;minCount;maxCount", "b", "c", "d"}, this, o2);
        }

        public EntityTypes<?> a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }

        public int c() {
            return this.d;
        }
    }

    public static class a {
        private final Map<EnumCreatureType, WeightedList.a<c>> a = SystemUtils.a(EnumCreatureType.class, mobCategory -> new MobListBuilder());
        private final Map<EntityTypes<?>, b> b = Maps.newLinkedHashMap();
        private float c = 0.1f;

        public a a(EnumCreatureType category, int weight, c spawnerData) {
            this.a.get(category).a(spawnerData, weight);
            return this;
        }

        public a a(EntityTypes<?> entityType, double charge, double energyBudget) {
            this.b.put(entityType, new b(energyBudget, charge));
            return this;
        }

        public a a(float probability) {
            this.c = probability;
            return this;
        }

        public BiomeSettingsMobs a() {
            return new BiomeSettingsMobs(this.c, (Map)this.a.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((WeightedList.a)entry.getValue()).a())), (Map<EntityTypes<?>, b>)ImmutableMap.copyOf(this.b));
        }

        public static class MobListBuilder<E>
        extends WeightedList.a<E> {
            @Override
            public WeightedList<E> a() {
                return new WeightedSpawnerDataList(this.a.build());
            }
        }

        public static class WeightedSpawnerDataList<E>
        extends WeightedList<E> {
            private final Set<E> spawnerDataSet = new HashSet();

            public WeightedSpawnerDataList(List<? extends Weighted<E>> items) {
                super(items);
                for (Weighted<E> item : items) {
                    this.spawnerDataSet.add(item.a());
                }
            }

            @Override
            public boolean b(E element) {
                return this.spawnerDataSet.contains(element);
            }
        }
    }
}

