/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;

public abstract class WorldChunkManager
implements BiomeResolver {
    public static final Codec<WorldChunkManager> a = BuiltInRegistries.aa.q().dispatchStable(WorldChunkManager::a, Function.identity());
    private final Supplier<Set<Holder<BiomeBase>>> b = Suppliers.memoize(() -> (Set)this.b().distinct().collect(ImmutableSet.toImmutableSet()));

    protected WorldChunkManager() {
    }

    protected abstract MapCodec<? extends WorldChunkManager> a();

    protected abstract Stream<Holder<BiomeBase>> b();

    public Set<Holder<BiomeBase>> c() {
        return this.b.get();
    }

    public Set<Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, Climate.Sampler sampler) {
        int quartPosCoord = QuartPos.a(x2 - radius);
        int quartPosCoord1 = QuartPos.a(y2 - radius);
        int quartPosCoord2 = QuartPos.a(z2 - radius);
        int quartPosCoord3 = QuartPos.a(x2 + radius);
        int quartPosCoord4 = QuartPos.a(y2 + radius);
        int quartPosCoord5 = QuartPos.a(z2 + radius);
        int i2 = quartPosCoord3 - quartPosCoord + 1;
        int i1 = quartPosCoord4 - quartPosCoord1 + 1;
        int i22 = quartPosCoord5 - quartPosCoord2 + 1;
        HashSet set = Sets.newHashSet();
        for (int i3 = 0; i3 < i22; ++i3) {
            for (int i4 = 0; i4 < i2; ++i4) {
                for (int i5 = 0; i5 < i1; ++i5) {
                    int i6 = quartPosCoord + i4;
                    int i7 = quartPosCoord1 + i5;
                    int i8 = quartPosCoord2 + i3;
                    set.add(this.getNoiseBiome(i6, i7, i8, sampler));
                }
            }
        }
        return set;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, Predicate<Holder<BiomeBase>> biomePredicate, RandomSource random, Climate.Sampler sampler) {
        return this.a(x2, y2, z2, radius, 1, biomePredicate, random, false, sampler);
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(BlockPosition pos, int radius, int horizontalStep, int verticalStep, Predicate<Holder<BiomeBase>> biomePredicate, Climate.Sampler sampler, IWorldReader level) {
        Set set = this.c().stream().filter(biomePredicate).collect(Collectors.toUnmodifiableSet());
        if (set.isEmpty()) {
            return null;
        }
        int i2 = Math.floorDiv(radius, horizontalStep);
        int[] ints = MathHelper.a(pos.v(), level.M_() + 1, level.ar() + 1, verticalStep).toArray();
        for (BlockPosition.MutableBlockPosition mutableBlockPos : BlockPosition.a(BlockPosition.c, i2, EnumDirection.f, EnumDirection.d)) {
            int i1 = pos.u() + mutableBlockPos.u() * horizontalStep;
            int i22 = pos.w() + mutableBlockPos.w() * horizontalStep;
            int quartPosCoord = QuartPos.a(i1);
            int quartPosCoord1 = QuartPos.a(i22);
            for (int i3 : ints) {
                int quartPosCoord2 = QuartPos.a(i3);
                Holder<BiomeBase> noiseBiome = this.getNoiseBiome(quartPosCoord, quartPosCoord2, quartPosCoord1, sampler);
                if (!set.contains(noiseBiome)) continue;
                return Pair.of((Object)new BlockPosition(i1, i3, i22), noiseBiome);
            }
        }
        return null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, int increment, Predicate<Holder<BiomeBase>> biomePredicate, RandomSource random, boolean findClosest, Climate.Sampler sampler) {
        int i1;
        int quartPosX = QuartPos.a(x2);
        int quartPosZ = QuartPos.a(z2);
        int quartPosCoord = QuartPos.a(radius);
        int quartPosY = QuartPos.a(y2);
        Pair pair = null;
        int i2 = 0;
        for (int i22 = i1 = findClosest ? 0 : quartPosCoord; i22 <= quartPosCoord; i22 += increment) {
            int i3;
            int n2 = i3 = !SharedConstants.aE && !SharedConstants.aD ? -i22 : 0;
            while (i3 <= i22) {
                boolean flag = Math.abs(i3) == i22;
                for (int i4 = -i22; i4 <= i22; i4 += increment) {
                    int i6;
                    int i5;
                    Holder<BiomeBase> noiseBiome;
                    if (findClosest) {
                        boolean flag1;
                        boolean bl = flag1 = Math.abs(i4) == i22;
                        if (!flag1 && !flag) continue;
                    }
                    if (!biomePredicate.test(noiseBiome = this.getNoiseBiome(i5 = quartPosX + i4, quartPosY, i6 = quartPosZ + i3, sampler))) continue;
                    if (pair == null || random.a(i2 + 1) == 0) {
                        BlockPosition blockPos = new BlockPosition(QuartPos.c(i5), y2, QuartPos.c(i6));
                        if (findClosest) {
                            return Pair.of((Object)blockPos, noiseBiome);
                        }
                        pair = Pair.of((Object)blockPos, noiseBiome);
                    }
                    ++i2;
                }
                i3 += increment;
            }
        }
        return pair;
    }

    @Override
    public abstract Holder<BiomeBase> getNoiseBiome(int var1, int var2, int var3, Climate.Sampler var4);

    public void a(List<String> info, BlockPosition pos, Climate.Sampler sampler) {
    }
}

