/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class AmethystClusterBlock
extends AmethystBlock
implements IBlockWaterlogged {
    public static final MapCodec<AmethystClusterBlock> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("height").forGetter(amethystClusterBlock -> Float.valueOf(amethystClusterBlock.e)), (App)Codec.FLOAT.fieldOf("width").forGetter(amethystClusterBlock -> Float.valueOf(amethystClusterBlock.f)), AmethystClusterBlock.x()).apply((Applicative)instance, AmethystClusterBlock::new));
    public static final BlockStateBoolean c = BlockProperties.I;
    public static final BlockStateEnum<EnumDirection> d = BlockProperties.R;
    private final float e;
    private final float f;
    private final Map<EnumDirection, VoxelShape> g;

    public MapCodec<AmethystClusterBlock> a() {
        return b;
    }

    public AmethystClusterBlock(float height, float aabbOffset, BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)this.m().b(c, false)).b(d, EnumDirection.b));
        this.g = VoxelShapes.d(Block.c(aabbOffset, 16.0f - height, 16.0));
        this.e = height;
        this.f = aabbOffset;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.g.get(state.c(d));
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        EnumDirection direction = state.c(d);
        BlockPosition blockPos = pos.a(direction.g());
        return level.a_(blockPos).c((IBlockAccess)level, blockPos, direction);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(c).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return direction == state.c(d).g() && !state.a(level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        World level = context.q();
        BlockPosition clickedPos = context.a();
        return (IBlockData)((IBlockData)this.m().b(c, level.b_(clickedPos).a() == FluidTypes.c)).b(d, context.k());
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(d, rotation.a(state.c(d)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(d)));
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(c) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, d);
    }
}

