/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;

public class BigDripleafBlock
extends BlockFacingHorizontal
implements IBlockFragilePlantElement,
IBlockWaterlogged {
    public static final MapCodec<BigDripleafBlock> a = BigDripleafBlock.b(BigDripleafBlock::new);
    private static final BlockStateBoolean b = BlockProperties.I;
    private static final BlockStateEnum<Tilt> c = BlockProperties.bq;
    private static final int d = -1;
    private static final Object2IntMap<Tilt> e = (Object2IntMap)SystemUtils.a(new Object2IntArrayMap(), (? super T map) -> {
        map.defaultReturnValue(-1);
        map.put((Object)Tilt.b, 10);
        map.put((Object)Tilt.c, 10);
        map.put((Object)Tilt.d, 100);
    });
    private static final int g = 5;
    private static final int h = 11;
    private static final int i = 13;
    private static final Map<Tilt, VoxelShape> D = Maps.newEnumMap(Map.of(Tilt.a, Block.b(16.0, 11.0, 15.0), Tilt.b, Block.b(16.0, 11.0, 15.0), Tilt.c, Block.b(16.0, 11.0, 13.0), Tilt.d, VoxelShapes.a()));
    private final Function<IBlockData, VoxelShape> R;

    public MapCodec<BigDripleafBlock> a() {
        return a;
    }

    protected BigDripleafBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, false)).b(BlockFacingHorizontal.f, EnumDirection.c)).b(c, Tilt.a));
        this.R = this.q();
    }

    private Function<IBlockData, VoxelShape> q() {
        Map<EnumDirection, VoxelShape> map = VoxelShapes.c(Block.b(6.0, 0.0, 13.0).a(0.0, 0.0, 0.25).d());
        return this.a((IBlockData blockState) -> VoxelShapes.a(D.get(blockState.c(c)), (VoxelShape)map.get(blockState.c(BlockFacingHorizontal.f))), b);
    }

    public static void a(GeneratorAccess level, RandomSource random, BlockPosition pos, EnumDirection direction) {
        int i2;
        int randomInt = MathHelper.a(random, 2, 5);
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        for (i2 = 0; i2 < randomInt && BigDripleafBlock.a((LevelHeightAccessor)level, (BlockPosition)mutableBlockPos, level.a_(mutableBlockPos)); ++i2) {
            mutableBlockPos.c(EnumDirection.b);
        }
        int i1 = pos.v() + i2 - 1;
        mutableBlockPos.q(pos.v());
        while (mutableBlockPos.v() < i1) {
            BigDripleafStemBlock.a(level, (BlockPosition)mutableBlockPos, level.b_(mutableBlockPos), direction);
            mutableBlockPos.c(EnumDirection.b);
        }
        BigDripleafBlock.a(level, (BlockPosition)mutableBlockPos, level.b_(mutableBlockPos), direction);
    }

    private static boolean p(IBlockData state) {
        return state.l() || state.a(Blocks.J) || state.a(Blocks.ue);
    }

    protected static boolean a(LevelHeightAccessor level, BlockPosition pos, IBlockData state) {
        return !level.u(pos) && BigDripleafBlock.p(state);
    }

    protected static boolean a(GeneratorAccess level, BlockPosition pos, Fluid fluidState, EnumDirection direction) {
        IBlockData blockState = (IBlockData)((IBlockData)Blocks.uc.m().b(b, fluidState.a(FluidTypes.c))).b(BlockFacingHorizontal.f, direction);
        return level.a(pos, blockState, 3);
    }

    @Override
    protected void a(World level, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        this.setTiltAndScheduleTick(state, level, hit.b(), Tilt.d, SoundEffects.iN, projectile);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(b) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        IBlockData blockState = level.a_(blockPos);
        return blockState.a(this) || blockState.a(Blocks.ud) || blockState.a(TagsBlock.bK);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (direction == EnumDirection.a && !state.a(level, pos)) {
            return Blocks.a.m();
        }
        if (state.c(b).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return direction == EnumDirection.b && neighborState.a(this) ? Blocks.ud.m(state) : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        IBlockData blockState = level.a_(pos.d());
        return BigDripleafBlock.p(blockState);
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        IBlockData blockState;
        BlockPosition blockPos = pos.d();
        if (BigDripleafBlock.a((LevelHeightAccessor)level, blockPos, blockState = level.a_(blockPos))) {
            EnumDirection direction = state.c(BlockFacingHorizontal.f);
            BigDripleafStemBlock.a((GeneratorAccess)level, pos, state.y(), direction);
            BigDripleafBlock.a((GeneratorAccess)level, blockPos, blockState.y(), direction);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (!level.D_() && state.c(c) == Tilt.a && BigDripleafBlock.a(pos, entity) && !level.E(pos)) {
            EntityInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                cancellable = CraftEventFactory.callPlayerInteractEvent(player, Action.PHYSICAL, pos, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos));
                level.getCraftServer().getPluginManager().callEvent((Event)cancellable);
            }
            if (cancellable.isCancelled()) {
                return;
            }
            this.setTiltAndScheduleTick(state, level, pos, Tilt.b, null, entity);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (level.E(pos)) {
            BigDripleafBlock.c(state, level, pos);
        } else {
            Tilt tilt = state.c(c);
            if (tilt == Tilt.b) {
                this.setTiltAndScheduleTick(state, level, pos, Tilt.c, SoundEffects.iN, null);
            } else if (tilt == Tilt.c) {
                this.setTiltAndScheduleTick(state, level, pos, Tilt.d, SoundEffects.iN, null);
            } else if (tilt == Tilt.d) {
                BigDripleafBlock.c(state, level, pos);
            }
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (level.E(pos)) {
            BigDripleafBlock.c(state, level, pos);
        }
    }

    private static void a(World level, BlockPosition pos, SoundEffect sound) {
        float f2 = MathHelper.b(level.z, 0.8f, 1.2f);
        level.a(null, pos, sound, SoundCategory.e, 1.0f, f2);
    }

    private static boolean a(BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        return entity.aS() && entity.dD().h > (double)((float)pos.v() + 0.6875f);
    }

    private void setTiltAndScheduleTick(IBlockData state, World level, BlockPosition pos, Tilt tilt, @Nullable SoundEffect sound, @Nullable net.minecraft.world.entity.Entity entity) {
        int _int;
        if (!BigDripleafBlock.setTilt(state, level, pos, tilt, entity)) {
            return;
        }
        if (sound != null) {
            BigDripleafBlock.a(level, pos, sound);
        }
        if ((_int = level.purpurConfig.bigDripleafTiltDelay.getOrDefault(tilt, -1).intValue()) != -1) {
            level.a(pos, (Block)this, _int);
        }
    }

    private static void c(IBlockData state, World level, BlockPosition pos) {
        BigDripleafBlock.setTilt(state, level, pos, Tilt.a, null);
        if (state.c(c) != Tilt.a) {
            BigDripleafBlock.a(level, pos, SoundEffects.iO);
        }
    }

    private static boolean setTilt(IBlockData state, World level, BlockPosition pos, Tilt tilt, @Nullable net.minecraft.world.entity.Entity entity) {
        if (entity != null && !CraftEventFactory.callEntityChangeBlockEvent(entity, pos, (IBlockData)state.b(c, tilt))) {
            return false;
        }
        Tilt tilt1 = state.c(c);
        level.a(pos, (IBlockData)state.b(c, tilt), 2);
        if (tilt.a() && tilt != tilt1) {
            level.a(null, GameEvent.c, pos);
        }
        return true;
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return D.get(state.c(c));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.R.apply(state);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        IBlockData blockState = context.q().a_(context.a().e());
        Fluid fluidState = context.q().b_(context.a());
        boolean flag = blockState.a(Blocks.uc) || blockState.a(Blocks.ud);
        return (IBlockData)((IBlockData)this.m().b(b, fluidState.a(FluidTypes.c))).b(BlockFacingHorizontal.f, flag ? blockState.c(BlockFacingHorizontal.f) : context.g().g());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, BlockFacingHorizontal.f, c);
    }
}

