/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.block.BlockBreakBlockEvent;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public class Block
extends BlockBase
implements IMaterial {
    public static final MapCodec<Block> j = Block.b(Block::new);
    private static final Logger a = LogUtils.getLogger();
    private final Holder.c<Block> b = BuiltInRegistries.e.f(this);
    public static final RegistryBlockID<IBlockData> k = new RegistryBlockID();
    private static final LoadingCache<VoxelShape, Boolean> c = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean a(VoxelShape shape) {
            return !VoxelShapes.c(VoxelShapes.b(), shape, OperatorBoolean.g);
        }
    });
    public static final int l = 1;
    public static final int m = 2;
    public static final int n = 4;
    public static final int o = 8;
    public static final int p = 16;
    public static final int q = 32;
    public static final int r = 64;
    public static final int s = 128;
    public static final int t = 256;
    public static final int u = 512;
    public static final int v = 260;
    public static final int w = 3;
    public static final int x = 11;
    public static final int y = 816;
    public static final float z = -1.0f;
    public static final float A = 0.0f;
    public static final int B = 512;
    protected final BlockStateList<Block, IBlockData> C;
    private IBlockData d;
    public float fallDamageMultiplier = 1.0f;
    public float fallDistanceMultiplier = 1.0f;
    @Nullable
    private Item e;
    private static final int f = 256;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<a>> g = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<a> map = new Object2ByteLinkedOpenHashMap<a>(256, 0.25f){

            protected void rehash(int newN) {
            }
        };
        map.defaultReturnValue((byte)127);
        return map;
    });
    @Nullable
    protected EntityLiving placer = null;

    public final boolean isDestroyable() {
        return GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits || this != Blocks.iO && this != Blocks.I && this != Blocks.gn && this != Blocks.gm && this != Blocks.lB && this != Blocks.gC && this != Blocks.lC && this != Blocks.lD && this != Blocks.pY && this != Blocks.pZ;
    }

    @Override
    protected MapCodec<? extends Block> a() {
        return j;
    }

    public static int j(@Nullable IBlockData state) {
        if (state == null) {
            return 0;
        }
        int id = k.a(state);
        return id == -1 ? 0 : id;
    }

    public static IBlockData a(int id) {
        IBlockData blockState = k.a(id);
        return blockState == null ? Blocks.a.m() : blockState;
    }

    public static Block a(@Nullable Item item) {
        return item instanceof ItemBlock ? ((ItemBlock)item).c() : Blocks.a;
    }

    public static IBlockData a(IBlockData oldState, IBlockData newState, GeneratorAccess level, BlockPosition pos) {
        VoxelShape voxelShape = VoxelShapes.b(oldState.g(level, pos), newState.g(level, pos), OperatorBoolean.c).a(pos);
        if (voxelShape.c()) {
            return newState;
        }
        for (Entity entity : level.a_(null, voxelShape.a())) {
            double d2 = VoxelShapes.a(EnumDirection.EnumAxis.b, entity.de().d(0.0, 1.0, 0.0), List.of(voxelShape), -1.0);
            entity.c(0.0, 1.0 + d2, 0.0);
        }
        return newState;
    }

    public static VoxelShape a(double x1, double y1, double z1, double x2, double y2, double z2) {
        return VoxelShapes.a(x1 / 16.0, y1 / 16.0, z1 / 16.0, x2 / 16.0, y2 / 16.0, z2 / 16.0);
    }

    public static VoxelShape[] a(int count, IntFunction<VoxelShape> boxCreator) {
        return (VoxelShape[])IntStream.rangeClosed(0, count).mapToObj(boxCreator).toArray(VoxelShape[]::new);
    }

    public static VoxelShape a(double size) {
        return Block.a(size, size, size);
    }

    public static VoxelShape a(double xSize, double ySize, double zSize) {
        double d2 = ySize / 2.0;
        return Block.a(xSize, zSize, 8.0 - d2, 8.0 + d2);
    }

    public static VoxelShape b(double size, double y1, double y2) {
        return Block.a(size, size, y1, y2);
    }

    public static VoxelShape a(double xSize, double zSize, double y1, double y2) {
        double d2 = xSize / 2.0;
        double d1 = zSize / 2.0;
        return Block.a(8.0 - d2, y1, 8.0 - d1, 8.0 + d2, y2, 8.0 + d1);
    }

    public static VoxelShape c(double size, double z1, double z2) {
        return Block.b(size, size, z1, z2);
    }

    public static VoxelShape b(double xSize, double ySize, double z1, double z2) {
        double d2 = ySize / 2.0;
        return Block.a(xSize, 8.0 - d2, 8.0 + d2, z1, z2);
    }

    public static VoxelShape a(double xSize, double y1, double y2, double z1, double z2) {
        double d2 = xSize / 2.0;
        return Block.a(8.0 - d2, y1, z1, 8.0 + d2, y2, z2);
    }

    public static IBlockData b(IBlockData currentState, GeneratorAccess level, BlockPosition pos) {
        IBlockData blockState = currentState;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (EnumDirection direction : BlockBase.E) {
            mutableBlockPos.a((BaseBlockPosition)pos, direction);
            blockState = blockState.a(level, level, pos, direction, mutableBlockPos, level.a_(mutableBlockPos), level.I_());
        }
        return blockState;
    }

    public static void a(IBlockData oldState, IBlockData newState, GeneratorAccess level, BlockPosition pos, int flags) {
        Block.a(oldState, newState, level, pos, flags, 512);
    }

    public static void a(IBlockData oldState, IBlockData newState, GeneratorAccess level, BlockPosition pos, int flags, int recursionLeft) {
        if (newState != oldState) {
            if (newState.l()) {
                if (!level.D_()) {
                    level.a(pos, (flags & 0x20) == 0, null, recursionLeft);
                }
            } else {
                level.a(pos, newState, flags & 0xFFFFFFDF, recursionLeft);
            }
        }
    }

    public Block(BlockBase.Info properties) {
        super(properties);
        String simpleName;
        BlockStateList.a<Block, IBlockData> builder = new BlockStateList.a<Block, IBlockData>(this);
        this.a(builder);
        this.C = builder.a(Block::m, IBlockData::new);
        this.l(this.C.b());
        if (SharedConstants.be && !(simpleName = this.getClass().getSimpleName()).endsWith("Block")) {
            a.error("Block classes should end with Block and {} doesn't.", (Object)simpleName);
        }
    }

    public static boolean k(IBlockData state) {
        return state.b() instanceof BlockLeaves || state.a(Blocks.iO) || state.a(Blocks.eJ) || state.a(Blocks.eK) || state.a(Blocks.fI) || state.a(Blocks.fH) || state.a(TagsBlock.ah);
    }

    protected static boolean a(WorldServer level, ResourceKey<LootTable> lootTable, IBlockData state, @Nullable TileEntity blockEntity, @Nullable net.minecraft.world.item.ItemStack tool, @Nullable Entity entity, BiConsumer<WorldServer, net.minecraft.world.item.ItemStack> dropConsumer) {
        return Block.a(level, lootTable, (LootParams.a builder) -> builder.a(LootContextParameters.i, state).b(LootContextParameters.j, blockEntity).b(LootContextParameters.b, entity).b(LootContextParameters.k, tool).a(LootContextParameterSets.u), dropConsumer);
    }

    protected static boolean a(WorldServer level, ResourceKey<LootTable> lootTable, Function<LootParams.a, LootParams> params, BiConsumer<WorldServer, net.minecraft.world.item.ItemStack> dropConsumer) {
        LootParams lootParams;
        LootTable lootTable1 = level.q().bi().a(lootTable);
        ObjectArrayList<net.minecraft.world.item.ItemStack> randomItems = lootTable1.a(lootParams = params.apply(new LootParams.a(level)));
        if (!randomItems.isEmpty()) {
            randomItems.forEach(itemStack -> dropConsumer.accept(level, (net.minecraft.world.item.ItemStack)itemStack));
            return true;
        }
        return false;
    }

    public static boolean a(IBlockData currentState, IBlockData neighborState, EnumDirection face) {
        VoxelShape faceOcclusionShape = neighborState.a(face.g());
        if (faceOcclusionShape == VoxelShapes.b()) {
            return false;
        }
        if (currentState.a(neighborState, face)) {
            return false;
        }
        if (faceOcclusionShape == VoxelShapes.a()) {
            return true;
        }
        VoxelShape faceOcclusionShape1 = currentState.a(face);
        if (faceOcclusionShape1 == VoxelShapes.a()) {
            return true;
        }
        a shapePairKey = new a(faceOcclusionShape1, faceOcclusionShape);
        Object2ByteLinkedOpenHashMap<a> map = g.get();
        byte andMoveToFirst = map.getAndMoveToFirst((Object)shapePairKey);
        if (andMoveToFirst != 127) {
            return andMoveToFirst != 0;
        }
        boolean flag = VoxelShapes.c(faceOcclusionShape1, faceOcclusionShape, OperatorBoolean.e);
        if (map.size() == 256) {
            map.removeLastByte();
        }
        map.putAndMoveToFirst((Object)shapePairKey, (byte)(flag ? 1 : 0));
        return flag;
    }

    public static boolean c(IBlockAccess level, BlockPosition pos) {
        return level.a_(pos).a(level, pos, EnumDirection.b, EnumBlockSupport.c);
    }

    public static boolean a(IWorldReader level, BlockPosition pos, EnumDirection direction) {
        IBlockData blockState = level.a_(pos);
        return (direction != EnumDirection.a || !blockState.a(TagsBlock.bk)) && blockState.a((IBlockAccess)level, pos, direction, EnumBlockSupport.b);
    }

    public static boolean a(VoxelShape shape, EnumDirection face) {
        VoxelShape faceShape = shape.a(face);
        return Block.a(faceShape);
    }

    public static boolean a(VoxelShape shape) {
        return shape.moonrise$isFullBlock();
    }

    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
    }

    public void a(GeneratorAccess level, BlockPosition pos, IBlockData state) {
    }

    public static List<net.minecraft.world.item.ItemStack> a(IBlockData state, WorldServer level, BlockPosition pos, @Nullable TileEntity blockEntity) {
        LootParams.a builder = new LootParams.a(level).a(LootContextParameters.h, Vec3D.b(pos)).a(LootContextParameters.k, net.minecraft.world.item.ItemStack.l).b(LootContextParameters.j, blockEntity);
        return state.a(builder);
    }

    public static List<net.minecraft.world.item.ItemStack> a(IBlockData state, WorldServer level, BlockPosition pos, @Nullable TileEntity blockEntity, @Nullable Entity entity, net.minecraft.world.item.ItemStack tool) {
        LootParams.a builder = new LootParams.a(level).a(LootContextParameters.h, Vec3D.b(pos)).a(LootContextParameters.k, tool).b(LootContextParameters.a, entity).b(LootContextParameters.j, blockEntity);
        return state.a(builder);
    }

    public static boolean dropResources(IBlockData state, GeneratorAccess levelAccessor, BlockPosition pos, @Nullable TileEntity blockEntity, BlockPosition source) {
        if (levelAccessor instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)levelAccessor;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (net.minecraft.world.item.ItemStack drop : Block.a(state, serverLevel, pos, blockEntity)) {
                items.add(CraftItemStack.asBukkitCopy(drop));
            }
            Block block = state.b();
            BlockBreakBlockEvent event = new BlockBreakBlockEvent((org.bukkit.block.Block)CraftBlock.at(levelAccessor, pos), (org.bukkit.block.Block)CraftBlock.at(levelAccessor, source), items);
            event.setExpToDrop(block.getExpDrop(state, serverLevel, pos, net.minecraft.world.item.ItemStack.l, true));
            event.callEvent();
            for (ItemStack drop : event.getDrops()) {
                Block.a((World)serverLevel, pos, Block.applyLoreFromTile(CraftItemStack.asNMSCopy(drop), blockEntity));
            }
            state.a(serverLevel, pos, net.minecraft.world.item.ItemStack.l, false);
            block.a(serverLevel, pos, event.getExpToDrop());
        }
        return true;
    }

    public static void b(IBlockData state, World level, BlockPosition pos) {
        if (level instanceof WorldServer) {
            Block.a(state, (WorldServer)level, pos, null).forEach(stack -> Block.a(level, pos, stack));
            state.a((WorldServer)level, pos, net.minecraft.world.item.ItemStack.l, true);
        }
    }

    public static void a(IBlockData state, GeneratorAccess level, BlockPosition pos, @Nullable TileEntity blockEntity) {
        if (level instanceof WorldServer) {
            Block.a(state, (WorldServer)level, pos, blockEntity).forEach(stack -> Block.a((World)((WorldServer)level), pos, Block.applyLoreFromTile(stack, blockEntity)));
            state.a((WorldServer)level, pos, net.minecraft.world.item.ItemStack.l, true);
        }
    }

    public static void a(IBlockData state, World level, BlockPosition pos, @Nullable TileEntity blockEntity, @Nullable Entity entity, net.minecraft.world.item.ItemStack tool) {
        Block.dropResources(state, level, pos, blockEntity, entity, tool, true);
    }

    public static void dropResources(IBlockData state, World level, BlockPosition pos, @Nullable TileEntity blockEntity, @Nullable Entity entity, net.minecraft.world.item.ItemStack tool, boolean dropExperience) {
        if (level instanceof WorldServer) {
            Block.a(state, (WorldServer)level, pos, blockEntity, entity, tool).forEach(stack -> Block.a(level, pos, Block.applyLoreFromTile(stack, blockEntity)));
            state.a((WorldServer)level, pos, tool, dropExperience);
        }
    }

    private static net.minecraft.world.item.ItemStack applyLoreFromTile(net.minecraft.world.item.ItemStack stack, @Nullable TileEntity blockEntity) {
        if (stack.h() instanceof ItemBlock && blockEntity != null && blockEntity.j() instanceof WorldServer) {
            ItemLore lore = blockEntity.getPersistentLore();
            DataComponentPatch.a builder = DataComponentPatch.a();
            if (blockEntity.j().purpurConfig.persistentTileEntityLore && lore != null) {
                builder.a(DataComponents.j, lore);
            }
            if (!blockEntity.j().purpurConfig.persistentTileEntityDisplayName) {
                builder.a(DataComponents.g);
            }
            stack.b(builder.a());
        }
        return stack;
    }

    public static void a(World level, BlockPosition pos, net.minecraft.world.item.ItemStack stack) {
        double d2 = (double)EntityTypes.au.m() / 2.0;
        double d1 = (double)pos.u() + 0.5 + MathHelper.a(level.z, -0.25, 0.25);
        double d22 = (double)pos.v() + 0.5 + MathHelper.a(level.z, -0.25, 0.25) - d2;
        double d3 = (double)pos.w() + 0.5 + MathHelper.a(level.z, -0.25, 0.25);
        Block.a(level, () -> new EntityItem(level, d1, d22, d3, stack), stack);
    }

    public static void a(World level, BlockPosition pos, EnumDirection direction, net.minecraft.world.item.ItemStack stack) {
        int stepX = direction.j();
        int stepY = direction.k();
        int stepZ = direction.l();
        double d2 = (double)EntityTypes.au.l() / 2.0;
        double d1 = (double)EntityTypes.au.m() / 2.0;
        double d22 = (double)pos.u() + 0.5 + (stepX == 0 ? MathHelper.a(level.z, -0.25, 0.25) : (double)stepX * (0.5 + d2));
        double d3 = (double)pos.v() + 0.5 + (stepY == 0 ? MathHelper.a(level.z, -0.25, 0.25) : (double)stepY * (0.5 + d1)) - d1;
        double d4 = (double)pos.w() + 0.5 + (stepZ == 0 ? MathHelper.a(level.z, -0.25, 0.25) : (double)stepZ * (0.5 + d2));
        double d5 = stepX == 0 ? MathHelper.a(level.z, -0.1, 0.1) : (double)stepX * 0.1;
        double d6 = stepY == 0 ? MathHelper.a(level.z, 0.0, 0.1) : (double)stepY * 0.1 + 0.1;
        double d7 = stepZ == 0 ? MathHelper.a(level.z, -0.1, 0.1) : (double)stepZ * 0.1;
        Block.a(level, () -> new EntityItem(level, d22, d3, d4, stack, d5, d6, d7), stack);
    }

    private static void a(World level, Supplier<EntityItem> itemEntitySupplier, net.minecraft.world.item.ItemStack stack) {
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (!stack.f() && serverLevel.S().c(GameRules.i)) {
                EntityItem itemEntity = itemEntitySupplier.get();
                itemEntity.i();
                if (level.captureDrops != null) {
                    level.captureDrops.add(itemEntity);
                } else {
                    level.b(itemEntity);
                }
            }
        }
    }

    public void a(WorldServer level, BlockPosition pos, int amount) {
        this.popExperience(level, pos, amount, null);
    }

    public void popExperience(WorldServer level, BlockPosition pos, int amount, @Nullable Entity entity) {
        if (level.S().c(GameRules.i)) {
            EntityExperienceOrb.awardWithDirection(level, Vec3D.b(pos), Vec3D.c, amount, ExperienceOrb.SpawnReason.BLOCK_BREAK, entity, null);
        }
    }

    public float e() {
        return this.G;
    }

    public void a(WorldServer level, BlockPosition pos, Explosion explosion) {
    }

    public void a(World level, BlockPosition pos, IBlockData state, Entity entity) {
    }

    @Nullable
    public IBlockData a(BlockActionContext context) {
        return this.m();
    }

    @Deprecated
    @DoNotUse
    public void a(World level, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity blockEntity, net.minecraft.world.item.ItemStack tool) {
        this.playerDestroy(level, player, pos, state, blockEntity, tool, true, true);
    }

    public void playerDestroy(World level, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity blockEntity, net.minecraft.world.item.ItemStack tool, boolean includeDrops, boolean dropExp) {
        player.b(StatisticList.a.b(this));
        player.causeFoodExhaustion(0.005f, EntityExhaustionEvent.ExhaustionReason.BLOCK_MINED);
        if (includeDrops) {
            Block.dropResources(state, level, pos, blockEntity, player, tool, dropExp);
        }
    }

    public void a(World level, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, net.minecraft.world.item.ItemStack stack) {
        this.placer = placer;
    }

    public void forgetPlacer() {
        this.placer = null;
    }

    public boolean a(IBlockData state) {
        return !state.e() && !state.n();
    }

    public IChatMutableComponent f() {
        return IChatBaseComponent.c(this.z());
    }

    public void a(World level, IBlockData state, BlockPosition pos, Entity entity, double fallDistance) {
        entity.a(fallDistance * (double)this.fallDistanceMultiplier, this.fallDamageMultiplier, entity.ei().l());
    }

    public void a(IBlockAccess level, Entity entity) {
        entity.k(entity.dI().d(1.0, 0.0, 1.0));
    }

    public float g() {
        return this.J;
    }

    public float i() {
        return this.K;
    }

    public float j() {
        return this.L;
    }

    protected void a(World level, EntityHuman player, BlockPosition pos, IBlockData state) {
        level.a((Entity)player, 2001, pos, Block.j(state));
    }

    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        this.a(level, player, pos, state);
        if (state.a(TagsBlock.bi) && level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            PiglinAI.a(serverLevel, player, false);
        }
        level.a(GameEvent.f, pos, GameEvent.a.a(player, state));
        return state;
    }

    public void a(IBlockData state, World level, BlockPosition pos, BiomeBase.Precipitation precipitation) {
    }

    public boolean a(Explosion explosion) {
        return true;
    }

    protected void a(BlockStateList.a<Block, IBlockData> builder) {
    }

    public BlockStateList<Block, IBlockData> l() {
        return this.C;
    }

    protected final void l(IBlockData state) {
        this.d = state;
    }

    public final IBlockData m() {
        return this.d;
    }

    public final IBlockData m(IBlockData state) {
        IBlockData blockState = this.m();
        for (IBlockState<?> property : state.b().l().d()) {
            if (!blockState.b(property)) continue;
            blockState = Block.a(state, blockState, property);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> IBlockData a(IBlockData sourceState, IBlockData targetState, IBlockState<T> property) {
        return (IBlockData)targetState.b(property, sourceState.c(property));
    }

    @Override
    public Item h() {
        if (this.e == null) {
            this.e = Item.a(this);
        }
        return this.e;
    }

    public boolean n() {
        return this.M;
    }

    public String toString() {
        return "Block{" + BuiltInRegistries.e.e(this).g() + "}";
    }

    @Override
    protected Block o() {
        return this;
    }

    protected Function<IBlockData, VoxelShape> a(Function<IBlockData, VoxelShape> shapeGetter) {
        return arg_0 -> ((ImmutableMap)((ImmutableMap)this.C.a().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), shapeGetter)))).get(arg_0);
    }

    protected Function<IBlockData, VoxelShape> a(Function<IBlockData, VoxelShape> shapeGetter, IBlockState<?> ... properties) {
        Map<IBlockState, Object> map = Arrays.stream(properties).collect(Collectors.toMap(property -> property, property -> property.a().getFirst()));
        ImmutableMap map1 = (ImmutableMap)this.C.a().stream().filter(state -> map.entrySet().stream().allMatch(entry -> state.c((IBlockState)entry.getKey()) == entry.getValue())).collect(ImmutableMap.toImmutableMap(Function.identity(), shapeGetter));
        return state -> {
            for (Map.Entry entry : map.entrySet()) {
                state = Block.a(state, (IBlockState)entry.getKey(), entry.getValue());
            }
            return (VoxelShape)map1.get(state);
        };
    }

    private static <S extends IBlockDataHolder<?, S>, T extends Comparable<T>> S a(S stateHolder, IBlockState<T> property, Object value) {
        return (S)((IBlockDataHolder)stateHolder.b(property, (Comparable)((Comparable)value)));
    }

    @Deprecated
    public Holder.c<Block> p() {
        return this.b;
    }

    protected int tryDropExperience(WorldServer level, BlockPosition pos, net.minecraft.world.item.ItemStack heldItem, IntProvider amount) {
        int i2 = EnchantmentManager.b(level, heldItem, amount.a(level.I_()));
        if (i2 > 0) {
            return i2;
        }
        return 0;
    }

    public int getExpDrop(IBlockData state, WorldServer level, BlockPosition pos, net.minecraft.world.item.ItemStack stack, boolean dropExperience) {
        return 0;
    }

    record a(VoxelShape a, VoxelShape b) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object other) {
            if (!(other instanceof a)) return false;
            a shapePairKey = (a)other;
            if (this.a != shapePairKey.a) return false;
            if (this.b != shapePairKey.b) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.a) * 31 + System.identityHashCode(this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "first;second", "a", "b"}, this);
        }
    }
}

