/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BlockBamboo
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockBamboo> a = BlockBamboo.b(BlockBamboo::new);
    private static final VoxelShape D = Block.b(6.0, 0.0, 16.0);
    private static final VoxelShape R = Block.b(10.0, 0.0, 16.0);
    private static final VoxelShape S = Block.b(3.0, 0.0, 16.0);
    public static final BlockStateInteger b = BlockProperties.au;
    public static final BlockStateEnum<BlockPropertyBambooSize> c = BlockProperties.bp;
    public static final BlockStateInteger d = BlockProperties.aY;
    public static final int e = 16;
    public static final int f = 0;
    public static final int g = 1;
    public static final int h = 0;
    public static final int i = 1;

    public MapCodec<BlockBamboo> a() {
        return a;
    }

    public BlockBamboo(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, 0)).b(c, BlockPropertyBambooSize.a)).b(d, 0));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }

    @Override
    protected boolean d_(IBlockData state) {
        return true;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        VoxelShape voxelShape = state.c(c) == BlockPropertyBambooSize.c ? R : D;
        return voxelShape.a(state.a(pos));
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return S.a(state.a(pos));
    }

    @Override
    protected boolean a_(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return false;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        Fluid fluidState = context.q().b_(context.a());
        if (!fluidState.c()) {
            return null;
        }
        IBlockData blockState = context.q().a_(context.a().e());
        if (blockState.a(TagsBlock.aK)) {
            if (blockState.a(Blocks.nV)) {
                return (IBlockData)this.m().b(b, 0);
            }
            if (blockState.a(Blocks.nW)) {
                int i2 = blockState.c(b) > 0 ? 1 : 0;
                return (IBlockData)this.m().b(b, i2);
            }
            IBlockData blockState1 = context.q().a_(context.a().d());
            return blockState1.a(Blocks.nW) ? (IBlockData)this.m().b(b, blockState1.c(b)) : Blocks.nV.m();
        }
        return null;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (!state.a((IWorldReader)level, pos)) {
            level.b(pos, true);
        }
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.c(d) == 0;
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        int i2;
        if (state.c(d) == 0 && random.i() < (float)level.spigotConfig.bambooModifier / 300.0f && level.w(pos.d()) && level.b(pos.d(), 0) >= 9 && (i2 = this.b(level, pos) + 1) < level.paperConfig().maxGrowthHeight.bamboo.max) {
            this.a(state, (World)level, pos, random, i2);
        }
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        return level.a_(pos.e()).a(TagsBlock.aK);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (!state.a(level, pos)) {
            scheduledTickAccess.a(pos, this, 1);
        }
        return direction == EnumDirection.b && neighborState.a(Blocks.nW) && neighborState.c(b) > state.c(b) ? (IBlockData)state.a(b) : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        int heightBelowUpToMax;
        int heightAboveUpToMax = this.a((IBlockAccess)level, pos);
        return heightAboveUpToMax + (heightBelowUpToMax = this.b(level, pos)) + 1 < ((World)level).paperConfig().maxGrowthHeight.bamboo.max && level.a_(pos.b(heightAboveUpToMax)).c(d) != 1;
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        int heightAboveUpToMax = this.a((IBlockAccess)level, pos);
        int heightBelowUpToMax = this.b(level, pos);
        int i2 = heightAboveUpToMax + heightBelowUpToMax + 1;
        int i1 = 1 + random.a(2);
        for (int i22 = 0; i22 < i1; ++i22) {
            BlockPosition blockPos = pos.b(heightAboveUpToMax);
            IBlockData blockState = level.a_(blockPos);
            if (i2 >= level.paperConfig().maxGrowthHeight.bamboo.max || !blockState.a(Blocks.nW) || blockState.c(d) == 1 || !level.w(blockPos.d())) {
                return;
            }
            this.a(blockState, (World)level, blockPos, random, i2);
            ++heightAboveUpToMax;
            ++i2;
        }
    }

    protected void a(IBlockData state, World level, BlockPosition pos, RandomSource random, int age) {
        int i1;
        IBlockData blockState = level.a_(pos.e());
        BlockPosition blockPos = pos.c(2);
        IBlockData blockState1 = level.a_(blockPos);
        BlockPropertyBambooSize bambooLeaves = BlockPropertyBambooSize.a;
        boolean shouldUpdateOthers = false;
        if (age >= 1) {
            if (!blockState.a(Blocks.nW) || blockState.c(c) == BlockPropertyBambooSize.a) {
                bambooLeaves = BlockPropertyBambooSize.b;
            } else if (blockState.a(Blocks.nW) && blockState.c(c) != BlockPropertyBambooSize.a) {
                bambooLeaves = BlockPropertyBambooSize.c;
                if (blockState1.a(Blocks.nW)) {
                    shouldUpdateOthers = true;
                }
            }
        }
        int i2 = state.c(b) != 1 && !blockState1.a(Blocks.nW) ? 0 : 1;
        int n2 = i1 = (age < level.paperConfig().maxGrowthHeight.bamboo.min || random.i() >= 0.25f) && age != level.paperConfig().maxGrowthHeight.bamboo.max - 1 ? 0 : 1;
        if (CraftEventFactory.handleBlockSpreadEvent(level, pos, pos.d(), (IBlockData)((IBlockData)((IBlockData)this.m().b(b, i2)).b(c, bambooLeaves)).b(d, i1), 3) && shouldUpdateOthers) {
            level.a(pos.e(), (IBlockData)blockState.b(c, BlockPropertyBambooSize.b), 3);
            level.a(blockPos, (IBlockData)blockState1.b(c, BlockPropertyBambooSize.a), 3);
        }
    }

    protected int a(IBlockAccess level, BlockPosition pos) {
        int i2;
        for (i2 = 0; i2 < ((World)level).paperConfig().maxGrowthHeight.bamboo.max && level.a_(pos.b(i2 + 1)).a(Blocks.nW); ++i2) {
        }
        return i2;
    }

    protected int b(IBlockAccess level, BlockPosition pos) {
        int i2;
        for (i2 = 0; i2 < ((World)level).paperConfig().maxGrowthHeight.bamboo.max && level.a_(pos.c(i2 + 1)).a(Blocks.nW); ++i2) {
        }
        return i2;
    }
}

