/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Entity;

public class BlockCactus
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockCactus> a = BlockCactus.b(BlockCactus::new);
    public static final BlockStateInteger b = BlockProperties.aA;
    public static final int c = 15;
    private static final VoxelShape d = Block.b(14.0, 0.0, 16.0);
    private static final VoxelShape e = Block.b(14.0, 0.0, 15.0);
    private static final int f = 3;
    private static final int g = 8;
    private static final double h = 0.1;
    private static final double i = 0.25;

    public MapCodec<BlockCactus> a() {
        return a;
    }

    protected BlockCactus(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.C.b().b(b, 0));
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (!state.a((IWorldReader)level, pos)) {
            level.b(pos, true);
        }
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        BlockPosition blockPos = pos.d();
        if (level.w(blockPos)) {
            int i2 = 1;
            int ageValue = state.c(b);
            while (level.a_(pos.c(i2)).a(this)) {
                if (++i2 != level.paperConfig().maxGrowthHeight.cactus || ageValue != 15) continue;
                return;
            }
            if (ageValue == 8 && this.a(this.m(), (IWorldReader)level, pos.d())) {
                double d2;
                double d3 = d2 = i2 >= level.paperConfig().maxGrowthHeight.cactus ? 0.25 : 0.1;
                if (random.j() <= d2) {
                    CraftEventFactory.handleBlockGrowEvent(level, blockPos, Blocks.et.m(), 3);
                }
            } else if (ageValue == 15 && i2 < level.paperConfig().maxGrowthHeight.cactus) {
                if (!CraftEventFactory.handleBlockGrowEvent(level, blockPos, this.m(), 3)) {
                    return;
                }
                IBlockData blockState = (IBlockData)state.b(b, 0);
                level.a(pos, blockState, 260);
                level.a(blockState, blockPos, this, null, false);
            }
            if (ageValue < 15) {
                level.a(pos, (IBlockData)state.b(b, ageValue + 1), 260);
            }
        }
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return e;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return d;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (!state.a(level, pos)) {
            scheduledTickAccess.a(pos, this, 1);
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            IBlockData blockState = level.a_(pos.a(direction));
            if ((!level.u().world.purpurConfig.cactusBreaksFromSolidNeighbors || !blockState.e()) && !level.b_(pos.a(direction)).a(TagsFluid.b)) continue;
            return false;
        }
        IBlockData blockState1 = level.a_(pos.e());
        return (blockState1.a(Blocks.es) || blockState1.a(TagsBlock.F)) && !level.a_(pos.d()).n();
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        entity.a(level.an().k().eventBlockDamager(level, pos), 1.0f);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    public boolean a(IWorldReader world, BlockPosition pos, IBlockData state) {
        if (!((World)world).purpurConfig.cactusAffectedByBonemeal || !world.w(pos.d())) {
            return false;
        }
        int cactusHeight = 0;
        while (world.a_(pos.c(cactusHeight)).a(this)) {
            ++cactusHeight;
        }
        return cactusHeight < ((World)world).paperConfig().maxGrowthHeight.cactus;
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        int cactusHeight = 0;
        while (world.a_(pos.c(cactusHeight)).a(this)) {
            ++cactusHeight;
        }
        for (int i2 = 0; i2 <= world.paperConfig().maxGrowthHeight.cactus - cactusHeight; ++i2) {
            world.c(pos.b(i2), (IBlockData)state.b(b, 0));
        }
    }
}

