/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChorusFruit;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BlockChorusFlower
extends Block {
    public static final MapCodec<BlockChorusFlower> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.e.q().fieldOf("plant").forGetter(chorusFlowerBlock -> chorusFlowerBlock.e), BlockChorusFlower.x()).apply((Applicative)instance, BlockChorusFlower::new));
    public static final int b = 5;
    public static final BlockStateInteger c = BlockProperties.ay;
    private static final VoxelShape d = Block.b(14.0, 0.0, 15.0);
    private final Block e;

    public MapCodec<BlockChorusFlower> a() {
        return a;
    }

    protected BlockChorusFlower(Block plant, BlockBase.Info properties) {
        super(properties);
        this.e = plant;
        this.l((IBlockData)this.C.b().b(c, 0));
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (!state.a((IWorldReader)level, pos)) {
            level.b(pos, true);
        }
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.c(c) < 5;
    }

    @Override
    public VoxelShape b_(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return d;
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        int ageValue;
        BlockPosition blockPos = pos.d();
        if (level.w(blockPos) && blockPos.v() <= level.ar() && (ageValue = state.c(c).intValue()) < 5) {
            int i2;
            boolean flag = false;
            boolean flag1 = false;
            IBlockData blockState = level.a_(pos.e());
            if (blockState.a(Blocks.go)) {
                flag = true;
            } else if (blockState.a(this.e)) {
                i2 = 1;
                for (int i1 = 0; i1 < 4; ++i1) {
                    IBlockData blockState1 = level.a_(pos.c(i2 + 1));
                    if (!blockState1.a(this.e)) {
                        if (!blockState1.a(Blocks.go)) break;
                        flag1 = true;
                        break;
                    }
                    ++i2;
                }
                if (i2 < 2 || i2 <= random.a(flag1 ? 5 : 4)) {
                    flag = true;
                }
            } else if (blockState.l()) {
                flag = true;
            }
            if (flag && BlockChorusFlower.b(level, blockPos, null) && level.w(pos.b(2))) {
                if (CraftEventFactory.handleBlockSpreadEvent(level, pos, blockPos, (IBlockData)this.m().b(c, ageValue), 2)) {
                    level.a(pos, BlockChorusFruit.a((IBlockAccess)level, pos, this.e.m()), 2);
                    this.a((World)level, blockPos, ageValue);
                }
            } else if (ageValue < 4) {
                i2 = random.a(4);
                if (flag1) {
                    ++i2;
                }
                boolean flag2 = false;
                for (int i22 = 0; i22 < i2; ++i22) {
                    EnumDirection randomDirection = EnumDirection.EnumDirectionLimit.a.a(random);
                    BlockPosition blockPos1 = pos.a(randomDirection);
                    if (!level.w(blockPos1) || !level.w(blockPos1.e()) || !BlockChorusFlower.b(level, blockPos1, randomDirection.g()) || !CraftEventFactory.handleBlockSpreadEvent(level, pos, blockPos1, (IBlockData)this.m().b(c, ageValue + 1), 2)) continue;
                    this.a((World)level, blockPos1, ageValue + 1);
                    flag2 = true;
                }
                if (flag2) {
                    level.a(pos, BlockChorusFruit.a((IBlockAccess)level, pos, this.e.m()), 2);
                } else if (CraftEventFactory.handleBlockGrowEvent(level, pos, (IBlockData)this.m().b(c, 5), 2)) {
                    this.a(level, pos);
                }
            } else if (CraftEventFactory.handleBlockGrowEvent(level, pos, (IBlockData)this.m().b(c, 5), 2)) {
                this.a(level, pos);
            }
        }
    }

    private void a(World level, BlockPosition pos, int age) {
        level.c(1033, pos, 0);
    }

    private void a(World level, BlockPosition pos) {
        level.c(1034, pos, 0);
    }

    private static boolean b(IWorldReader level, BlockPosition pos, @Nullable EnumDirection excludingSide) {
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            if (direction == excludingSide || level.w(pos.a(direction))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (direction != EnumDirection.b && !state.a(level, pos)) {
            scheduledTickAccess.a(pos, this, 1);
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos.e());
        if (!blockState.a(this.e) && !blockState.a(Blocks.go)) {
            if (!blockState.l()) {
                return false;
            }
            boolean flag = false;
            for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                IBlockData blockState1 = level.a_(pos.a(direction));
                if (blockState1.a(this.e)) {
                    if (flag) {
                        return false;
                    }
                    flag = true;
                    continue;
                }
                if (blockState1.l()) continue;
                return false;
            }
            return flag;
        }
        return true;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{c});
    }

    public static void a(GeneratorAccess level, BlockPosition pos, RandomSource random, int maxHorizontalDistance) {
        level.a(pos, BlockChorusFruit.a((IBlockAccess)level, pos, Blocks.lq.m()), 2);
        BlockChorusFlower.a(level, pos, random, pos, maxHorizontalDistance, 0);
    }

    private static void a(GeneratorAccess level, BlockPosition branchPos, RandomSource random, BlockPosition originalBranchPos, int maxHorizontalDistance, int iterations) {
        Block block = Blocks.lq;
        int i2 = random.a(4) + 1;
        if (iterations == 0) {
            ++i2;
        }
        for (int i1 = 0; i1 < i2; ++i1) {
            BlockPosition blockPos = branchPos.b(i1 + 1);
            if (!BlockChorusFlower.b(level, blockPos, null)) {
                return;
            }
            level.a(blockPos, BlockChorusFruit.a((IBlockAccess)level, blockPos, block.m()), 2);
            level.a(blockPos.e(), BlockChorusFruit.a((IBlockAccess)level, blockPos.e(), block.m()), 2);
        }
        boolean flag = false;
        if (iterations < 4) {
            int randomInt = random.a(4);
            if (iterations == 0) {
                ++randomInt;
            }
            for (int i22 = 0; i22 < randomInt; ++i22) {
                EnumDirection randomDirection = EnumDirection.EnumDirectionLimit.a.a(random);
                BlockPosition blockPos1 = branchPos.b(i2).a(randomDirection);
                if (Math.abs(blockPos1.u() - originalBranchPos.u()) >= maxHorizontalDistance || Math.abs(blockPos1.w() - originalBranchPos.w()) >= maxHorizontalDistance || !level.w(blockPos1) || !level.w(blockPos1.e()) || !BlockChorusFlower.b(level, blockPos1, randomDirection.g())) continue;
                flag = true;
                level.a(blockPos1, BlockChorusFruit.a((IBlockAccess)level, blockPos1, block.m()), 2);
                level.a(blockPos1.a(randomDirection.g()), BlockChorusFruit.a((IBlockAccess)level, blockPos1.a(randomDirection.g()), block.m()), 2);
                BlockChorusFlower.a(level, blockPos1, random, originalBranchPos, maxHorizontalDistance, iterations + 1);
            }
        }
        if (!flag) {
            level.a(branchPos.b(i2), (IBlockData)Blocks.lr.m().b(c, 5), 2);
        }
    }

    @Override
    protected void a(World level, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        WorldServer serverLevel;
        BlockPosition blockPos = hit.b();
        if (level instanceof WorldServer && projectile.c(serverLevel = (WorldServer)level, blockPos) && projectile.a(serverLevel)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(projectile, blockPos, state.y().g())) {
                return;
            }
            level.a(blockPos, true, projectile);
        }
    }
}

