/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BlockCocoa
extends BlockFacingHorizontal
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockCocoa> a = BlockCocoa.b(BlockCocoa::new);
    public static final int b = 2;
    public static final BlockStateInteger c = BlockProperties.av;
    private static final List<Map<EnumDirection, VoxelShape>> d = IntStream.rangeClosed(0, 2).mapToObj(i2 -> VoxelShapes.c(Block.b(4 + i2 * 2, 7 - i2 * 2, 12.0).a(0.0, 0.0, (double)(i2 - 5) / 16.0).d())).toList();

    public MapCodec<BlockCocoa> a() {
        return a;
    }

    public BlockCocoa(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)this.C.b().b(BlockFacingHorizontal.f, EnumDirection.c)).b(c, 0));
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.c(c) < 2;
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        int ageValue;
        if (level.z.i() < (float)level.spigotConfig.cocoaModifier / 500.0f && (ageValue = state.c(c).intValue()) < 2) {
            CraftEventFactory.handleBlockGrowEvent(level, pos, (IBlockData)state.b(c, ageValue + 1), 2);
        }
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos.a(state.c(BlockFacingHorizontal.f)));
        return blockState.a(TagsBlock.y);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return d.get(state.c(c)).get(state.c(BlockFacingHorizontal.f));
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        IBlockData blockState = this.m();
        World level = context.q();
        BlockPosition clickedPos = context.a();
        for (EnumDirection direction : context.f()) {
            if (!direction.o().d() || !(blockState = (IBlockData)blockState.b(BlockFacingHorizontal.f, direction)).a((IWorldReader)level, clickedPos)) continue;
            return blockState;
        }
        return null;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        return direction == state.c(BlockFacingHorizontal.f) && !state.a(level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        return state.c(c) < 2;
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        CraftEventFactory.handleBlockGrowEvent(level, pos, (IBlockData)state.b(c, state.c(c) + 1), 2);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.f, c);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }
}

