/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.block.CompostItemEvent;
import io.papermc.paper.event.entity.EntityCompostItemEvent;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventoryHolder;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftBlockInventoryHolder;
import org.bukkit.craftbukkit.v1_21_R6.util.DummyGeneratorAccess;
import org.bukkit.entity.Entity;

public class BlockComposter
extends Block
implements IInventoryHolder {
    public static final MapCodec<BlockComposter> a = BlockComposter.b(BlockComposter::new);
    public static final int b = 8;
    public static final int c = 0;
    public static final int d = 7;
    public static final BlockStateInteger e = BlockProperties.aP;
    public static final Object2FloatMap<IMaterial> f = new Object2FloatOpenHashMap();
    private static final int g = 12;
    private static final VoxelShape[] h = SystemUtils.a(() -> {
        VoxelShape[] voxelShapes = Block.a(8, (int i2) -> VoxelShapes.a(VoxelShapes.b(), Block.b(12.0, Math.clamp((long)(1 + i2 * 2), 2, 16), 16.0), OperatorBoolean.e));
        voxelShapes[8] = voxelShapes[7];
        return voxelShapes;
    });

    public MapCodec<BlockComposter> a() {
        return a;
    }

    public static void b() {
        f.defaultReturnValue(-1.0f);
        float f2 = 0.3f;
        float f1 = 0.5f;
        float f22 = 0.65f;
        float f3 = 0.85f;
        float f4 = 1.0f;
        BlockComposter.a(0.3f, Items.cD);
        BlockComposter.a(0.3f, Items.cA);
        BlockComposter.a(0.3f, Items.cB);
        BlockComposter.a(0.3f, Items.cG);
        BlockComposter.a(0.3f, Items.cH);
        BlockComposter.a(0.3f, Items.cE);
        BlockComposter.a(0.3f, Items.cF);
        BlockComposter.a(0.3f, Items.cC);
        BlockComposter.a(0.3f, Items.cJ);
        BlockComposter.a(0.3f, Items.cI);
        BlockComposter.a(0.3f, Items.X);
        BlockComposter.a(0.3f, Items.Y);
        BlockComposter.a(0.3f, Items.Z);
        BlockComposter.a(0.3f, Items.aa);
        BlockComposter.a(0.3f, Items.ab);
        BlockComposter.a(0.3f, Items.ac);
        BlockComposter.a(0.3f, Items.ad);
        BlockComposter.a(0.3f, Items.ae);
        BlockComposter.a(0.3f, Items.af);
        BlockComposter.a(0.3f, Items.xv);
        BlockComposter.a(0.3f, Items.ub);
        BlockComposter.a(0.3f, Items.cU);
        BlockComposter.a(0.3f, Items.dX);
        BlockComposter.a(0.3f, Items.ud);
        BlockComposter.a(0.3f, Items.uc);
        BlockComposter.a(0.3f, Items.dd);
        BlockComposter.a(0.3f, Items.yJ);
        BlockComposter.a(0.3f, Items.yK);
        BlockComposter.a(0.3f, Items.rb);
        BlockComposter.a(0.3f, Items.eb);
        BlockComposter.a(0.3f, Items.ed);
        BlockComposter.a(0.3f, Items.ee);
        BlockComposter.a(0.3f, Items.dY);
        BlockComposter.a(0.3f, Items.dZ);
        BlockComposter.a(0.3f, Items.ea);
        BlockComposter.a(0.3f, Items.ei);
        BlockComposter.a(0.3f, Items.eg);
        BlockComposter.a(0.3f, Items.bN);
        BlockComposter.a(0.3f, Items.xs);
        BlockComposter.a(0.3f, Items.xt);
        BlockComposter.a(0.3f, Items.da);
        BlockComposter.a(0.3f, Items.cW);
        BlockComposter.a(0.3f, Items.fD);
        BlockComposter.a(0.3f, Items.db);
        BlockComposter.a(0.3f, Items.dc);
        BlockComposter.a(0.5f, Items.sz);
        BlockComposter.a(0.5f, Items.iU);
        BlockComposter.a(0.5f, Items.cK);
        BlockComposter.a(0.5f, Items.fC);
        BlockComposter.a(0.5f, Items.dW);
        BlockComposter.a(0.5f, Items.gG);
        BlockComposter.a(0.5f, Items.dT);
        BlockComposter.a(0.5f, Items.dU);
        BlockComposter.a(0.5f, Items.dV);
        BlockComposter.a(0.5f, Items.ua);
        BlockComposter.a(0.5f, Items.gH);
        BlockComposter.a(0.65f, Items.de);
        BlockComposter.a(0.65f, Items.gT);
        BlockComposter.a(0.65f, Items.fS);
        BlockComposter.a(0.65f, Items.fT);
        BlockComposter.a(0.65f, Items.gF);
        BlockComposter.a(0.65f, Items.pV);
        BlockComposter.a(0.65f, Items.xu);
        BlockComposter.a(0.65f, Items.wn);
        BlockComposter.a(0.65f, Items.tl);
        BlockComposter.a(0.65f, Items.wo);
        BlockComposter.a(0.65f, Items.rc);
        BlockComposter.a(0.65f, Items.dN);
        BlockComposter.a(0.65f, Items.dO);
        BlockComposter.a(0.65f, Items.gz);
        BlockComposter.a(0.65f, Items.dP);
        BlockComposter.a(0.65f, Items.dQ);
        BlockComposter.a(0.65f, Items.un);
        BlockComposter.a(0.65f, Items.dR);
        BlockComposter.a(0.65f, Items.dS);
        BlockComposter.a(0.65f, Items.yN);
        BlockComposter.a(0.65f, Items.dv);
        BlockComposter.a(0.65f, Items.dy);
        BlockComposter.a(0.65f, Items.dz);
        BlockComposter.a(0.65f, Items.dA);
        BlockComposter.a(0.65f, Items.dB);
        BlockComposter.a(0.65f, Items.dC);
        BlockComposter.a(0.65f, Items.dD);
        BlockComposter.a(0.65f, Items.dE);
        BlockComposter.a(0.65f, Items.dF);
        BlockComposter.a(0.65f, Items.dG);
        BlockComposter.a(0.65f, Items.dH);
        BlockComposter.a(0.65f, Items.dI);
        BlockComposter.a(0.65f, Items.dJ);
        BlockComposter.a(0.65f, Items.dw);
        BlockComposter.a(0.65f, Items.dx);
        BlockComposter.a(0.65f, Items.cV);
        BlockComposter.a(0.65f, Items.iQ);
        BlockComposter.a(0.65f, Items.iR);
        BlockComposter.a(0.65f, Items.iS);
        BlockComposter.a(0.65f, Items.iT);
        BlockComposter.a(0.65f, Items.iV);
        BlockComposter.a(0.65f, Items.dM);
        BlockComposter.a(0.65f, Items.cX);
        BlockComposter.a(0.65f, Items.ec);
        BlockComposter.a(0.65f, Items.ef);
        BlockComposter.a(0.65f, Items.eh);
        BlockComposter.a(0.85f, Items.iw);
        BlockComposter.a(0.85f, Items.gx);
        BlockComposter.a(0.85f, Items.gy);
        BlockComposter.a(0.85f, Items.jQ);
        BlockComposter.a(0.85f, Items.jR);
        BlockComposter.a(0.85f, Items.cY);
        BlockComposter.a(0.85f, Items.rd);
        BlockComposter.a(0.85f, Items.wp);
        BlockComposter.a(0.85f, Items.tW);
        BlockComposter.a(0.85f, Items.dK);
        BlockComposter.a(0.85f, Items.dL);
        BlockComposter.a(1.0f, Items.tF);
        BlockComposter.a(1.0f, Items.wB);
    }

    private static void a(float chance, IMaterial item) {
        f.put((Object)item.h(), chance);
    }

    public BlockComposter(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.C.b().b(e, 0));
    }

    public static void a(World level, BlockPosition pos, boolean success) {
        IBlockData blockState = level.a_(pos);
        level.a(pos, success ? SoundEffects.fz : SoundEffects.fy, SoundCategory.e, 1.0f, 1.0f, false);
        double d2 = blockState.f(level, pos).b(EnumDirection.EnumAxis.b, 0.5, 0.5) + 0.03125;
        double d1 = 2.0;
        double d22 = 0.1875;
        double d3 = 0.625;
        RandomSource random = level.I_();
        for (int i2 = 0; i2 < 10; ++i2) {
            double d4 = random.k() * 0.02;
            double d5 = random.k() * 0.02;
            double d6 = random.k() * 0.02;
            level.a(Particles.S, (double)pos.u() + 0.1875 + 0.625 * (double)random.i(), (double)pos.v() + d2 + (double)random.i() * (1.0 - d2), (double)pos.w() + 0.1875 + 0.625 * (double)random.i(), d4, d5, d6);
        }
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return h[state.c(e)];
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return VoxelShapes.b();
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return h[0];
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        if (state.c(e) == 7) {
            level.a(pos, state.b(), 20);
        }
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        int levelValue = state.c(e);
        if (levelValue < 8 && f.containsKey((Object)stack.h())) {
            IBlockData newState = BlockComposter.process(levelValue, player, state, level, pos, stack);
            if (newState == null) {
                return EnumInteractionResult.e;
            }
            if (level.purpurConfig.composterBulkProcess && player.cp() && newState != state) {
                IBlockData oldState;
                int oldLevel;
                int newLevel;
                int oldCount;
                int newCount;
                do {
                    oldState = newState;
                    oldCount = stack.M();
                    oldLevel = oldState.c(e);
                    newState = BlockComposter.process(oldLevel, player, oldState, level, pos, stack);
                    if (newState == null) {
                        return EnumInteractionResult.e;
                    }
                    newCount = stack.M();
                    newLevel = newState.c(e);
                } while (newCount > 0 && (newCount != oldCount || newLevel != oldLevel || newState != oldState));
            }
            return EnumInteractionResult.a;
        }
        return super.a(stack, state, level, pos, player, hand, hitResult);
    }

    @Nullable
    private static IBlockData process(int levelValue, EntityHuman player, IBlockData state, World level, BlockPosition pos, ItemStack stack) {
        if (levelValue < 7 && !level.D_()) {
            IBlockData blockState = BlockComposter.a((net.minecraft.world.entity.Entity)player, state, (GeneratorAccess)level, pos, stack);
            if (blockState == null) {
                return null;
            }
            level.c(1500, pos, state != blockState ? 1 : 0);
            player.b(StatisticList.c.b(stack.h()));
            stack.a(1, (EntityLiving)player);
            return blockState;
        }
        return state;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        int levelValue = state.c(e);
        if (levelValue == 8) {
            BlockComposter.a((net.minecraft.world.entity.Entity)player, state, level, pos);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    public static IBlockData a(net.minecraft.world.entity.Entity entity, IBlockData state, WorldServer level, ItemStack stack, BlockPosition pos) {
        int levelValue = state.c(e);
        if (levelValue < 7 && f.containsKey((Object)stack.h())) {
            double rand = level.I_().j();
            IBlockData blockState = null;
            blockState = BlockComposter.addItem(entity, state, level, pos, stack, rand);
            if (blockState == null) {
                return state;
            }
            stack.h(1);
            return blockState;
        }
        return state;
    }

    public static IBlockData a(net.minecraft.world.entity.Entity entity, IBlockData state, World level, BlockPosition pos) {
        IBlockData emptyState;
        if (entity != null && !(entity instanceof EntityHuman) && !CraftEventFactory.callEntityChangeBlockEvent(entity, pos, emptyState = BlockComposter.a(entity, state, (GeneratorAccess)DummyGeneratorAccess.INSTANCE, pos))) {
            return state;
        }
        if (!level.D_()) {
            Vec3D vec3 = Vec3D.a(pos, 0.5, 1.01, 0.5).a(level.z, 0.7f);
            EntityItem itemEntity = new EntityItem(level, vec3.a(), vec3.b(), vec3.c(), new ItemStack(Items.tC));
            itemEntity.i();
            level.b(itemEntity);
        }
        IBlockData blockState = BlockComposter.a(entity, state, (GeneratorAccess)level, pos);
        level.a(null, pos, SoundEffects.fx, SoundCategory.e, 1.0f, 1.0f);
        return blockState;
    }

    static IBlockData a(@Nullable net.minecraft.world.entity.Entity entity, IBlockData state, GeneratorAccess level, BlockPosition pos) {
        IBlockData blockState = (IBlockData)state.b(e, 0);
        level.a(pos, blockState, 3);
        level.a(GameEvent.c, pos, GameEvent.a.a(entity, blockState));
        return blockState;
    }

    @Nullable
    static IBlockData a(@Nullable net.minecraft.world.entity.Entity entity, IBlockData state, GeneratorAccess level, BlockPosition pos, ItemStack stack) {
        return BlockComposter.addItem(entity, state, level, pos, stack, level.I_().j());
    }

    @Nullable
    static IBlockData addItem(@Nullable net.minecraft.world.entity.Entity entity, IBlockData state, GeneratorAccess level, BlockPosition pos, ItemStack stack, double rand) {
        int levelValue = state.c(e);
        float _float = f.getFloat((Object)stack.h());
        boolean willRaiseLevel = levelValue == 0 && !(_float <= 0.0f) || !(rand >= (double)_float);
        Object event = entity == null ? new CompostItemEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), stack.getBukkitStack(), willRaiseLevel) : new EntityCompostItemEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos), stack.getBukkitStack(), willRaiseLevel);
        if (!event.callEvent()) {
            return null;
        }
        willRaiseLevel = event.willRaiseLevel();
        if (!willRaiseLevel) {
            return state;
        }
        int i2 = levelValue + 1;
        IBlockData blockState = (IBlockData)state.b(e, i2);
        if (entity != null && !CraftEventFactory.callEntityChangeBlockEvent(entity, pos, blockState)) {
            return null;
        }
        level.a(pos, blockState, 3);
        level.a(GameEvent.c, pos, GameEvent.a.a(entity, blockState));
        if (i2 == 7) {
            level.a(pos, state.b(), 20);
        }
        return blockState;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (state.c(e) == 7) {
            level.a(pos, (IBlockData)state.a(e), 3);
            level.a(null, pos, SoundEffects.fA, SoundCategory.e, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        return state.c(e);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{e});
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    public IWorldInventory a(IBlockData state, GeneratorAccess level, BlockPosition pos) {
        int levelValue = state.c(e);
        if (levelValue == 8) {
            return new ContainerOutput(state, level, pos, new ItemStack(Items.tC));
        }
        return (IWorldInventory)((Object)(levelValue < 7 ? new ContainerInput(state, level, pos) : new ContainerEmpty(level, pos)));
    }

    public static class ContainerOutput
    extends InventorySubcontainer
    implements IWorldInventory {
        private final IBlockData b;
        private final GeneratorAccess c;
        private final BlockPosition d;
        private boolean e;

        public ContainerOutput(IBlockData state, GeneratorAccess level, BlockPosition pos, ItemStack stack) {
            super(stack);
            this.bukkitOwner = new CraftBlockInventoryHolder(level, pos, this);
            this.b = state;
            this.c = level;
            this.d = pos;
        }

        @Override
        public int ap_() {
            return 1;
        }

        @Override
        public int[] a(EnumDirection side) {
            int[] nArray;
            if (side == EnumDirection.a) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        @Override
        public boolean a(int index, ItemStack stack, @Nullable EnumDirection direction) {
            return false;
        }

        @Override
        public boolean b(int index, ItemStack stack, EnumDirection direction) {
            return !this.e && direction == EnumDirection.a && stack.a(Items.tC);
        }

        @Override
        public void e() {
            if (this.c()) {
                BlockComposter.a(null, this.b, this.c, this.d);
                this.e = true;
            } else {
                this.c.a(this.d, this.b, 3);
                this.e = false;
            }
        }
    }

    public static class ContainerInput
    extends InventorySubcontainer
    implements IWorldInventory {
        private final IBlockData b;
        private final GeneratorAccess c;
        private final BlockPosition d;
        private boolean e;

        public ContainerInput(IBlockData state, GeneratorAccess level, BlockPosition pos) {
            super(1);
            this.bukkitOwner = new CraftBlockInventoryHolder(level, pos, this);
            this.b = state;
            this.c = level;
            this.d = pos;
        }

        @Override
        public int ap_() {
            return 1;
        }

        @Override
        public int[] a(EnumDirection side) {
            int[] nArray;
            if (side == EnumDirection.b) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        @Override
        public boolean a(int index, ItemStack stack, @Nullable EnumDirection direction) {
            return !this.e && direction == EnumDirection.b && f.containsKey((Object)stack.h());
        }

        @Override
        public boolean b(int index, ItemStack stack, EnumDirection direction) {
            return false;
        }

        @Override
        public void e() {
            ItemStack item = this.a(0);
            if (!item.f()) {
                this.e = true;
                IBlockData blockState = BlockComposter.a(null, this.b, this.c, this.d, item);
                if (blockState == null) {
                    return;
                }
                this.c.c(1500, this.d, blockState != this.b ? 1 : 0);
                this.b(0);
            }
        }
    }

    public static class ContainerEmpty
    extends InventorySubcontainer
    implements IWorldInventory {
        public ContainerEmpty(GeneratorAccess levelAccessor, BlockPosition blockPos) {
            super(0);
            this.bukkitOwner = new CraftBlockInventoryHolder(levelAccessor, blockPos, this);
        }

        @Override
        public int[] a(EnumDirection side) {
            return new int[0];
        }

        @Override
        public boolean a(int index, ItemStack stack, @Nullable EnumDirection direction) {
            return false;
        }

        @Override
        public boolean b(int index, ItemStack stack, EnumDirection direction) {
            return false;
        }
    }
}

