/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public abstract class BlockCoralBase
extends Block
implements IBlockWaterlogged {
    public static final BlockStateBoolean b = BlockProperties.I;
    private static final VoxelShape a = Block.b(12.0, 0.0, 4.0);

    protected BlockCoralBase(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.C.b().b(b, true));
    }

    protected abstract MapCodec<? extends BlockCoralBase> a();

    protected void a(IBlockData state, IBlockAccess level, ScheduledTickAccess scheduledTickAccess, RandomSource random, BlockPosition pos) {
        if (!BlockCoralBase.d(state, level, pos)) {
            scheduledTickAccess.a(pos, this, 60 + random.a(40));
        }
    }

    protected static boolean d(IBlockData state, IBlockAccess level, BlockPosition pos) {
        if (!((GeneratorAccess)level).getMinecraftWorld().purpurConfig.coralDieOutsideWater) {
            return true;
        }
        if (state.c(b).booleanValue()) {
            return true;
        }
        for (EnumDirection direction : EnumDirection.values()) {
            if (!level.b_(pos.a(direction)).a(TagsFluid.a)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        Fluid fluidState = context.q().b_(context.a());
        return (IBlockData)this.m().b(b, fluidState.a(TagsFluid.a) && fluidState.e() == 8);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return a;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(b).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return direction == EnumDirection.a && !this.a(state, level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        return level.a_(blockPos).c((IBlockAccess)level, blockPos, EnumDirection.b);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(b) != false ? FluidTypes.c.a(false) : super.b_(state);
    }
}

