/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLightDetector;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BlockDaylightDetector
extends BlockTileEntity {
    public static final MapCodec<BlockDaylightDetector> a = BlockDaylightDetector.b(BlockDaylightDetector::new);
    public static final BlockStateInteger b = BlockProperties.aX;
    public static final BlockStateBoolean c = BlockProperties.s;
    private static final VoxelShape d = Block.b(16.0, 0.0, 6.0);

    public MapCodec<BlockDaylightDetector> a() {
        return a;
    }

    public BlockDaylightDetector(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)this.C.b().b(b, 0)).b(c, false));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return d;
    }

    @Override
    protected boolean g_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection side) {
        return state.c(b);
    }

    private static void c(IBlockData state, World level, BlockPosition pos) {
        int i2 = level.a(EnumSkyBlock.a, pos) - level.G_();
        float sunAngle = level.a(1.0f);
        boolean invertedValue = state.c(c);
        if (invertedValue) {
            i2 = 15 - i2;
        } else if (i2 > 0) {
            float f2 = sunAngle < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            sunAngle += (f2 - sunAngle) * 0.2f;
            i2 = Math.round((float)i2 * MathHelper.b(sunAngle));
        }
        i2 = MathHelper.a(i2, 0, 15);
        if (state.c(b) != i2) {
            i2 = CraftEventFactory.callRedstoneChange(level, pos, state.c(b), i2).getNewCurrent();
            level.a(pos, (IBlockData)state.b(b, i2), 3);
        }
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (!player.gO()) {
            return super.a(state, level, pos, player, hitResult);
        }
        if (!level.D_()) {
            IBlockData blockState = (IBlockData)state.a(c);
            level.a(pos, blockState, 2);
            level.a(GameEvent.c, pos, GameEvent.a.a(player, blockState));
            BlockDaylightDetector.c(blockState, level, pos);
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected boolean e_(IBlockData state) {
        return true;
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityLightDetector(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return !level.D_() && level.H_().g() ? BlockDaylightDetector.a(blockEntityType, TileEntityTypes.r, BlockDaylightDetector::a) : null;
    }

    private static void a(World level, BlockPosition pos, IBlockData state, TileEntityLightDetector blockEntity) {
        if (level.ag() % 20L == 0L) {
            BlockDaylightDetector.c(state, level, pos);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }
}

