/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public class BlockDropper
extends BlockDispenser {
    private static final Logger f = LogUtils.getLogger();
    public static final MapCodec<BlockDropper> e = BlockDropper.b(BlockDropper::new);
    private static final IDispenseBehavior g = new DispenseBehaviorItem();

    public MapCodec<BlockDropper> a() {
        return e;
    }

    public BlockDropper(BlockBase.Info properties) {
        super(properties);
    }

    @Override
    protected IDispenseBehavior a(World level, net.minecraft.world.item.ItemStack item) {
        return g;
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityDropper(pos, state);
    }

    @Override
    public void a(WorldServer level, IBlockData state, BlockPosition pos) {
        TileEntityDispenser dispenserBlockEntity = level.a(pos, TileEntityTypes.g).orElse(null);
        if (dispenserBlockEntity == null) {
            f.warn("Ignoring dispensing attempt for Dropper without matching block entity at {}", (Object)pos);
        } else {
            SourceBlock blockSource = new SourceBlock(level, pos, state, dispenserBlockEntity);
            int randomSlot = dispenserBlockEntity.a(level.z);
            if (randomSlot < 0) {
                if (CraftEventFactory.handleBlockFailedDispenseEvent(level, pos)) {
                    level.c(1001, pos, 0);
                }
            } else {
                net.minecraft.world.item.ItemStack item = dispenserBlockEntity.a(randomSlot);
                if (!item.f()) {
                    net.minecraft.world.item.ItemStack itemStack;
                    EnumDirection direction = level.a_(pos).c(BlockDispenser.b);
                    IInventory containerAt = TileEntityHopper.a((World)level, pos.a(direction));
                    if (containerAt == null) {
                        if (!CraftEventFactory.handleBlockPreDispenseEvent(level, pos, item, randomSlot)) {
                            return;
                        }
                        itemStack = g.dispense(blockSource, item);
                    } else {
                        Inventory destinationInventory;
                        CraftItemStack oitemstack = CraftItemStack.asCraftMirror(item.c(1));
                        if (containerAt instanceof InventoryLargeChest) {
                            InventoryLargeChest compoundContainer = (InventoryLargeChest)containerAt;
                            destinationInventory = new CraftInventoryDoubleChest(compoundContainer);
                        } else {
                            destinationInventory = containerAt.getOwner().getInventory();
                        }
                        InventoryMoveItemEvent event = new InventoryMoveItemEvent(dispenserBlockEntity.getOwner().getInventory(), (ItemStack)oitemstack, destinationInventory, true);
                        level.getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return;
                        }
                        itemStack = TileEntityHopper.a((IInventory)dispenserBlockEntity, containerAt, CraftItemStack.asNMSCopy(event.getItem()), direction.g());
                        if (event.getItem().equals((Object)oitemstack) && itemStack.f()) {
                            itemStack = item.v();
                            itemStack.h(1);
                        } else {
                            itemStack = item.v();
                        }
                    }
                    dispenserBlockEntity.a(randomSlot, itemStack);
                }
            }
        }
    }
}

