/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingAbstract;
import net.minecraft.world.level.block.BlockGrowingTop;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BlockGrowingStem
extends BlockGrowingAbstract
implements IBlockFragilePlantElement {
    protected BlockGrowingStem(BlockBase.Info properties, EnumDirection growthDirection, VoxelShape shape, boolean scheduleFluidTicks) {
        super(properties, growthDirection, shape, scheduleFluidTicks);
    }

    protected abstract MapCodec<? extends BlockGrowingStem> a();

    protected IBlockData a(IBlockData head, IBlockData body) {
        return body;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (direction == this.a.g() && !state.a(level, pos)) {
            scheduledTickAccess.a(pos, this, 1);
        }
        BlockGrowingTop headBlock = this.c();
        if (direction == this.a && !neighborState.a(this) && !neighborState.a(headBlock)) {
            return this.a(state, headBlock.b(random));
        }
        if (this.b) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        return new ItemStack(this.c());
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        Optional<BlockPosition> headPos = this.a((IBlockAccess)level, pos, state.b());
        return headPos.isPresent() && this.c().h(level.a_(headPos.get().a(this.a)));
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        Optional<BlockPosition> headPos = this.a((IBlockAccess)level, pos, state.b());
        if (headPos.isPresent()) {
            IBlockData blockState = level.a_(headPos.get());
            ((BlockGrowingTop)blockState.b()).a(level, random, headPos.get(), blockState);
        }
    }

    private Optional<BlockPosition> a(IBlockAccess level, BlockPosition pos, Block block) {
        return BlockUtil.a(level, pos, block, this.a, this.c());
    }

    @Override
    protected boolean a(IBlockData state, BlockActionContext useContext) {
        boolean flag = super.a(state, useContext);
        return (!flag || !useContext.n().a(this.c().h())) && flag;
    }

    @Override
    protected Block b() {
        return this;
    }
}

