/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public abstract class BlockGrowingTop
extends BlockGrowingAbstract
implements IBlockFragilePlantElement {
    public static final BlockStateInteger e = BlockProperties.aB;
    public static final int f = 25;
    private final double c;

    protected BlockGrowingTop(BlockBase.Info properties, EnumDirection growthDirection, VoxelShape shape, boolean scheduleFluidTicks, double growPerTickProbability) {
        super(properties, growthDirection, shape, scheduleFluidTicks);
        this.c = growPerTickProbability;
        this.l((IBlockData)this.C.b().b(e, 0));
    }

    protected abstract MapCodec<? extends BlockGrowingTop> a();

    @Override
    public IBlockData b(RandomSource random) {
        return (IBlockData)this.m().b(e, this.getMaxGrowthAge() == 0 ? 0 : random.a(this.getMaxGrowthAge()));
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.c(e) < this.getMaxGrowthAge();
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        BlockPosition blockPos;
        int modifier = 100;
        if (this == Blocks.mY) {
            modifier = level.spigotConfig.kelpModifier;
        } else if (this == Blocks.pz) {
            modifier = level.spigotConfig.twistingVinesModifier;
        } else if (this == Blocks.px) {
            modifier = level.spigotConfig.weepingVinesModifier;
        } else if (this == Blocks.tS) {
            modifier = level.spigotConfig.caveVinesModifier;
        }
        if (state.c(e) < this.getMaxGrowthAge() && random.j() < (double)modifier / 100.0 * this.c && this.h(level.a_(blockPos = pos.a(this.a)))) {
            CraftEventFactory.handleBlockSpreadEvent(level, pos, blockPos, this.getGrowIntoState(state, level.z, level), 3);
        }
    }

    protected IBlockData getGrowIntoState(IBlockData state, RandomSource random, @Nullable World level) {
        return this.a(state, random);
    }

    protected IBlockData a(IBlockData state, RandomSource random) {
        return (IBlockData)state.a(e);
    }

    public IBlockData q(IBlockData state) {
        return (IBlockData)state.b(e, this.getMaxGrowthAge());
    }

    public boolean r(IBlockData state) {
        return state.c(e) >= this.getMaxGrowthAge();
    }

    protected IBlockData a(IBlockData head, IBlockData body) {
        return body;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (direction == this.a.g()) {
            if (!state.a(level, pos)) {
                scheduledTickAccess.a(pos, this, 1);
            } else {
                IBlockData blockState = level.a_(pos.a(this.a));
                if (blockState.a(this) || blockState.a(this.b())) {
                    return this.a(state, this.b().m());
                }
            }
        }
        if (direction != this.a || !neighborState.a(this) && !neighborState.a(this.b())) {
            if (this.b) {
                scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
            }
            return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        }
        return this.a(state, this.b().m());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{e});
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        return this.h(level.a_(pos.a(this.a)));
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        BlockPosition blockPos = pos.a(this.a);
        int min = Math.min(state.c(e) + 1, this.getMaxGrowthAge());
        int blocksToGrowWhenBonemealed = this.a(random);
        for (int i2 = 0; i2 < blocksToGrowWhenBonemealed && this.h(level.a_(blockPos)); ++i2) {
            level.c(blockPos, (IBlockData)state.b(e, min));
            blockPos = blockPos.a(this.a);
            min = Math.min(min + 1, this.getMaxGrowthAge());
        }
    }

    protected abstract int a(RandomSource var1);

    protected abstract boolean h(IBlockData var1);

    @Override
    protected BlockGrowingTop c() {
        return this;
    }

    public abstract int getMaxGrowthAge();
}

