/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.MinecartTrackLogic;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockMinecartDetector
extends BlockMinecartTrackAbstract {
    public static final MapCodec<BlockMinecartDetector> b = BlockMinecartDetector.b(BlockMinecartDetector::new);
    public static final BlockStateEnum<BlockPropertyTrackPosition> c = BlockProperties.al;
    public static final BlockStateBoolean d = BlockProperties.A;
    private static final int e = 20;

    public MapCodec<BlockMinecartDetector> a() {
        return b;
    }

    public BlockMinecartDetector(BlockBase.Info properties) {
        super(true, properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(d, false)).b(c, BlockPropertyTrackPosition.a)).b(BlockMinecartTrackAbstract.a, false));
    }

    @Override
    protected boolean e_(IBlockData state) {
        return true;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (!level.D_() && !state.c(d).booleanValue()) {
            this.a(level, pos, state);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (state.c(d).booleanValue()) {
            this.a((World)level, pos, state);
        }
    }

    @Override
    protected int a(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection side) {
        return state.c(d) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection side) {
        if (!state.c(d).booleanValue()) {
            return 0;
        }
        return side == EnumDirection.b ? 15 : 0;
    }

    private void a(World level, BlockPosition pos, IBlockData state) {
        if (this.a(state, (IWorldReader)level, pos)) {
            IBlockData blockState;
            if (!state.a(this)) {
                return;
            }
            boolean poweredValue = state.c(d);
            boolean flag = false;
            List<EntityMinecartAbstract> interactingMinecartOfType = this.a(level, pos, EntityMinecartAbstract.class, (net.minecraft.world.entity.Entity entity) -> true);
            if (!interactingMinecartOfType.isEmpty()) {
                flag = true;
            }
            if (poweredValue != flag) {
                CraftBlock block = CraftBlock.at(level, pos);
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)block, flag ? 15 : 0, flag ? 15 : 0);
                level.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                boolean bl = flag = eventRedstone.getNewCurrent() > 0;
            }
            if (flag && !poweredValue) {
                blockState = (IBlockData)state.b(d, true);
                level.a(pos, blockState, 3);
                this.b(level, pos, blockState, true);
                level.a(pos, this);
                level.a(pos.e(), this);
                level.b(pos, state, blockState);
            }
            if (!flag && poweredValue) {
                blockState = (IBlockData)state.b(d, false);
                level.a(pos, blockState, 3);
                this.b(level, pos, blockState, false);
                level.a(pos, this);
                level.a(pos.e(), this);
                level.b(pos, state, blockState);
            }
            if (flag) {
                level.a(pos, (Block)this, 20);
            }
            level.b(pos, this);
        }
    }

    protected void b(World level, BlockPosition pos, IBlockData state, boolean powered) {
        MinecartTrackLogic railState = new MinecartTrackLogic(level, pos, state);
        for (BlockPosition blockPos : railState.a()) {
            IBlockData blockState = level.a_(blockPos);
            level.a(blockState, blockPos, blockState.b(), null, false);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        if (!oldState.a(state.b())) {
            IBlockData blockState = this.a(state, level, pos, movedByPiston);
            this.a(level, pos, blockState);
        }
    }

    @Override
    public IBlockState<BlockPropertyTrackPosition> c() {
        return c;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        if (state.c(d).booleanValue()) {
            List<EntityMinecartCommandBlock> interactingMinecartOfType = this.a(level, pos, EntityMinecartCommandBlock.class, (net.minecraft.world.entity.Entity cartEntity) -> true);
            if (!interactingMinecartOfType.isEmpty()) {
                return interactingMinecartOfType.get(0).e().f();
            }
            List<EntityMinecartAbstract> interactingMinecartOfType1 = this.a(level, pos, EntityMinecartAbstract.class, IEntitySelector.d);
            if (!interactingMinecartOfType1.isEmpty()) {
                return Container.b((IInventory)((Object)interactingMinecartOfType1.get(0)));
            }
        }
        return 0;
    }

    private <T extends EntityMinecartAbstract> List<T> a(World level, BlockPosition pos, Class<T> cartType, Predicate<net.minecraft.world.entity.Entity> filter) {
        return level.a(cartType, this.a(pos), filter);
    }

    private AxisAlignedBB a(BlockPosition pos) {
        double d2 = 0.2;
        return new AxisAlignedBB((double)pos.u() + 0.2, pos.v(), (double)pos.w() + 0.2, (double)(pos.u() + 1) - 0.2, (double)(pos.v() + 1) - 0.2, (double)(pos.w() + 1) - 0.2);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        BlockPropertyTrackPosition railShape = state.c(c);
        BlockPropertyTrackPosition railShape1 = this.a(railShape, rotation);
        return (IBlockData)state.b(c, railShape1);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        BlockPropertyTrackPosition railShape = state.c(c);
        BlockPropertyTrackPosition railShape1 = this.a(railShape, mirror);
        return (IBlockData)state.b(c, railShape1);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, d, BlockMinecartTrackAbstract.a);
    }
}

