/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.slf4j.Logger;

public class BlockMobSpawner
extends BlockTileEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<BlockMobSpawner> a = BlockMobSpawner.b(BlockMobSpawner::new);

    public MapCodec<BlockMobSpawner> a() {
        return a;
    }

    protected BlockMobSpawner(BlockBase.Info properties) {
        super(properties);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityMobSpawner(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return BlockMobSpawner.a(blockEntityType, TileEntityTypes.j, level.D_() ? TileEntityMobSpawner::a : TileEntityMobSpawner::b);
    }

    @Override
    public void playerDestroy(World level, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity blockEntity, ItemStack stack, boolean includeDrops, boolean dropExp) {
        if (level.purpurConfig.silkTouchEnabled && player.getBukkitEntity().hasPermission("purpur.drop.spawners") && this.isSilkTouch(level, stack)) {
            MobSpawnerData mobSpawnerData;
            ItemStack item = new ItemStack(Blocks.cP.h());
            if (blockEntity instanceof TileEntityMobSpawner) {
                TileEntityMobSpawner spawnerBlock = (TileEntityMobSpawner)blockEntity;
                mobSpawnerData = spawnerBlock.c().m;
            } else {
                mobSpawnerData = null;
            }
            MobSpawnerData nextSpawnData = mobSpawnerData;
            Optional<Object> type = Optional.empty();
            if (nextSpawnData != null) {
                try (ProblemReporter.j scopedCollector = new ProblemReporter.j(blockEntity.v(), LOGGER);){
                    ValueInput valueInput = TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)player.an().L_(), nextSpawnData.d());
                    type = EntityTypes.a(valueInput);
                }
                NBTTagCompound spawnDataTag = new NBTTagCompound();
                spawnDataTag.b("SpawnData", MobSpawnerData.b, nextSpawnData);
                item.b(DataComponents.b, CustomData.a.a((NBTTagCompound compoundTag) -> compoundTag.a("Purpur.SpawnData", spawnDataTag)));
            }
            if (type.isPresent()) {
                List<String> lore;
                Component mobName = PaperAdventure.asAdventure(((EntityTypes)type.get()).h());
                String name = level.purpurConfig.silkTouchSpawnerName;
                if (name != null && !name.isEmpty() && !name.equals("Monster Spawner")) {
                    Component displayName = MiniMessage.miniMessage().deserialize(name, (TagResolver)Placeholder.component((String)"mob", (ComponentLike)mobName));
                    if (name.startsWith("<reset>")) {
                        displayName = displayName.decoration(TextDecoration.ITALIC, false);
                    }
                    item.b(DataComponents.g, PaperAdventure.asVanilla(displayName));
                }
                if ((lore = level.purpurConfig.silkTouchSpawnerLore) != null && !lore.isEmpty()) {
                    ArrayList<IChatBaseComponent> loreComponentList = new ArrayList<IChatBaseComponent>();
                    for (String line : lore) {
                        Component lineComponent = MiniMessage.miniMessage().deserialize(line, (TagResolver)Placeholder.component((String)"mob", (ComponentLike)mobName));
                        if (line.startsWith("<reset>")) {
                            lineComponent = lineComponent.decoration(TextDecoration.ITALIC, false);
                        }
                        loreComponentList.add(PaperAdventure.asVanilla(lineComponent));
                    }
                    item.b(DataComponents.j, new ItemLore(loreComponentList, loreComponentList));
                }
                item.b(DataComponents.q, TooltipDisplay.c.a(DataComponents.aa, true));
            }
            BlockMobSpawner.a(level, pos, item);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, stack, includeDrops, dropExp);
    }

    private boolean isSilkTouch(World level, ItemStack stack) {
        return stack != null && level.purpurConfig.silkTouchTools.contains(stack.h()) && EnchantmentManager.getItemEnchantmentLevel(Enchantments.v, stack) >= level.purpurConfig.minimumSilkTouchSpawnerRequire;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, ItemStack stack, boolean dropExperience) {
        super.a(state, level, pos, stack, dropExperience);
    }

    @Override
    public int getExpDrop(IBlockData state, WorldServer level, BlockPosition pos, ItemStack stack, boolean dropExperience) {
        if (level.purpurConfig.silkTouchEnabled && this.isSilkTouch(level, stack)) {
            return 0;
        }
        if (dropExperience) {
            int i2 = 15 + level.z.a(15) + level.z.a(15);
            return i2;
        }
        return 0;
    }
}

