/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemHoe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BlockNetherWart
extends VegetationBlock
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockNetherWart> a = BlockNetherWart.b(BlockNetherWart::new);
    public static final int b = 3;
    public static final BlockStateInteger c = BlockProperties.aw;
    private static final VoxelShape[] d = Block.a(3, (int i2) -> Block.b(16.0, 0.0, 5 + i2 * 3));

    public MapCodec<BlockNetherWart> a() {
        return a;
    }

    protected BlockNetherWart(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.C.b().b(c, 0));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return d[state.c(c)];
    }

    @Override
    protected boolean b(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return state.a(Blocks.ez);
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.c(c) < 3;
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        int ageValue = state.c(c);
        if (ageValue < 3 && random.i() < (float)level.spigotConfig.wartModifier / 1000.0f) {
            state = (IBlockData)state.b(c, ageValue + 1);
            CraftEventFactory.handleBlockGrowEvent(level, pos, state, 2);
        }
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        return new ItemStack(Items.un);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{c});
    }

    @Override
    public void playerDestroy(World world, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity blockEntity, ItemStack itemInHand, boolean includeDrops, boolean dropExp) {
        if (world.purpurConfig.hoeReplantsNetherWarts && itemInHand.h() instanceof ItemHoe) {
            super.playerDestroyAndReplant(world, player, pos, state, blockEntity, itemInHand, Items.un);
        } else {
            super.playerDestroy(world, player, pos, state, blockEntity, itemInHand, includeDrops, dropExp);
        }
    }

    @Override
    public boolean a(IWorldReader world, BlockPosition pos, IBlockData state) {
        return ((World)world).purpurConfig.netherWartAffectedByBonemeal && state.c(c) < 3;
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        int i2 = Math.min(3, state.c(c) + 1);
        state = (IBlockData)state.b(c, i2);
        CraftEventFactory.handleBlockGrowEvent(world, pos, state, 2);
    }
}

