/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.GlobalConfiguration;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.block.NotePlayEvent;

public class BlockNote
extends Block {
    public static final MapCodec<BlockNote> a = BlockNote.b(BlockNote::new);
    public static final BlockStateEnum<BlockPropertyInstrument> b = BlockProperties.bk;
    public static final BlockStateBoolean c = BlockProperties.A;
    public static final BlockStateInteger d = BlockProperties.aV;
    public static final int e = 3;

    public MapCodec<BlockNote> a() {
        return a;
    }

    public BlockNote(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, BlockPropertyInstrument.a)).b(d, 0)).b(c, false));
    }

    private IBlockData a(IWorldReader level, BlockPosition pos, IBlockData state) {
        BlockPropertyInstrument noteBlockInstrument = level.a_(pos.d()).E();
        if (noteBlockInstrument.e()) {
            return (IBlockData)state.b(b, noteBlockInstrument);
        }
        BlockPropertyInstrument noteBlockInstrument1 = level.a_(pos.e()).E();
        BlockPropertyInstrument noteBlockInstrument2 = noteBlockInstrument1.e() ? BlockPropertyInstrument.a : noteBlockInstrument1;
        return (IBlockData)state.b(b, noteBlockInstrument2);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        if (GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
            return this.m();
        }
        return this.a((IWorldReader)context.q(), context.a(), this.m());
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
            return state;
        }
        boolean flag = direction.o() == EnumDirection.EnumAxis.b;
        return flag ? this.a(level, pos, state) : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
            return;
        }
        boolean hasNeighborSignal = level.E(pos);
        if (hasNeighborSignal != state.c(c)) {
            if (hasNeighborSignal) {
                this.a(null, state, level, pos);
                state = level.a_(pos);
            }
            level.a(pos, (IBlockData)state.b(c, hasNeighborSignal), 3);
        }
    }

    private void a(@Nullable Entity entity, IBlockData state, World level, BlockPosition pos) {
        if (level.purpurConfig.noteBlockIgnoreAbove || state.c(b).e() || level.a_(pos.d()).l()) {
            level.a(pos, (Block)this, 0, 0);
            level.a(entity, GameEvent.H, pos);
        }
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        return stack.a(TagsItem.bL) && hitResult.c() == EnumDirection.b ? EnumInteractionResult.e : super.a(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (!level.D_()) {
            if (!GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
                state = (IBlockData)state.a(d);
            }
            level.a(pos, state, 3);
            this.a(player, state, level, pos);
            player.a(StatisticList.ah);
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected void a_(IBlockData state, World level, BlockPosition pos, EntityHuman player) {
        if (!level.D_()) {
            this.a(player, state, level, pos);
            player.a(StatisticList.ag);
        }
    }

    public static float b(int note) {
        return (float)Math.pow(2.0, (double)(note - 12) / 12.0);
    }

    @Override
    protected boolean a(IBlockData state, World level, BlockPosition pos, int id, int param) {
        Holder<SoundEffect> holder;
        float pitchFromNote;
        BlockPropertyInstrument noteBlockInstrument = state.c(b);
        NotePlayEvent event = CraftEventFactory.callNotePlayEvent(level, pos, noteBlockInstrument, state.c(d));
        if (event.isCancelled()) {
            return false;
        }
        if (noteBlockInstrument.b()) {
            byte noteValue = event.getNote().getId();
            pitchFromNote = BlockNote.b(noteValue);
            level.a(Particles.ae, (double)pos.u() + 0.5, (double)pos.v() + 1.2, (double)pos.w() + 0.5, (double)noteValue / 24.0, 0.0, 0.0);
        } else {
            pitchFromNote = 1.0f;
        }
        if (noteBlockInstrument.d()) {
            MinecraftKey customSoundId = this.a(level, pos);
            if (customSoundId == null) {
                return false;
            }
            holder = Holder.a(SoundEffect.a(customSoundId));
        } else {
            holder = CraftBlockData.toNMS(event.getInstrument(), BlockPropertyInstrument.class).a();
        }
        level.a(null, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, holder, SoundCategory.c, 3.0f, pitchFromNote, level.z.g());
        return true;
    }

    @Nullable
    private MinecraftKey a(World level, BlockPosition pos) {
        MinecraftKey minecraftKey;
        TileEntity tileEntity = level.c_(pos.d());
        if (tileEntity instanceof TileEntitySkull) {
            TileEntitySkull skullBlockEntity = (TileEntitySkull)tileEntity;
            minecraftKey = skullBlockEntity.c();
        } else {
            minecraftKey = null;
        }
        return minecraftKey;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }
}

