/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BlockPoweredRail
extends BlockMinecartTrackAbstract {
    public static final MapCodec<BlockPoweredRail> b = BlockPoweredRail.b(BlockPoweredRail::new);
    public static final BlockStateEnum<BlockPropertyTrackPosition> c = BlockProperties.al;
    public static final BlockStateBoolean d = BlockProperties.A;

    public MapCodec<BlockPoweredRail> a() {
        return b;
    }

    protected BlockPoweredRail(BlockBase.Info properties) {
        super(true, properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(c, BlockPropertyTrackPosition.a)).b(d, false)).b(BlockMinecartTrackAbstract.a, false));
    }

    protected boolean a(World level, BlockPosition pos, IBlockData state, boolean searchForward, int recursionCount) {
        if (recursionCount >= level.purpurConfig.railActivationRange) {
            return false;
        }
        int x2 = pos.u();
        int y2 = pos.v();
        int z2 = pos.w();
        boolean flag = true;
        BlockPropertyTrackPosition railShape = state.c(c);
        switch (railShape) {
            case a: {
                if (searchForward) {
                    ++z2;
                    break;
                }
                --z2;
                break;
            }
            case b: {
                if (searchForward) {
                    --x2;
                    break;
                }
                ++x2;
                break;
            }
            case c: {
                if (searchForward) {
                    --x2;
                } else {
                    ++x2;
                    ++y2;
                    flag = false;
                }
                railShape = BlockPropertyTrackPosition.b;
                break;
            }
            case d: {
                if (searchForward) {
                    --x2;
                    ++y2;
                    flag = false;
                } else {
                    ++x2;
                }
                railShape = BlockPropertyTrackPosition.b;
                break;
            }
            case e: {
                if (searchForward) {
                    ++z2;
                } else {
                    --z2;
                    ++y2;
                    flag = false;
                }
                railShape = BlockPropertyTrackPosition.a;
                break;
            }
            case f: {
                if (searchForward) {
                    ++z2;
                    ++y2;
                    flag = false;
                } else {
                    --z2;
                }
                railShape = BlockPropertyTrackPosition.a;
            }
        }
        return this.a(level, new BlockPosition(x2, y2, z2), searchForward, recursionCount, railShape) || flag && this.a(level, new BlockPosition(x2, y2 - 1, z2), searchForward, recursionCount, railShape);
    }

    protected boolean a(World level, BlockPosition state, boolean searchForward, int recursionCount, BlockPropertyTrackPosition shape) {
        IBlockData blockState = level.a_(state);
        if (!blockState.a(this)) {
            return false;
        }
        BlockPropertyTrackPosition railShape = blockState.c(c);
        return (shape != BlockPropertyTrackPosition.b || railShape != BlockPropertyTrackPosition.a && railShape != BlockPropertyTrackPosition.e && railShape != BlockPropertyTrackPosition.f) && (shape != BlockPropertyTrackPosition.a || railShape != BlockPropertyTrackPosition.b && railShape != BlockPropertyTrackPosition.c && railShape != BlockPropertyTrackPosition.d) && blockState.c(d) != false && (level.E(state) || this.a(level, state, blockState, searchForward, recursionCount + 1));
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block block) {
        boolean flag;
        boolean poweredValue = state.c(d);
        boolean bl = flag = level.E(pos) || this.a(level, pos, state, true, 0) || this.a(level, pos, state, false, 0);
        if (flag != poweredValue) {
            int power = flag ? 15 : 0;
            int newPower = CraftEventFactory.callRedstoneChange(level, pos, power, 15 - power).getNewCurrent();
            if (newPower == power) {
                return;
            }
            level.a(pos, (IBlockData)state.b(d, flag), 3);
            level.a(pos.e(), this);
            if (state.c(c).b()) {
                level.a(pos.d(), this);
            }
        }
    }

    @Override
    public IBlockState<BlockPropertyTrackPosition> c() {
        return c;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        BlockPropertyTrackPosition railShape = state.c(c);
        BlockPropertyTrackPosition railShape1 = this.a(railShape, rotation);
        return (IBlockData)state.b(c, railShape1);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        BlockPropertyTrackPosition railShape = state.c(c);
        BlockPropertyTrackPosition railShape1 = this.a(railShape, mirror);
        return (IBlockData)state.b(c, railShape1);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, d, BlockMinecartTrackAbstract.a);
    }
}

