/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.block.BlockRedstoneEvent;

public abstract class BlockPressurePlateAbstract
extends Block {
    private static final VoxelShape c = Block.b(14.0, 0.0, 0.5);
    private static final VoxelShape d = Block.b(14.0, 0.0, 1.0);
    protected static final AxisAlignedBB a = Block.b(14.0, 0.0, 4.0).e().getFirst();
    protected final BlockSetType b;

    protected BlockPressurePlateAbstract(BlockBase.Info properties, BlockSetType type) {
        super(properties.a(type.g()));
        this.b = type;
    }

    protected abstract MapCodec<? extends BlockPressurePlateAbstract> a();

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.h(state) > 0 ? c : d;
    }

    protected int b() {
        return 20;
    }

    @Override
    public boolean a(IBlockData state) {
        return true;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        return direction == EnumDirection.a && !state.a(level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        return BlockPressurePlateAbstract.c(level, blockPos) || BlockPressurePlateAbstract.a(level, blockPos, EnumDirection.b);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        int signalForState = this.h(state);
        if (signalForState > 0) {
            this.a(null, (World)level, pos, state, signalForState);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
        int signalForState;
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (!level.D_() && (signalForState = this.h(state)) == 0) {
            this.a(entity, level, pos, state, signalForState);
        }
    }

    private void a(@Nullable net.minecraft.world.entity.Entity entity, World level, BlockPosition pos, IBlockData state, int currentSignal) {
        boolean flag1;
        int signalStrength = this.b(level, pos);
        boolean flag = currentSignal > 0;
        boolean bl = flag1 = signalStrength > 0;
        if (flag != flag1) {
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), currentSignal, signalStrength);
            eventRedstone.callEvent();
            flag1 = eventRedstone.getNewCurrent() > 0;
            signalStrength = eventRedstone.getNewCurrent();
        }
        if (currentSignal != signalStrength) {
            IBlockData blockState = this.a(state, signalStrength);
            level.a(pos, blockState, 2);
            this.a(level, pos);
            level.b(pos, state, blockState);
        }
        if (!flag1 && flag) {
            level.a(null, pos, this.b.l(), SoundCategory.e);
            level.a(entity, GameEvent.e, pos);
        } else if (flag1 && !flag) {
            level.a(null, pos, this.b.m(), SoundCategory.e);
            level.a(entity, GameEvent.a, pos);
        }
        if (flag1) {
            level.a(new BlockPosition(pos), (Block)this, this.b());
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        if (!movedByPiston && this.h(state) > 0) {
            this.a(level, pos);
        }
    }

    protected void a(World level, BlockPosition pos) {
        level.a(pos, this);
        level.a(pos.e(), this);
    }

    @Override
    protected int a(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection side) {
        return this.h(state);
    }

    @Override
    protected int b(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection side) {
        return side == EnumDirection.b ? this.h(state) : 0;
    }

    @Override
    protected boolean e_(IBlockData state) {
        return true;
    }

    protected static int a(World level, AxisAlignedBB box, Class<? extends net.minecraft.world.entity.Entity> entityClass) {
        return BlockPressurePlateAbstract.getEntities(level, box, entityClass).size();
    }

    protected static <T extends net.minecraft.world.entity.Entity> List<T> getEntities(World level, AxisAlignedBB box, Class<T> entityClass) {
        return level.a(entityClass, box, IEntitySelector.f.and(entity -> !entity.o_()));
    }

    protected abstract int b(World var1, BlockPosition var2);

    protected abstract int h(IBlockData var1);

    protected abstract IBlockData a(IBlockData var1, int var2);
}

