/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BlockReed
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockReed> a = BlockReed.b(BlockReed::new);
    public static final BlockStateInteger b = BlockProperties.aA;
    private static final VoxelShape c = Block.b(12.0, 0.0, 16.0);

    public MapCodec<BlockReed> a() {
        return a;
    }

    protected BlockReed(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.C.b().b(b, 0));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return c;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (!state.a((IWorldReader)level, pos)) {
            level.b(pos, true);
        }
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (level.w(pos.d())) {
            int i2 = 1;
            while (level.a_(pos.c(i2)).a(this)) {
                ++i2;
            }
            if (i2 < level.paperConfig().maxGrowthHeight.reeds) {
                int ageValue = state.c(b);
                int modifier = level.spigotConfig.caneModifier;
                if (ageValue >= 15 || modifier != 100 && random.i() < (float)modifier / 1600.0f) {
                    CraftEventFactory.handleBlockGrowEvent(level, pos.d(), this.m(), 3);
                    level.a(pos, (IBlockData)state.b(b, 0), 260);
                } else if (modifier == 100 || random.i() < (float)modifier / 1600.0f) {
                    level.a(pos, (IBlockData)state.b(b, ageValue + 1), 260);
                }
            }
        }
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (!state.a(level, pos)) {
            scheduledTickAccess.a(pos, this, 1);
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos.e());
        if (blockState.a(this)) {
            return true;
        }
        if (blockState.a(TagsBlock.ae) || blockState.a(TagsBlock.F)) {
            BlockPosition blockPos = pos.e();
            for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                IBlockData blockState1 = level.a_(blockPos.a(direction));
                Fluid fluidState = level.b_(blockPos.a(direction));
                if (!fluidState.a(TagsFluid.a) && !blockState1.a(Blocks.lE)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    public boolean a(IWorldReader world, BlockPosition pos, IBlockData state) {
        if (!((World)world).purpurConfig.sugarCanAffectedByBonemeal || !world.w(pos.d())) {
            return false;
        }
        int reedHeight = 0;
        while (world.a_(pos.c(reedHeight)).a(this)) {
            ++reedHeight;
        }
        return reedHeight < ((World)world).paperConfig().maxGrowthHeight.reeds;
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        int reedHeight = 0;
        while (world.a_(pos.c(reedHeight)).a(this)) {
            ++reedHeight;
        }
        for (int i2 = 0; i2 <= world.paperConfig().maxGrowthHeight.reeds - reedHeight; ++i2) {
            world.c(pos.b(i2), (IBlockData)state.b(b, 0));
        }
    }
}

