/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockShulkerBox
extends BlockTileEntity {
    public static final MapCodec<BlockShulkerBox> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumColor.q.optionalFieldOf("color").forGetter(shulkerBoxBlock -> Optional.ofNullable(shulkerBoxBlock.e)), BlockShulkerBox.x()).apply((Applicative)instance, (optional, properties) -> new BlockShulkerBox(optional.orElse(null), (BlockBase.Info)properties)));
    public static final Map<EnumDirection, VoxelShape> b = VoxelShapes.d(Block.c(16.0, 0.0, 1.0));
    public static final BlockStateEnum<EnumDirection> c = BlockDirectional.a;
    public static final MinecraftKey d = MinecraftKey.b("contents");
    @Nullable
    public final EnumColor e;

    public MapCodec<BlockShulkerBox> a() {
        return a;
    }

    public BlockShulkerBox(@Nullable EnumColor color, BlockBase.Info properties) {
        super(properties);
        this.e = color;
        this.l((IBlockData)this.C.b().b(c, EnumDirection.b));
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityShulkerBox(this.e, pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return BlockShulkerBox.a(blockEntityType, TileEntityTypes.y, TileEntityShulkerBox::a);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (level instanceof WorldServer) {
            TileEntityShulkerBox shulkerBoxBlockEntity;
            WorldServer serverLevel = (WorldServer)level;
            TileEntity tileEntity = level.c_(pos);
            if (tileEntity instanceof TileEntityShulkerBox && BlockShulkerBox.a(state, level, pos, shulkerBoxBlockEntity = (TileEntityShulkerBox)tileEntity) && player.a(shulkerBoxBlockEntity).isPresent()) {
                player.a(StatisticList.ar);
                PiglinAI.a(serverLevel, player, true);
            }
        }
        return EnumInteractionResult.a;
    }

    private static boolean a(IBlockData state, World level, BlockPosition pos, TileEntityShulkerBox blockEntity) {
        if (blockEntity.l() != TileEntityShulkerBox.AnimationPhase.a) {
            return true;
        }
        AxisAlignedBB aabb = EntityShulker.a(1.0f, state.c(c), 0.0f, 0.5f, pos.c()).h(1.0E-6);
        return level.b(aabb);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        return (IBlockData)this.m().b(c, context.k());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{c});
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox shulkerBoxBlockEntity = (TileEntityShulkerBox)blockEntity;
            if (!level.D_() && player.gD() && !shulkerBoxBlockEntity.c()) {
                ItemStack coloredItemStack = BlockShulkerBox.b(this.b());
                coloredItemStack.b(blockEntity.t());
                EntityItem itemEntity = new EntityItem(level, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, coloredItemStack);
                itemEntity.i();
                level.b(itemEntity);
            } else {
                shulkerBoxBlockEntity.unpackLootTable(player, true);
            }
        }
        return super.a(level, pos, state, player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ItemStack> a(IBlockData state, LootParams.a params) {
        TileEntity blockEntity = params.b(LootContextParameters.j);
        Runnable reAdd = null;
        if (blockEntity instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox shulkerBoxBlockEntity = (TileEntityShulkerBox)blockEntity;
            if (shulkerBoxBlockEntity.lootableData().getLastFill() != -1L || !params.a().paperConfig().lootables.retainUnlootedShulkerBoxLootTableOnNonPlayerBreak) {
                ResourceKey<LootTable> lootTableResourceKey = shulkerBoxBlockEntity.az_();
                reAdd = () -> shulkerBoxBlockEntity.a(lootTableResourceKey);
                shulkerBoxBlockEntity.a((ResourceKey<LootTable>)null);
            }
            params = params.a(d, (Consumer<ItemStack> output) -> {
                for (int i2 = 0; i2 < shulkerBoxBlockEntity.b(); ++i2) {
                    output.accept(shulkerBoxBlockEntity.a(i2));
                }
            });
        }
        try {
            List<ItemStack> list = super.a(state, params);
            return list;
        }
        finally {
            if (reAdd != null) {
                reAdd.run();
            }
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        InventoryUtils.a(state, level, pos);
    }

    @Override
    protected VoxelShape b_(IBlockData state, IBlockAccess level, BlockPosition pos) {
        TileEntityShulkerBox shulkerBoxBlockEntity;
        TileEntity tileEntity = level.c_(pos);
        return tileEntity instanceof TileEntityShulkerBox && !(shulkerBoxBlockEntity = (TileEntityShulkerBox)tileEntity).x() ? b.get(state.c(c).g()) : VoxelShapes.b();
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        VoxelShape voxelShape;
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox shulkerBoxBlockEntity = (TileEntityShulkerBox)tileEntity;
            voxelShape = VoxelShapes.a(shulkerBoxBlockEntity.a(state));
        } else {
            voxelShape = VoxelShapes.b();
        }
        return voxelShape;
    }

    @Override
    protected boolean d_(IBlockData state) {
        return false;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        return Container.a(level.c_(pos));
    }

    public static Block a(@Nullable EnumColor color) {
        if (color == null) {
            return Blocks.lL;
        }
        return switch (color) {
            default -> throw new MatchException(null, null);
            case EnumColor.a -> Blocks.lM;
            case EnumColor.b -> Blocks.lN;
            case EnumColor.c -> Blocks.lO;
            case EnumColor.d -> Blocks.lP;
            case EnumColor.e -> Blocks.lQ;
            case EnumColor.f -> Blocks.lR;
            case EnumColor.g -> Blocks.lS;
            case EnumColor.h -> Blocks.lT;
            case EnumColor.i -> Blocks.lU;
            case EnumColor.j -> Blocks.lV;
            case EnumColor.l -> Blocks.lX;
            case EnumColor.m -> Blocks.lY;
            case EnumColor.n -> Blocks.lZ;
            case EnumColor.o -> Blocks.ma;
            case EnumColor.p -> Blocks.mb;
            case EnumColor.k -> Blocks.lW;
        };
    }

    @Nullable
    public EnumColor b() {
        return this.e;
    }

    public static ItemStack b(@Nullable EnumColor color) {
        return new ItemStack(BlockShulkerBox.a(color));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(c, rotation.a(state.c(c)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(c)));
    }
}

