/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockTrapdoor
extends BlockFacingHorizontal
implements IBlockWaterlogged {
    public static final MapCodec<BlockTrapdoor> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(trapDoorBlock -> trapDoorBlock.h), BlockTrapdoor.x()).apply((Applicative)instance, BlockTrapdoor::new));
    public static final BlockStateBoolean b = BlockProperties.y;
    public static final BlockStateEnum<BlockPropertyHalf> c = BlockProperties.ai;
    public static final BlockStateBoolean d = BlockProperties.A;
    public static final BlockStateBoolean e = BlockProperties.I;
    private static final Map<EnumDirection, VoxelShape> g = VoxelShapes.d(Block.c(16.0, 13.0, 16.0));
    private final BlockSetType h;

    public MapCodec<? extends BlockTrapdoor> a() {
        return a;
    }

    protected BlockTrapdoor(BlockSetType type, BlockBase.Info properties) {
        super(properties.a(type.g()));
        this.h = type;
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().b(BlockFacingHorizontal.f, EnumDirection.c)).b(b, false)).b(c, BlockPropertyHalf.b)).b(d, false)).b(e, false));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return g.get(state.c(b) != false ? state.c(BlockFacingHorizontal.f) : (state.c(c) == BlockPropertyHalf.a ? EnumDirection.a : EnumDirection.b));
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        switch (pathComputationType) {
            case a: {
                return state.c(b);
            }
            case b: {
                return state.c(e);
            }
            case c: {
                return state.c(b);
            }
        }
        return false;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (!this.h.c()) {
            return EnumInteractionResult.e;
        }
        this.b(state, level, pos, player);
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> dropConsumer) {
        if (explosion.g() && this.h.d() && !state.c(d).booleanValue()) {
            this.b(state, (World)level, pos, null);
        }
        super.a(state, level, pos, explosion, dropConsumer);
    }

    private void b(IBlockData state, World level, BlockPosition pos, @Nullable EntityHuman player) {
        IBlockData blockState = (IBlockData)state.a(b);
        level.a(pos, blockState, 2);
        if (blockState.c(e).booleanValue()) {
            level.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        this.a(player, level, pos, (boolean)blockState.c(b));
    }

    protected void a(@Nullable EntityHuman player, World level, BlockPosition pos, boolean isOpened) {
        level.a((Entity)player, pos, isOpened ? this.h.k() : this.h.j(), SoundCategory.e, 1.0f, level.I_().i() * 0.1f + 0.9f);
        level.a((Entity)player, isOpened ? GameEvent.h : GameEvent.d, pos);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        boolean hasNeighborSignal;
        if (!level.D_() && (hasNeighborSignal = level.E(pos)) != state.c(d)) {
            BlockPosition abovePos;
            IBlockData above;
            boolean open;
            CraftBlock bblock = CraftBlock.at(level, pos);
            int power = bblock.getBlockPower();
            int oldPower = state.c(b) != false ? 15 : 0;
            if (oldPower == 0 ^ power == 0 || neighborBlock.m().p()) {
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)bblock, oldPower, power);
                level.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                hasNeighborSignal = eventRedstone.getNewCurrent() > 0;
            }
            boolean bl = open = state.c(b) != hasNeighborSignal;
            if (hasNeighborSignal && open && (above = level.a_(abovePos = pos.d())).b() instanceof BlockRedstoneWire) {
                level.a(abovePos, Blocks.a.m(), 3);
                Block.a(level, abovePos, new ItemStack(Items.mB));
                if (level.a_(pos) != state) {
                    return;
                }
            }
            if (open) {
                state = (IBlockData)state.b(b, hasNeighborSignal);
                this.a(null, level, pos, hasNeighborSignal);
            }
            level.a(pos, (IBlockData)state.b(d, hasNeighborSignal), 2);
            if (state.c(e).booleanValue()) {
                level.a(pos, FluidTypes.c, FluidTypes.c.a(level));
            }
        }
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        IBlockData blockState = this.m();
        Fluid fluidState = context.q().b_(context.a());
        EnumDirection clickedFace = context.k();
        blockState = !context.c() && clickedFace.o().d() ? (IBlockData)((IBlockData)blockState.b(BlockFacingHorizontal.f, clickedFace)).b(c, context.l().h - (double)context.a().v() > 0.5 ? BlockPropertyHalf.a : BlockPropertyHalf.b) : (IBlockData)((IBlockData)blockState.b(BlockFacingHorizontal.f, context.g().g())).b(c, clickedFace == EnumDirection.b ? BlockPropertyHalf.b : BlockPropertyHalf.a);
        if (context.q().E(context.a())) {
            blockState = (IBlockData)((IBlockData)blockState.b(b, true)).b(d, true);
        }
        return (IBlockData)blockState.b(e, fluidState.a() == FluidTypes.c);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.f, b, c, d, e);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(e) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(e).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected BlockSetType q() {
        return this.h;
    }
}

