/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.BlockTripwireHook;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.PluginManager;

public class BlockTripwire
extends Block {
    public static final MapCodec<BlockTripwire> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.e.q().fieldOf("hook").forGetter(tripwire -> tripwire.T), BlockTripwire.x()).apply((Applicative)instance, BlockTripwire::new));
    public static final BlockStateBoolean b = BlockProperties.A;
    public static final BlockStateBoolean c = BlockProperties.a;
    public static final BlockStateBoolean d = BlockProperties.g;
    public static final BlockStateBoolean e = BlockSprawling.b;
    public static final BlockStateBoolean f = BlockSprawling.c;
    public static final BlockStateBoolean g = BlockSprawling.d;
    public static final BlockStateBoolean h = BlockSprawling.e;
    private static final Map<EnumDirection, BlockStateBoolean> i = BlockTall.f;
    private static final VoxelShape D = Block.b(16.0, 1.0, 2.5);
    private static final VoxelShape R = Block.b(16.0, 0.0, 8.0);
    private static final int S = 10;
    private final Block T;

    public MapCodec<BlockTripwire> a() {
        return a;
    }

    public BlockTripwire(Block hook, BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, false)).b(c, false)).b(d, false)).b(e, false)).b(f, false)).b(g, false)).b(h, false));
        this.T = hook;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(c) != false ? D : R;
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return this.m();
        }
        World level = context.q();
        BlockPosition clickedPos = context.a();
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.m().b(e, this.a(level.a_(clickedPos.f()), EnumDirection.c))).b(f, this.a(level.a_(clickedPos.i()), EnumDirection.f))).b(g, this.a(level.a_(clickedPos.g()), EnumDirection.d))).b(h, this.a(level.a_(clickedPos.h()), EnumDirection.e));
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return state;
        }
        return direction.o().d() ? (IBlockData)state.b(i.get(direction), this.a(neighborState, direction)) : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (!oldState.a(state.b())) {
            this.a(level, pos, state);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (!movedByPiston) {
            this.a((World)level, pos, (IBlockData)state.b(b, true));
        }
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return state;
        }
        if (!level.D_() && !player.fq().f() && player.fq().a(Items.tZ)) {
            level.a(pos, (IBlockData)state.b(d, true), 260);
            level.a((net.minecraft.world.entity.Entity)player, GameEvent.M, pos);
        }
        return super.a(level, pos, state, player);
    }

    private void a(World level, BlockPosition pos, IBlockData state) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        block0: for (EnumDirection direction : new EnumDirection[]{EnumDirection.d, EnumDirection.e}) {
            for (int i2 = 1; i2 < 42; ++i2) {
                BlockPosition blockPos = pos.a(direction, i2);
                IBlockData blockState = level.a_(blockPos);
                if (blockState.a(this.T)) {
                    if (blockState.c(BlockTripwireHook.b) != direction.g()) continue block0;
                    BlockTripwireHook.a(level, blockPos, blockState, false, true, i2, state);
                    continue block0;
                }
                if (!blockState.a(this)) continue block0;
            }
        }
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        return state.f(level, pos);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (!level.D_() && !state.c(b).booleanValue()) {
            this.a(level, pos, List.of(entity));
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (level.a_(pos).c(b).booleanValue()) {
            this.a(level, pos);
        }
    }

    private void a(World level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos);
        List<net.minecraft.world.entity.Entity> entities = level.a_(null, blockState.f(level, pos).a().a(pos));
        this.a(level, pos, entities);
    }

    private void a(World level, BlockPosition pos, List<? extends net.minecraft.world.entity.Entity> entities) {
        IBlockData blockState = level.a_(pos);
        boolean poweredValue = blockState.c(b);
        boolean flag = false;
        if (!entities.isEmpty()) {
            for (net.minecraft.world.entity.Entity entity : entities) {
                if (entity.o_()) continue;
                flag = true;
                break;
            }
        }
        if (poweredValue != flag && flag && blockState.c(c).booleanValue()) {
            PluginManager manager = level.getCraftServer().getPluginManager();
            CraftBlock craftBlock = CraftBlock.at(level, pos);
            boolean allowed = false;
            for (net.minecraft.world.entity.Entity entity : entities) {
                PlayerInteractEvent cancellable;
                if (entity == null) continue;
                if (entity instanceof EntityHuman) {
                    cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, pos, null, null, null);
                } else {
                    if (!(entity instanceof net.minecraft.world.entity.Entity)) continue;
                    cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)craftBlock);
                    manager.callEvent((Event)((EntityInteractEvent)cancellable));
                }
                if (cancellable.isCancelled()) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                return;
            }
        }
        if (flag != poweredValue) {
            blockState = (IBlockData)blockState.b(b, flag);
            level.a(pos, blockState, 3);
            this.a(level, pos, blockState);
        }
        if (flag) {
            level.a(new BlockPosition(pos), (Block)this, 10);
        }
    }

    public boolean a(IBlockData state, EnumDirection direction) {
        return state.a(this.T) ? state.c(BlockTripwireHook.b) == direction.g() : state.a(this);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        switch (rotation) {
            case c: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(e, state.c(g))).b(f, state.c(h))).b(g, state.c(e))).b(h, state.c(f));
            }
            case d: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(e, state.c(f))).b(f, state.c(g))).b(g, state.c(h))).b(h, state.c(e));
            }
            case b: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(e, state.c(h))).b(f, state.c(e))).b(g, state.c(f))).b(h, state.c(g));
            }
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        switch (mirror) {
            case b: {
                return (IBlockData)((IBlockData)state.b(e, state.c(g))).b(g, state.c(e));
            }
            case c: {
                return (IBlockData)((IBlockData)state.b(f, state.c(h))).b(h, state.c(f));
            }
        }
        return super.a(state, mirror);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e, f, h, g);
    }
}

