/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockTurtleEgg
extends Block {
    public static final MapCodec<BlockTurtleEgg> a = BlockTurtleEgg.b(BlockTurtleEgg::new);
    public static final BlockStateInteger b = BlockProperties.aI;
    public static final BlockStateInteger c = BlockProperties.aH;
    public static final int d = 2;
    public static final int e = 1;
    public static final int f = 4;
    private static final VoxelShape g = Block.a(3.0, 0.0, 3.0, 12.0, 7.0, 12.0);
    private static final VoxelShape h = Block.b(14.0, 0.0, 7.0);

    public MapCodec<BlockTurtleEgg> a() {
        return a;
    }

    public BlockTurtleEgg(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)this.C.b().b(b, 0)).b(c, 1));
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, net.minecraft.world.entity.Entity entity) {
        if (!entity.cq()) {
            this.a(level, state, pos, entity, 100);
        }
        super.a(level, pos, state, entity);
    }

    @Override
    public void a(World level, IBlockData state, BlockPosition pos, net.minecraft.world.entity.Entity entity, double fallDistance) {
        if (!(entity instanceof EntityZombie)) {
            this.a(level, state, pos, entity, 3);
        }
        super.a(level, state, pos, entity, fallDistance);
    }

    private void a(World level, IBlockData state, BlockPosition pos, net.minecraft.world.entity.Entity entity, int chance) {
        WorldServer serverLevel;
        if (state.a(Blocks.nb) && level instanceof WorldServer && this.a(serverLevel = (WorldServer)level, entity) && level.z.a(chance) == 0) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, pos, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos));
                level.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            this.a((World)serverLevel, pos, state);
        }
    }

    public void a(World level, BlockPosition pos, IBlockData state) {
        level.a(null, pos, SoundEffects.CB, SoundCategory.e, 0.7f, 0.9f + level.z.i() * 0.2f);
        int eggsValue = state.c(c);
        if (eggsValue <= 1) {
            level.b(pos, false);
        } else {
            level.a(pos, (IBlockData)state.b(c, eggsValue - 1), 2);
            level.a(GameEvent.f, pos, GameEvent.a.a(state));
            level.c(2001, pos, Block.j(state));
        }
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (this.a(level) && BlockTurtleEgg.a(level, pos)) {
            int hatchValue = state.c(b);
            if (hatchValue < 2) {
                if (!CraftEventFactory.handleBlockGrowEvent(level, pos, (IBlockData)state.b(b, hatchValue + 1), 2)) {
                    return;
                }
                level.a(null, pos, SoundEffects.CC, SoundCategory.e, 0.7f, 0.9f + random.i() * 0.2f);
                level.a(GameEvent.c, pos, GameEvent.a.a(state));
            } else {
                if (CraftEventFactory.callBlockFadeEvent(level, pos, Blocks.a.m()).isCancelled()) {
                    return;
                }
                level.a(null, pos, SoundEffects.CD, SoundCategory.e, 0.7f, 0.9f + random.i() * 0.2f);
                level.a(pos, false);
                level.a(GameEvent.f, pos, GameEvent.a.a(state));
                for (int i2 = 0; i2 < state.c(c); ++i2) {
                    level.c(2001, pos, Block.j(state));
                    EntityTurtle turtle = EntityTypes.bG.a(level, EntitySpawnReason.e);
                    if (turtle == null) continue;
                    turtle.c_(-24000);
                    turtle.h(pos);
                    turtle.b((double)pos.u() + 0.3 + (double)i2 * 0.2, pos.v(), (double)pos.w() + 0.3, 0.0f, 0.0f);
                    level.addFreshEntity(turtle, CreatureSpawnEvent.SpawnReason.EGG);
                }
            }
        }
    }

    public static boolean a(IBlockAccess level, BlockPosition pos) {
        return BlockTurtleEgg.b(level, pos.e());
    }

    public static boolean b(IBlockAccess level, BlockPosition pos) {
        return level.a_(pos).a(TagsBlock.F);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        if (BlockTurtleEgg.a(level, pos) && !level.D_()) {
            level.c(2012, pos, 15);
        }
    }

    private boolean a(World level) {
        float timeOfDay = level.f(1.0f);
        return (double)timeOfDay < 0.69 && (double)timeOfDay > 0.65 || level.z.a(level.purpurConfig.turtleEggsRandomTickCrackChance) == 0;
    }

    @Override
    public void playerDestroy(World level, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity blockEntity, ItemStack stack, boolean includeDrops, boolean dropExp) {
        super.playerDestroy(level, player, pos, state, blockEntity, stack, includeDrops, dropExp);
        this.a(level, pos, state);
    }

    @Override
    protected boolean a(IBlockData state, BlockActionContext useContext) {
        return !useContext.h() && useContext.n().a(this.h()) && state.c(c) < 4 || super.a(state, useContext);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        IBlockData blockState = context.q().a_(context.a());
        return blockState.a(this) ? (IBlockData)blockState.b(c, Math.min(4, blockState.c(c) + 1)) : super.a(context);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(c) == 1 ? g : h;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }

    private boolean a(WorldServer level, net.minecraft.world.entity.Entity entity) {
        if (entity instanceof EntityTurtle || entity instanceof EntityBat) {
            return false;
        }
        if (level.purpurConfig.turtleEggsBreakFromExpOrbs && entity instanceof EntityExperienceOrb) {
            return true;
        }
        if (level.purpurConfig.turtleEggsBreakFromItems && entity instanceof EntityItem) {
            return true;
        }
        if (level.purpurConfig.turtleEggsBreakFromMinecarts && entity instanceof EntityMinecartAbstract) {
            return true;
        }
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        if (level.purpurConfig.turtleEggsTramplingFeatherFalling) {
            ItemStack bootsItem = ((EntityLiving)entity).a(EnumItemSlot.c);
            return bootsItem != ItemStack.l || EnchantmentManager.getItemEnchantmentLevel(Enchantments.c, bootsItem) < (int)entity.an;
        }
        if (entity instanceof EntityHuman) {
            return true;
        }
        return level.S().getBoolean(GameRules.d, level.purpurConfig.turtleEggsMobGriefingOverride);
    }
}

