/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BlockVine
extends Block {
    public static final MapCodec<BlockVine> a = BlockVine.b(BlockVine::new);
    public static final BlockStateBoolean b = BlockSprawling.f;
    public static final BlockStateBoolean c = BlockSprawling.b;
    public static final BlockStateBoolean d = BlockSprawling.c;
    public static final BlockStateBoolean e = BlockSprawling.d;
    public static final BlockStateBoolean f = BlockSprawling.e;
    public static final Map<EnumDirection, BlockStateBoolean> g = BlockSprawling.h.entrySet().stream().filter(entry -> entry.getKey() != EnumDirection.a).collect(SystemUtils.a());
    private final Function<IBlockData, VoxelShape> h;

    public MapCodec<BlockVine> a() {
        return a;
    }

    public BlockVine(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, false)).b(c, false)).b(d, false)).b(e, false)).b(f, false));
        this.h = this.b();
    }

    private Function<IBlockData, VoxelShape> b() {
        Map<EnumDirection, VoxelShape> map = VoxelShapes.d(Block.c(16.0, 0.0, 1.0));
        return this.a((IBlockData blockState) -> {
            VoxelShape voxelShape = VoxelShapes.a();
            for (Map.Entry<EnumDirection, BlockStateBoolean> entry : g.entrySet()) {
                if (!((Boolean)blockState.c(entry.getValue())).booleanValue()) continue;
                voxelShape = VoxelShapes.a(voxelShape, (VoxelShape)map.get(entry.getKey()));
            }
            return voxelShape.c() ? VoxelShapes.b() : voxelShape;
        });
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.h.apply(state);
    }

    @Override
    protected boolean d_(IBlockData state) {
        return true;
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        return this.p(this.e(state, level, pos));
    }

    private boolean p(IBlockData state) {
        return this.r(state) > 0;
    }

    private int r(IBlockData state) {
        int i2 = 0;
        for (BlockStateBoolean booleanProperty : g.values()) {
            if (!state.c(booleanProperty).booleanValue()) continue;
            ++i2;
        }
        return i2;
    }

    private boolean b(IBlockAccess level, BlockPosition pos, EnumDirection direction) {
        if (direction == EnumDirection.a) {
            return false;
        }
        BlockPosition blockPos = pos.a(direction);
        if (BlockVine.a(level, blockPos, direction)) {
            return true;
        }
        if (direction.o() == EnumDirection.EnumAxis.b) {
            return false;
        }
        BlockStateBoolean booleanProperty = g.get(direction);
        IBlockData blockState = level.a_(pos.d());
        return blockState.a(this) && blockState.c(booleanProperty) != false;
    }

    public static boolean a(IBlockAccess level, BlockPosition neighborPos, EnumDirection attachedFace) {
        return MultifaceBlock.a(level, attachedFace, neighborPos, level.a_(neighborPos));
    }

    private IBlockData e(IBlockData state, IBlockAccess level, BlockPosition pos) {
        BlockPosition blockPos = pos.d();
        if (state.c(b).booleanValue()) {
            state = (IBlockData)state.b(b, BlockVine.a(level, blockPos, EnumDirection.a));
        }
        BlockBase.BlockData blockState = null;
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockStateBoolean propertyForFace = BlockVine.a(direction);
            if (!state.c(propertyForFace).booleanValue()) continue;
            boolean canSupportAtFace = this.b(level, pos, direction);
            if (!canSupportAtFace) {
                if (blockState == null) {
                    blockState = level.a_(blockPos);
                }
                canSupportAtFace = blockState.a(this) && blockState.c(propertyForFace) != false;
            }
            state = (IBlockData)state.b(propertyForFace, canSupportAtFace);
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (direction == EnumDirection.a) {
            return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        }
        IBlockData updatedState = this.e(state, level, pos);
        return !this.p(updatedState) ? Blocks.a.m() : updatedState;
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (level.S().c(GameRules.Z) && random.i() < (float)level.spigotConfig.vineModifier / 400.0f) {
            EnumDirection random1 = EnumDirection.b(random);
            BlockPosition blockPos = pos.d();
            if (random1.o().d() && !state.c(BlockVine.a(random1)).booleanValue()) {
                if (this.a((IBlockAccess)level, pos)) {
                    BlockPosition blockPos1 = pos.a(random1);
                    IBlockData blockState = level.a_(blockPos1);
                    if (blockState.l()) {
                        EnumDirection clockWise = random1.h();
                        EnumDirection counterClockWise = random1.i();
                        boolean value = state.c(BlockVine.a(clockWise));
                        boolean value1 = state.c(BlockVine.a(counterClockWise));
                        BlockPosition blockPos2 = blockPos1.a(clockWise);
                        BlockPosition blockPos3 = blockPos1.a(counterClockWise);
                        BlockPosition source = pos;
                        if (value && BlockVine.a((IBlockAccess)level, blockPos2, clockWise)) {
                            CraftEventFactory.handleBlockSpreadEvent(level, source, blockPos1, (IBlockData)this.m().b(BlockVine.a(clockWise), true), 2);
                        } else if (value1 && BlockVine.a((IBlockAccess)level, blockPos3, counterClockWise)) {
                            CraftEventFactory.handleBlockSpreadEvent(level, source, blockPos1, (IBlockData)this.m().b(BlockVine.a(counterClockWise), true), 2);
                        } else {
                            EnumDirection opposite = random1.g();
                            if (value && level.w(blockPos2) && BlockVine.a((IBlockAccess)level, pos.a(clockWise), opposite)) {
                                CraftEventFactory.handleBlockSpreadEvent(level, source, blockPos2, (IBlockData)this.m().b(BlockVine.a(opposite), true), 2);
                            } else if (value1 && level.w(blockPos3) && BlockVine.a((IBlockAccess)level, pos.a(counterClockWise), opposite)) {
                                CraftEventFactory.handleBlockSpreadEvent(level, source, blockPos3, (IBlockData)this.m().b(BlockVine.a(opposite), true), 2);
                            } else if ((double)random.i() < 0.05 && BlockVine.a((IBlockAccess)level, blockPos1.d(), EnumDirection.b)) {
                                CraftEventFactory.handleBlockSpreadEvent(level, source, blockPos1, (IBlockData)this.m().b(b, true), 2);
                            }
                        }
                    } else if (BlockVine.a((IBlockAccess)level, blockPos1, random1)) {
                        CraftEventFactory.handleBlockGrowEvent(level, pos, (IBlockData)state.b(BlockVine.a(random1), true), 2);
                    }
                }
            } else {
                IBlockData blockState3;
                IBlockData blockState2;
                BlockPosition blockPos1;
                IBlockData blockState;
                if (random1 == EnumDirection.b && pos.v() < level.ar()) {
                    if (this.b(level, pos, random1)) {
                        CraftEventFactory.handleBlockGrowEvent(level, pos, (IBlockData)state.b(b, true), 2);
                        return;
                    }
                    if (level.w(blockPos)) {
                        if (!this.a((IBlockAccess)level, pos)) {
                            return;
                        }
                        IBlockData blockState1 = state;
                        for (EnumDirection clockWise : EnumDirection.EnumDirectionLimit.a) {
                            if (!random.h() && BlockVine.a((IBlockAccess)level, blockPos.a(clockWise), clockWise)) continue;
                            blockState1 = (IBlockData)blockState1.b(BlockVine.a(clockWise), false);
                        }
                        if (this.s(blockState1)) {
                            CraftEventFactory.handleBlockSpreadEvent(level, pos, blockPos, blockState1, 2);
                        }
                        return;
                    }
                }
                if (pos.v() > level.M_() && ((blockState = level.a_(blockPos1 = pos.e())).l() || blockState.a(this)) && (blockState2 = blockState.l() ? this.m() : blockState) != (blockState3 = this.a(state, blockState2, random)) && this.s(blockState3)) {
                    CraftEventFactory.handleBlockSpreadEvent(level, pos, blockPos1, blockState3, 2);
                }
            }
        }
    }

    private IBlockData a(IBlockData sourceState, IBlockData spreadState, RandomSource random) {
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockStateBoolean propertyForFace;
            if (!random.h() || !sourceState.c(propertyForFace = BlockVine.a(direction)).booleanValue()) continue;
            spreadState = (IBlockData)spreadState.b(propertyForFace, true);
        }
        return spreadState;
    }

    private boolean s(IBlockData state) {
        return state.c(c) != false || state.c(d) != false || state.c(e) != false || state.c(f) != false;
    }

    private boolean a(IBlockAccess level, BlockPosition pos) {
        int i2 = 4;
        Iterable<BlockPosition> iterable = BlockPosition.b(pos.u() - 4, pos.v() - 1, pos.w() - 4, pos.u() + 4, pos.v() + 1, pos.w() + 4);
        int i1 = 5;
        for (BlockPosition blockPos : iterable) {
            if (!level.a_(blockPos).a(this) || --i1 > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean a(IBlockData state, BlockActionContext useContext) {
        IBlockData blockState = useContext.q().a_(useContext.a());
        return blockState.a(this) ? this.r(blockState) < g.size() : super.a(state, useContext);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        IBlockData blockState = context.q().a_(context.a());
        boolean isBlock = blockState.a(this);
        IBlockData blockState1 = isBlock ? blockState : this.m();
        for (EnumDirection direction : context.f()) {
            boolean flag;
            if (direction == EnumDirection.a) continue;
            BlockStateBoolean propertyForFace = BlockVine.a(direction);
            boolean bl = flag = isBlock && blockState.c(propertyForFace) != false;
            if (flag || !this.b(context.q(), context.a(), direction)) continue;
            return (IBlockData)blockState1.b(propertyForFace, true);
        }
        return isBlock ? blockState1 : null;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e, f);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotate) {
        switch (rotate) {
            case c: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(e))).b(d, state.c(f))).b(e, state.c(c))).b(f, state.c(d));
            }
            case d: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(d))).b(d, state.c(e))).b(e, state.c(f))).b(f, state.c(c));
            }
            case b: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(f))).b(d, state.c(c))).b(e, state.c(d))).b(f, state.c(e));
            }
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        switch (mirror) {
            case b: {
                return (IBlockData)((IBlockData)state.b(c, state.c(e))).b(e, state.c(c));
            }
            case c: {
                return (IBlockData)((IBlockData)state.b(d, state.c(f))).b(f, state.c(d));
            }
        }
        return super.a(state, mirror);
    }

    public static BlockStateBoolean a(EnumDirection face) {
        return g.get(face);
    }
}

