/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.CopperGolemStatueBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.jetbrains.annotations.Nullable;

public class CopperGolemStatueBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<CopperGolemStatueBlock> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WeatheringCopper.a.f.fieldOf("weathering_state").forGetter(CopperGolemStatueBlock::d), CopperGolemStatueBlock.x()).apply((Applicative)instance, CopperGolemStatueBlock::new));
    public static final BlockStateEnum<EnumDirection> b = BlockProperties.T;
    public static final BlockStateEnum<a> c = BlockProperties.bJ;
    public static final BlockStateBoolean d = BlockProperties.I;
    private static final VoxelShape e = Block.b(10.0, 0.0, 14.0);
    private final WeatheringCopper.a f;

    public MapCodec<? extends CopperGolemStatueBlock> a() {
        return a;
    }

    public CopperGolemStatueBlock(WeatheringCopper.a weatheringState, BlockBase.Info properties) {
        super(properties);
        this.f = weatheringState;
        this.l((IBlockData)((IBlockData)((IBlockData)this.m().b(b, EnumDirection.c)).b(c, net.minecraft.world.level.block.CopperGolemStatueBlock$a.a)).b(d, false));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        super.a(builder);
        builder.a(b, c, d);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        Fluid fluidState = context.q().b_(context.a());
        return (IBlockData)((IBlockData)this.m().b(b, context.g().g())).b(d, fluidState.a() == FluidTypes.c);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return e;
    }

    @Override
    protected VoxelShape f_(IBlockData state) {
        return VoxelShapes.a();
    }

    public WeatheringCopper.a d() {
        return this.f;
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        if (stack.a(TagsItem.bW)) {
            return EnumInteractionResult.e;
        }
        return this.updatePose(level, state, pos, player);
    }

    EnumInteractionResult updatePose(World level, IBlockData state, BlockPosition pos, EntityHuman player) {
        IBlockData newState = (IBlockData)state.b(c, state.c(c).a());
        if (!CraftEventFactory.callEntityChangeBlockEvent(player, pos, newState)) {
            return EnumInteractionResult.e;
        }
        level.a(null, pos, SoundEffects.gq, SoundCategory.e);
        level.a(pos, newState, 3);
        level.a((Entity)player, GameEvent.c, pos);
        return EnumInteractionResult.a;
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return pathComputationType == PathMode.b && state.y().a(TagsFluid.a);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new CopperGolemStatueBlockEntity(pos, state);
    }

    @Override
    public boolean o(IBlockData state) {
        return state.a(TagsBlock.am);
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        return state.c(c).ordinal() + 1;
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        ItemStack itemStack;
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof CopperGolemStatueBlockEntity) {
            CopperGolemStatueBlockEntity copperGolemStatueBlockEntity = (CopperGolemStatueBlockEntity)tileEntity;
            itemStack = copperGolemStatueBlockEntity.a(this.h().m(), state.c(c));
        } else {
            itemStack = super.a(level, pos, state, includeData);
        }
        return itemStack;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        level.b(pos, state.b());
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(d).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a a = new a("standing");
        public static final /* enum */ a b = new a("sitting");
        public static final /* enum */ a c = new a("running");
        public static final /* enum */ a d = new a("star");
        public static final IntFunction<a> e;
        public static final Codec<a> f;
        private final String g;
        private static final /* synthetic */ a[] h;

        public static a[] values() {
            return (a[])h.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(String name) {
            this.g = name;
        }

        @Override
        public String c() {
            return this.g;
        }

        public a a() {
            return e.apply(this.ordinal() + 1);
        }

        private static /* synthetic */ a[] b() {
            return new a[]{a, b, c, d};
        }

        static {
            h = net.minecraft.world.level.block.CopperGolemStatueBlock$a.b();
            e = ByIdMap.a(Enum::ordinal, net.minecraft.world.level.block.CopperGolemStatueBlock$a.values(), ByIdMap.a.a);
            f = INamable.a(a::values);
        }
    }
}

