/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;

public class CreakingHeartBlock
extends BlockTileEntity {
    public static final MapCodec<CreakingHeartBlock> a = CreakingHeartBlock.b(CreakingHeartBlock::new);
    public static final BlockStateEnum<EnumDirection.EnumAxis> b = BlockProperties.K;
    public static final BlockStateEnum<CreakingHeartState> c = BlockProperties.bF;
    public static final BlockStateBoolean d = BlockProperties.w;

    public MapCodec<CreakingHeartBlock> a() {
        return a;
    }

    protected CreakingHeartBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.m().b(b, EnumDirection.EnumAxis.b)).b(c, CreakingHeartState.a)).b(d, false));
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new CreakingHeartBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        if (level.D_()) {
            return null;
        }
        return state.c(c) != CreakingHeartState.a ? CreakingHeartBlock.a(blockEntityType, TileEntityTypes.k, CreakingHeartBlockEntity::a) : null;
    }

    public static boolean a(World level) {
        return level.ac();
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        if (CreakingHeartBlock.a(level) && state.c(c) != CreakingHeartState.a && random.a(16) == 0 && CreakingHeartBlock.a(level, pos)) {
            level.a(pos.u(), (double)pos.v(), (double)pos.w(), SoundEffects.hi, SoundCategory.e, 1.0f, 1.0f, false);
        }
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        scheduledTickAccess.a(pos, this, 1);
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        IBlockData blockState = CreakingHeartBlock.c(state, level, pos);
        if (blockState != state) {
            level.a(pos, blockState, 3);
        }
    }

    private static IBlockData c(IBlockData state, World level, BlockPosition pos) {
        boolean flag;
        boolean hasRequiredLogs = CreakingHeartBlock.b(state, (IWorldReader)level, pos);
        boolean bl = flag = state.c(c) == CreakingHeartState.a;
        return hasRequiredLogs && flag ? (IBlockData)state.b(c, CreakingHeartBlock.a(level) ? CreakingHeartState.c : CreakingHeartState.b) : state;
    }

    public static boolean b(IBlockData state, IWorldReader level, BlockPosition pos) {
        EnumDirection.EnumAxis axis = state.c(b);
        for (EnumDirection direction : axis.g()) {
            IBlockData blockState = level.a_(pos.a(direction));
            if (blockState.a(TagsBlock.t) && blockState.c(b) == axis) continue;
            return false;
        }
        return true;
    }

    private static boolean a(GeneratorAccess level, BlockPosition pos) {
        for (EnumDirection direction : EnumDirection.values()) {
            BlockPosition blockPos = pos.a(direction);
            IBlockData blockState = level.a_(blockPos);
            if (blockState.a(TagsBlock.t)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        return CreakingHeartBlock.c((IBlockData)this.m().b(b, context.k().o()), context.q(), context.a());
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return BlockRotatable.b(state, rotation);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        InventoryUtils.a(state, level, pos);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> dropConsumer) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity;
            if (explosion instanceof ServerExplosion) {
                ServerExplosion serverExplosion = (ServerExplosion)explosion;
                if (explosion.b().a()) {
                    creakingHeartBlockEntity.a(serverExplosion.k());
                    EntityLiving entityLiving = explosion.c();
                    if (entityLiving instanceof EntityHuman) {
                        EntityHuman player = (EntityHuman)entityLiving;
                        if (explosion.b().a()) {
                            this.a(player, state, level, pos);
                        }
                    }
                }
            }
        }
        super.a(state, level, pos, explosion, dropConsumer);
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity;
            creakingHeartBlockEntity.a(player.ei().a(player));
            this.a(player, state, level, pos);
        }
        return super.a(level, pos, state, player);
    }

    private void a(EntityHuman player, IBlockData state, World level, BlockPosition pos) {
        if (!player.gD() && !player.at() && state.c(d).booleanValue() && level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            this.a(serverLevel, pos, level.z.a(20, 24));
        }
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        int n2;
        if (state.c(c) == CreakingHeartState.a) {
            return 0;
        }
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity;
            n2 = creakingHeartBlockEntity.d();
        } else {
            n2 = 0;
        }
        return n2;
    }
}

