/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class MultifaceBlock
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<MultifaceBlock> b = MultifaceBlock.b(MultifaceBlock::new);
    public static final BlockStateBoolean c = BlockProperties.I;
    private static final Map<EnumDirection, BlockStateBoolean> a = BlockSprawling.h;
    protected static final EnumDirection[] d = EnumDirection.values();
    private final Function<IBlockData, VoxelShape> e;
    private final boolean f;
    private final boolean g;
    private final boolean h;

    protected MapCodec<? extends MultifaceBlock> a() {
        return b;
    }

    public MultifaceBlock(BlockBase.Info properties) {
        super(properties);
        this.l(MultifaceBlock.a(this.C));
        this.e = this.q();
        this.f = EnumDirection.EnumDirectionLimit.a.a().allMatch(this::a);
        this.g = EnumDirection.EnumDirectionLimit.a.a().filter(EnumDirection.EnumAxis.a).filter(this::a).count() % 2L == 0L;
        this.h = EnumDirection.EnumDirectionLimit.a.a().filter(EnumDirection.EnumAxis.c).filter(this::a).count() % 2L == 0L;
    }

    private Function<IBlockData, VoxelShape> q() {
        Map<EnumDirection, VoxelShape> map = VoxelShapes.d(Block.c(16.0, 0.0, 1.0));
        return this.a((IBlockData blockState) -> {
            VoxelShape voxelShape = VoxelShapes.a();
            for (EnumDirection direction : d) {
                if (!MultifaceBlock.a(blockState, direction)) continue;
                voxelShape = VoxelShapes.a(voxelShape, (VoxelShape)map.get(direction));
            }
            return voxelShape.c() ? VoxelShapes.b() : voxelShape;
        }, c);
    }

    public static Set<EnumDirection> p(IBlockData state) {
        if (!(state.b() instanceof MultifaceBlock)) {
            return Set.of();
        }
        EnumSet<EnumDirection> set = EnumSet.noneOf(EnumDirection.class);
        for (EnumDirection direction : EnumDirection.values()) {
            if (!MultifaceBlock.a(state, direction)) continue;
            set.add(direction);
        }
        return set;
    }

    public static Set<EnumDirection> a(byte packedDirections) {
        EnumSet<EnumDirection> set = EnumSet.noneOf(EnumDirection.class);
        for (EnumDirection direction : EnumDirection.values()) {
            if ((packedDirections & (byte)(1 << direction.ordinal())) <= 0) continue;
            set.add(direction);
        }
        return set;
    }

    public static byte a(Collection<EnumDirection> directions) {
        byte b2 = 0;
        for (EnumDirection direction : directions) {
            b2 = (byte)(b2 | 1 << direction.ordinal());
        }
        return b2;
    }

    protected boolean a(EnumDirection face) {
        return true;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        for (EnumDirection direction : d) {
            if (!this.a(direction)) continue;
            builder.a(new IBlockState[]{MultifaceBlock.b(direction)});
        }
        builder.a(new IBlockState[]{c});
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(c).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        if (!MultifaceBlock.r(state)) {
            return Blocks.a.m();
        }
        return MultifaceBlock.a(state, direction) && !MultifaceBlock.a(level, direction, neighborPos, neighborState) ? MultifaceBlock.a(state, MultifaceBlock.b(direction)) : state;
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(c) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.e.apply(state);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        boolean flag = false;
        for (EnumDirection direction : d) {
            if (!MultifaceBlock.a(state, direction)) continue;
            if (!MultifaceBlock.a((IBlockAccess)level, pos, direction)) {
                return false;
            }
            flag = true;
        }
        return flag;
    }

    @Override
    protected boolean a(IBlockData state, BlockActionContext useContext) {
        return !useContext.n().a(this.h()) || MultifaceBlock.s(state);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        World level = context.q();
        BlockPosition clickedPos = context.a();
        IBlockData blockState = level.a_(clickedPos);
        return Arrays.stream(context.f()).map(lookingDirection -> this.c(blockState, (IBlockAccess)level, clickedPos, (EnumDirection)lookingDirection)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean a(IBlockAccess level, IBlockData state, BlockPosition pos, EnumDirection direction) {
        if (!(!this.a(direction) || state.a(this) && MultifaceBlock.a(state, direction))) {
            BlockPosition blockPos = pos.a(direction);
            return MultifaceBlock.a(level, direction, blockPos, level.a_(blockPos));
        }
        return false;
    }

    @Nullable
    public IBlockData c(IBlockData currentState, IBlockAccess level, BlockPosition pos, EnumDirection lookingDirection) {
        if (!this.a(level, currentState, pos, lookingDirection)) {
            return null;
        }
        IBlockData blockState = currentState.a(this) ? currentState : (currentState.y().a(FluidTypes.c) ? (IBlockData)this.m().b(BlockProperties.I, true) : this.m());
        return (IBlockData)blockState.b(MultifaceBlock.b(lookingDirection), true);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return !this.f ? state : this.a(state, rotation::a);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        if (mirror == EnumBlockMirror.c && !this.g) {
            return state;
        }
        return mirror == EnumBlockMirror.b && !this.h ? state : this.a(state, mirror::b);
    }

    private IBlockData a(IBlockData state, Function<EnumDirection, EnumDirection> directionalFunction) {
        IBlockData blockState = state;
        for (EnumDirection direction : d) {
            if (!this.a(direction)) continue;
            blockState = (IBlockData)blockState.b(MultifaceBlock.b(directionalFunction.apply(direction)), state.c(MultifaceBlock.b(direction)));
        }
        return blockState;
    }

    public static boolean a(IBlockData state, EnumDirection direction) {
        BlockStateBoolean faceProperty = MultifaceBlock.b(direction);
        return state.a(faceProperty, false);
    }

    public static boolean a(IBlockAccess level, BlockPosition pos, EnumDirection direction) {
        BlockPosition blockPos = pos.a(direction);
        IBlockData blockState = level.a_(blockPos);
        return MultifaceBlock.a(level, direction, blockPos, blockState);
    }

    public static boolean a(IBlockAccess level, EnumDirection direction, BlockPosition pos, IBlockData state) {
        return Block.a(state.h(level, pos), direction.g()) || Block.a(state.g(level, pos), direction.g());
    }

    private static IBlockData a(IBlockData state, BlockStateBoolean faceProp) {
        IBlockData blockState = (IBlockData)state.b(faceProp, false);
        return MultifaceBlock.r(blockState) ? blockState : Blocks.a.m();
    }

    public static BlockStateBoolean b(EnumDirection direction) {
        return a.get(direction);
    }

    private static IBlockData a(BlockStateList<Block, IBlockData> stateDefinition) {
        IBlockData blockState = (IBlockData)stateDefinition.b().b(c, false);
        for (BlockStateBoolean booleanProperty : a.values()) {
            blockState = (IBlockData)blockState.c(booleanProperty, false);
        }
        return blockState;
    }

    protected static boolean r(IBlockData state) {
        for (EnumDirection direction : d) {
            if (!MultifaceBlock.a(state, direction)) continue;
            return true;
        }
        return false;
    }

    private static boolean s(IBlockData state) {
        for (EnumDirection direction : d) {
            if (MultifaceBlock.a(state, direction)) continue;
            return true;
        }
        return false;
    }
}

