/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapeCollisionEntity;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Entity;

public class PowderSnowBlock
extends Block
implements IFluidSource {
    public static final MapCodec<PowderSnowBlock> a = PowderSnowBlock.b(PowderSnowBlock::new);
    private static final float b = 0.083333336f;
    private static final float c = 0.9f;
    private static final float d = 1.5f;
    private static final float e = 2.5f;
    private static final VoxelShape f = VoxelShapes.a(0.0, 0.0, 0.0, 1.0, 0.9f, 1.0);
    private static final double g = 4.0;
    private static final double h = 7.0;

    public MapCodec<PowderSnowBlock> a() {
        return a;
    }

    public PowderSnowBlock(BlockBase.Info properties) {
        super(properties);
    }

    @Override
    protected boolean b(IBlockData state, IBlockData adjacentState, EnumDirection direction) {
        return adjacentState.a(this) || super.b(state, adjacentState, direction);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                player.resendPossiblyDesyncedDataValues(List.of(net.minecraft.world.entity.Entity.bq), player);
            }
            return;
        }
        if (!(entity instanceof EntityLiving) || entity.dG().a(this)) {
            entity.a(state, new Vec3D(0.9f, 1.5, 0.9f));
            if (level.D_()) {
                boolean flag;
                RandomSource random = level.I_();
                boolean bl = flag = entity.ao != entity.dK() || entity.aq != entity.dQ();
                if (flag && random.h()) {
                    level.a(Particles.aO, entity.dK(), (double)(pos.v() + 1), entity.dQ(), (double)(MathHelper.b(random, -1.0f, 1.0f) * 0.083333336f), (double)0.05f, MathHelper.b(random, -1.0f, 1.0f) * 0.083333336f);
                }
            }
        }
        BlockPosition blockPos = pos.j();
        effectApplier.a(InsideBlockEffectType.e, (net.minecraft.world.entity.Entity entity1) -> {
            if (level instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)level;
                if (entity1.ck() && entity1.c(serverLevel, blockPos)) {
                    if (!CraftEventFactory.callEntityChangeBlockEvent(entity1, pos, Blocks.a.m(), !serverLevel.S().getBoolean(GameRules.d, serverLevel.purpurConfig.powderSnowMobGriefingOverride) && !(entity1 instanceof EntityHuman))) {
                        return;
                    }
                    level.b(blockPos, false);
                }
            }
        });
        effectApplier.a(InsideBlockEffectType.a);
        effectApplier.a(InsideBlockEffectType.e);
    }

    @Override
    public void a(World level, IBlockData state, BlockPosition pos, net.minecraft.world.entity.Entity entity, double fallDistance) {
        if (!(fallDistance < 4.0) && entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            EntityLiving.a fallSounds = livingEntity.fc();
            SoundEffect soundEvent = fallDistance < 7.0 ? fallSounds.a() : fallSounds.b();
            entity.a(soundEvent, 1.0f, 1.0f);
        }
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        VoxelShape collisionShape = this.b(state, level, pos, VoxelShapeCollision.a(entity));
        return collisionShape.c() ? VoxelShapes.b() : collisionShape;
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        VoxelShapeCollisionEntity entityCollisionContext;
        net.minecraft.world.entity.Entity entity;
        if (!context.e() && context instanceof VoxelShapeCollisionEntity && (entity = (entityCollisionContext = (VoxelShapeCollisionEntity)context).f()) != null) {
            if (entity.an > 2.5) {
                return f;
            }
            boolean flag = entity instanceof EntityFallingBlock;
            if (flag || PowderSnowBlock.a(entity) && context.a(VoxelShapes.b(), pos, false) && !context.c()) {
                return super.b(state, level, pos, context);
            }
        }
        return VoxelShapes.a();
    }

    @Override
    protected VoxelShape c(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return VoxelShapes.a();
    }

    public static boolean a(net.minecraft.world.entity.Entity entity) {
        return entity.ax().a(TagsEntity.h) || entity instanceof EntityLiving && ((EntityLiving)entity).a(EnumItemSlot.c).a(Items.rh);
    }

    @Override
    public ItemStack a(@Nullable EntityLiving owner, GeneratorAccess level, BlockPosition pos, IBlockData state) {
        level.a(pos, Blocks.a.m(), 11);
        if (!level.D_()) {
            level.c(2001, pos, Block.j(state));
        }
        return new ItemStack(Items.sn);
    }

    @Override
    public Optional<SoundEffect> au_() {
        return Optional.of(SoundEffects.do);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return true;
    }
}

