/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockNote;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;

public class SculkSensorBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<SculkSensorBlock> c = SculkSensorBlock.b(SculkSensorBlock::new);
    public static final int d = 30;
    public static final int e = 10;
    public static final BlockStateEnum<SculkSensorPhase> f = BlockProperties.bt;
    public static final BlockStateInteger g = BlockProperties.aX;
    public static final BlockStateBoolean h = BlockProperties.I;
    private static final VoxelShape a = Block.b(16.0, 0.0, 8.0);
    private static final float[] b = SystemUtils.a(new float[16], (? super T pitchBends) -> {
        int[] ints = new int[]{0, 0, 2, 4, 6, 7, 9, 10, 12, 14, 15, 18, 19, 21, 22, 24};
        for (int i2 = 0; i2 < 16; ++i2) {
            pitchBends[i2] = BlockNote.b(ints[i2]);
        }
    });

    public MapCodec<? extends SculkSensorBlock> a() {
        return c;
    }

    public SculkSensorBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(f, SculkSensorPhase.a)).b(g, 0)).b(h, false));
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        BlockPosition clickedPos = context.a();
        Fluid fluidState = context.q().b_(clickedPos);
        return (IBlockData)this.m().b(h, fluidState.a() == FluidTypes.c);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(h) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (SculkSensorBlock.p(state) != SculkSensorPhase.b) {
            if (SculkSensorBlock.p(state) == SculkSensorPhase.c) {
                level.a(pos, (IBlockData)state.b(f, SculkSensorPhase.a), 3);
                if (!state.c(h).booleanValue()) {
                    level.a(null, pos, SoundEffects.ya, SoundCategory.e, 1.0f, level.z.i() * 0.2f + 0.8f);
                }
            }
        } else {
            SculkSensorBlock.a((World)level, pos, state);
        }
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, net.minecraft.world.entity.Entity entity) {
        TileEntity tileEntity;
        if (!level.D_() && SculkSensorBlock.r(state) && entity.ax() != EntityTypes.bL && (tileEntity = level.c_(pos)) instanceof SculkSensorBlockEntity) {
            SculkSensorBlockEntity sculkSensorBlockEntity = (SculkSensorBlockEntity)tileEntity;
            if (level instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)level;
                if (sculkSensorBlockEntity.gK().a(serverLevel, pos, GameEvent.P, GameEvent.a.a(state))) {
                    EntityInteractEvent cancellable;
                    if (entity instanceof EntityHuman) {
                        EntityHuman player = (EntityHuman)entity;
                        cancellable = CraftEventFactory.callPlayerInteractEvent(player, Action.PHYSICAL, pos, null, null, null);
                    } else {
                        cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos));
                        level.getCraftServer().getPluginManager().callEvent((Event)cancellable);
                    }
                    if (cancellable.isCancelled()) {
                        return;
                    }
                    sculkSensorBlockEntity.f().b(serverLevel, GameEvent.P, GameEvent.a.a(entity), entity.dD());
                }
            }
        }
        super.a(level, pos, state, entity);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        if (!(level.D_() || state.a(oldState.b()) || state.c(g) <= 0 || level.Z().a(pos, this))) {
            level.a(pos, (IBlockData)state.b(g, 0), 18);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        if (SculkSensorBlock.p(state) == SculkSensorPhase.b) {
            SculkSensorBlock.b(level, pos, state);
        }
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(h).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    private static void b(World level, BlockPosition pos, IBlockData state) {
        Block block = state.b();
        level.a(pos, block);
        level.a(pos.e(), block);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new SculkSensorBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return !level.D_() ? SculkSensorBlock.a(blockEntityType, TileEntityTypes.J, (World level1, BlockPosition pos, IBlockData state1, ? super E blockEntity) -> VibrationSystem.c.a(level1, blockEntity.gJ(), blockEntity.gK())) : null;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return a;
    }

    @Override
    protected boolean e_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection direction) {
        return state.c(g);
    }

    @Override
    public int b(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection direction) {
        return direction == EnumDirection.b ? state.a(level, pos, direction) : 0;
    }

    public static SculkSensorPhase p(IBlockData state) {
        return state.c(f);
    }

    public static boolean r(IBlockData state) {
        return state.b() instanceof SculkSensorBlock && SculkSensorBlock.p(state) == SculkSensorPhase.a;
    }

    public static void a(World level, BlockPosition pos, IBlockData state) {
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), state.c(g).intValue(), 0);
        level.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0) {
            level.a(pos, (IBlockData)state.b(g, eventRedstone.getNewCurrent()), 3);
            return;
        }
        level.a(pos, (IBlockData)((IBlockData)state.b(f, SculkSensorPhase.c)).b(g, 0), 3);
        level.a(pos, state.b(), 10);
        SculkSensorBlock.b(level, pos, state);
    }

    @VisibleForTesting
    public int c() {
        return 30;
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity, World level, BlockPosition pos, IBlockData state, int power, int frequency) {
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), state.c(g).intValue(), power);
        level.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() <= 0) {
            return;
        }
        power = eventRedstone.getNewCurrent();
        level.a(pos, (IBlockData)((IBlockData)state.b(f, SculkSensorPhase.b)).b(g, power), 3);
        level.a(pos, state.b(), this.c());
        SculkSensorBlock.b(level, pos, state);
        SculkSensorBlock.a(entity, level, pos, frequency);
        level.a(entity, GameEvent.L, pos);
        if (!state.c(h).booleanValue()) {
            level.a(null, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.xZ, SoundCategory.e, 1.0f, level.z.i() * 0.2f + 0.8f);
        }
    }

    public static void a(@Nullable net.minecraft.world.entity.Entity entity, World level, BlockPosition pos, int frequency) {
        for (EnumDirection direction : EnumDirection.values()) {
            BlockPosition blockPos = pos.a(direction);
            IBlockData blockState = level.a_(blockPos);
            if (!blockState.a(TagsBlock.cj)) continue;
            level.a(VibrationSystem.b(frequency), blockPos, GameEvent.a.a(entity, blockState));
            float f2 = b[frequency];
            level.a(null, blockPos, SoundEffects.I, SoundCategory.e, 1.0f, f2);
        }
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        EnumDirection random1;
        if (SculkSensorBlock.p(state) == SculkSensorPhase.b && (random1 = EnumDirection.b(random)) != EnumDirection.b && random1 != EnumDirection.a) {
            double d2 = (double)pos.u() + 0.5 + (random1.j() == 0 ? 0.5 - random.j() : (double)random1.j() * 0.6);
            double d1 = (double)pos.v() + 0.25;
            double d22 = (double)pos.w() + 0.5 + (random1.l() == 0 ? 0.5 - random.j() : (double)random1.l() * 0.6);
            double d3 = (double)random.i() * 0.04;
            level.a(DustColorTransitionOptions.b, d2, d1, d22, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(f, g, h);
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof SculkSensorBlockEntity) {
            SculkSensorBlockEntity sculkSensorBlockEntity = (SculkSensorBlockEntity)tileEntity;
            return SculkSensorBlock.p(state) == SculkSensorPhase.b ? sculkSensorBlockEntity.d() : 0;
        }
        return 0;
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    protected boolean g_(IBlockData state) {
        return true;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, ItemStack stack, boolean dropExperience) {
        super.a(state, level, pos, stack, dropExperience);
    }

    @Override
    public int getExpDrop(IBlockData state, WorldServer level, BlockPosition pos, ItemStack stack, boolean dropExperience) {
        if (dropExperience) {
            return this.tryDropExperience(level, pos, stack, ConstantInt.a(5));
        }
        return 0;
    }
}

